/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.view;

import com.ur.polyscope.calibration.internal.CalibrationImageResource;
import com.ur.polyscope.calibration.view.IconConverter;
import com.ur.polyscope.program.commandview.ProgramTreeNodeRenderer;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Icon;

public class IdentifyIconAndText {
    private static final ProgramTreeNodeRenderer DEFAULT_RENDERER = new DefaultProgramNodeRenderer();
    private Map<Icon, Icon> convertedIcons = new HashMap<Icon, Icon>();
    private final Icon definedIcon;
    private final Icon definedOpenIcon;
    private final Set<ProgramTreeNodeRenderer> rendererSet;

    @Inject
    IdentifyIconAndText(Set<ProgramTreeNodeRenderer> rendererSet) {
        this.rendererSet = rendererSet;
        this.definedIcon = IconConverter.convert(CalibrationImageResource.programSet());
        this.definedOpenIcon = IconConverter.convert(CalibrationImageResource.programRobot());
    }

    public Icon getIcon(AbstractProgramNode programNode, boolean isLeaf) {
        ProgramTreeNodeRenderer renderer = this.getRenderer(programNode);
        Icon icon = renderer.getIcon(programNode, true);
        if (icon == null) {
            return isLeaf || !programNode.isTreeExpandable() ? this.definedIcon : this.definedOpenIcon;
        }
        return this.convertedIcon(icon);
    }

    private Icon convertedIcon(Icon icon) {
        if (icon == null) {
            return icon;
        }
        if (!this.convertedIcons.containsKey(icon)) {
            this.convertedIcons.put(icon, IconConverter.convert(icon));
        }
        return this.convertedIcons.get(icon);
    }

    public String getText(AbstractProgramNode programNode) {
        ProgramTreeNodeRenderer renderer = this.getRenderer(programNode);
        return renderer.getText(programNode, true);
    }

    ProgramTreeNodeRenderer getRenderer(AbstractProgramNode programNode) {
        Object userObject = programNode.getUserObject();
        if (userObject == null) {
            ProgramTreeNodeRenderer renderer = this.findRenderer(programNode);
            programNode.setUserObject((Object)renderer);
            return renderer;
        }
        if (userObject instanceof ProgramTreeNodeRenderer) {
            return (ProgramTreeNodeRenderer)userObject;
        }
        return this.findRenderer(programNode);
    }

    private ProgramTreeNodeRenderer findRenderer(AbstractProgramNode programNode) {
        for (ProgramTreeNodeRenderer each : this.rendererSet) {
            if (!each.isSupported(programNode)) continue;
            return each;
        }
        return DEFAULT_RENDERER;
    }

    private static class DefaultProgramNodeRenderer
    implements ProgramTreeNodeRenderer {
        private DefaultProgramNodeRenderer() {
        }

        public boolean isSupported(AbstractProgramNode abstractProgramNode) {
            return true;
        }

        public Icon getIcon(AbstractProgramNode abstractProgramNode, boolean isNodeDefined) {
            return null;
        }

        public String getText(AbstractProgramNode abstractProgramNode, boolean isNodeDefined) {
            return abstractProgramNode.toString();
        }
    }
}

