/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.calibration.view;

import com.ur.polyscope.calibration.NotAFixedWaypointNode;
import com.ur.polyscope.calibration.ProgramTransKeyPairNode;
import com.ur.polyscope.calibration.ProgramTransProgramContainerNode;
import com.ur.polyscope.calibration.ProgramTransSettingsAndOverviewNode;
import com.ur.polyscope.calibration.RealNodeWrapperTreeNode;
import com.ur.polyscope.calibration.internal.CalibrationImageResource;
import com.ur.polyscope.calibration.view.IconConverter;
import com.ur.polyscope.calibration.view.IdentifyColor;
import com.ur.polyscope.calibration.view.IdentifyFont;
import com.ur.polyscope.calibration.view.IdentifyIconAndText;
import com.ur.polyscope.program.ProgramLoadingContext;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import gui.program.SuppressedNode;
import gui.program.position.WaypointNode;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProgramCorrectionTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color BORDER_SELECTION_COLOR = new Color(99, 130, 191);
    private static final Color BACKGROUND_SELECTION_COLOR = new Color(184, 207, 229);
    private final Provider<ProgramLoadingContext> programLoadingContext;
    private final Border defaultBorder;
    private final CompoundBorder errorBorder;
    private final Provider<IdentifyFont> identifyFont;
    private final Provider<IdentifyIconAndText> identifyRenderer;
    private final IdentifyColor identifyColor;
    private Icon notFixedWaypointIcon;

    @Inject
    public ProgramCorrectionTreeCellRenderer(Provider<IdentifyIconAndText> identifyRenderer, Provider<IdentifyFont> identifyFont, Provider<ProgramLoadingContext> programLoadingContext) {
        this.identifyRenderer = identifyRenderer;
        this.identifyFont = identifyFont;
        this.identifyColor = new IdentifyColor(this);
        this.programLoadingContext = programLoadingContext;
        this.defaultBorder = this.getBorder();
        this.errorBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), this.defaultBorder);
        this.notFixedWaypointIcon = IconConverter.convert(CalibrationImageResource.programWaypoint());
        this.setForeground(Color.black);
        this.setBorderSelectionColor(BORDER_SELECTION_COLOR);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setBackgroundSelectionColor(Color.WHITE);
        if (value instanceof RealNodeWrapperTreeNode) {
            this.hasFocus = hasFocus;
            this.selected = selected;
            this.renderRealProgramNode(tree, value, selected, leaf);
        } else {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof ProgramTransSettingsAndOverviewNode || value instanceof ProgramTransProgramContainerNode) {
                this.setIcon(CalibrationImageResource.programRobot());
                this.setFont(((IdentifyFont)this.identifyFont.get()).topLevelNodeFont);
                this.setText(value.toString());
            }
            if (selected) {
                this.setBackgroundSelectionColor(BACKGROUND_SELECTION_COLOR);
            }
        }
        this.accessibleContext = null;
        return this;
    }

    private void renderRealProgramNode(JTree tree, Object value, boolean selected, boolean leaf) {
        AbstractProgramNode realNode = ((RealNodeWrapperTreeNode)value).getRealNode();
        if (realNode == null) {
            this.setText("Unknown: " + value.toString());
        } else {
            boolean isNodeDefined = ((ProgramLoadingContext)this.programLoadingContext.get()).isLoading() || realNode.isDefined();
            this.setFont(((IdentifyFont)this.identifyFont.get()).selectFontFor(realNode, isNodeDefined));
            this.setForeground(this.identifyColor.getForegroundColor(selected, realNode));
            this.setComponentOrientation(tree.getComponentOrientation());
            this.setEnabled(!(realNode instanceof SuppressedNode));
            this.setBorder(realNode.hasScriptError() ? this.errorBorder : this.defaultBorder);
            this.setIcon(((IdentifyIconAndText)this.identifyRenderer.get()).getIcon(realNode, leaf));
            this.setText(((IdentifyIconAndText)this.identifyRenderer.get()).getText(realNode));
            if (value instanceof NotAFixedWaypointNode) {
                this.setForeground(Color.LIGHT_GRAY);
                if (realNode instanceof WaypointNode) {
                    this.setIcon(this.notFixedWaypointIcon);
                }
            } else {
                if (selected) {
                    this.setBackgroundSelectionColor(BACKGROUND_SELECTION_COLOR);
                }
                if (value instanceof ProgramTransKeyPairNode && !((ProgramTransKeyPairNode)value).isReattached()) {
                    this.setFont(this.getFont().deriveFont(2));
                    this.setIcon(CalibrationImageResource.programWaypointUndefined());
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setIcon(CalibrationImageResource.programWaypoint());
                }
            }
        }
    }
}

