/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.viewfacade.lang;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.stream.Collectors;

public interface Errorable {
    public Status getStatus();

    public void addStatusListener(StatusListener var1);

    public void removeStatusListener(StatusListener var1);

    public static class CompositeErrorable
    implements Errorable,
    StatusListener {
        private final List<StatusListener> listeners = new ArrayList<StatusListener>();
        private final List<Errorable> containedErrorables = new ArrayList<Errorable>();

        public void add(Errorable erroable) {
            if (!this.containedErrorables.contains(erroable)) {
                erroable.addStatusListener(this);
                this.containedErrorables.add(erroable);
            }
        }

        @Override
        public Status getStatus() {
            Status combinedStatus = Status.OK;
            for (Errorable each : this.containedErrorables) {
                if (each.getStatus() == Status.ERROR) {
                    combinedStatus = Status.ERROR;
                    break;
                }
                if (each.getStatus() != Status.WARNING) continue;
                combinedStatus = Status.WARNING;
            }
            return combinedStatus;
        }

        @Override
        public void addStatusListener(StatusListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @Override
        public void removeStatusListener(StatusListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void statusChanged(Status status) {
            Status combinedStatus = this.getStatus();
            for (StatusListener each : this.listeners) {
                each.statusChanged(combinedStatus);
            }
        }

        public List<Errorable> getPanelsWithErrors() {
            return this.containedErrorables.stream().filter(it -> it.getStatus() == Status.ERROR).collect(Collectors.toList());
        }
    }

    public static enum Status {
        ERROR,
        WARNING,
        OK;

    }

    public static interface StatusListener
    extends EventListener {
        public void statusChanged(Status var1);
    }
}

