/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.viewfacade.lang;

import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.swing.CardPanel;
import com.ur.swing.flippable.FlippablePanel;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class ErrorablePanel
extends FlippablePanel
implements Errorable {
    private final Errorable.CompositeErrorable allErrorables = new Errorable.CompositeErrorable();

    @Override
    public Errorable.Status getStatus() {
        return this.allErrorables.getStatus();
    }

    @Override
    public void addStatusListener(Errorable.StatusListener listener) {
        this.allErrorables.addStatusListener(listener);
    }

    @Override
    public void removeStatusListener(Errorable.StatusListener listener) {
        this.allErrorables.removeStatusListener(listener);
    }

    public void addCardPanel(CardPanel cardPanel) {
        super.addCardPanel(cardPanel);
        if (cardPanel instanceof Errorable) {
            this.allErrorables.add((Errorable)cardPanel);
        }
    }

    public boolean hasErrors() {
        return this.getStatus() == Errorable.Status.ERROR;
    }

    public Optional<Errorable> getFirstPanelWithErrors() {
        if (this.isShowingPanelWithErrors()) {
            return Optional.empty();
        }
        return this.allErrorables.getPanelsWithErrors().stream().findFirst();
    }

    private boolean isShowingPanelWithErrors() {
        if (Objects.isNull(this.getCurrentCard()) || !this.getCurrentCard().isShowing()) {
            return false;
        }
        Class<?> currentCardClass = this.getCurrentCard().getClass();
        return this.allErrorables.getPanelsWithErrors().stream().anyMatch(panel -> panel.getClass() == currentCardClass);
    }
}

