/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.viewfacade.lang;

import com.ur.util.logging.Log;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class EventListenerMemoryLeakChecker {
    static boolean enabled = true;
    private static Map<Component, Integer> listenerCount = new HashMap<Component, Integer>();

    private static int getListenerCount(JComponent jc, Class<? extends EventListener> ... listeners) {
        int count = 0;
        Class<? extends EventListener>[] classArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends EventListener> l = classArray[n2];
            count += jc.getListeners(l).length;
            ++n2;
        }
        return count;
    }

    private static int getJComponentCount(JComponent c) {
        return EventListenerMemoryLeakChecker.getListenerCount(c, AncestorListener.class, ComponentListener.class, FocusListener.class, ContainerListener.class, KeyListener.class, MouseListener.class, HierarchyListener.class, PropertyChangeListener.class);
    }

    private static int getJTextComponentCount(JTextComponent c) {
        return EventListenerMemoryLeakChecker.getListenerCount(c, CaretListener.class) + EventListenerMemoryLeakChecker.getJComponentCount(c);
    }

    private static int getAbstractButtonCount(AbstractButton c) {
        return EventListenerMemoryLeakChecker.getListenerCount(c, ActionListener.class, ChangeListener.class, ItemListener.class) + EventListenerMemoryLeakChecker.getJComponentCount(c);
    }

    private static int getJTextFieldCount(JTextField c) {
        return EventListenerMemoryLeakChecker.getListenerCount(c, ActionListener.class) + EventListenerMemoryLeakChecker.getJTextComponentCount(c);
    }

    private static int getJButtonCount(JButton c) {
        return EventListenerMemoryLeakChecker.getAbstractButtonCount(c);
    }

    private static int getJComboBoxCount(JComboBox c) {
        return EventListenerMemoryLeakChecker.getListenerCount(c, ActionListener.class, PopupMenuListener.class, ItemListener.class) + EventListenerMemoryLeakChecker.getJComponentCount(c);
    }

    private static void checkComponentCount(Component c, int newCount) {
        if (listenerCount.containsKey(c)) {
            if (listenerCount.get(c) != newCount) {
                Log.error((String)("Memeory leak in component " + c.getName() + "New listener count is " + newCount));
                listenerCount.put(c, newCount);
            }
        } else {
            listenerCount.put(c, newCount);
        }
    }

    private static int getNewListenerCount(Component c) {
        if (c instanceof JTextField) {
            return EventListenerMemoryLeakChecker.getJTextFieldCount((JTextField)c);
        }
        if (c instanceof JButton) {
            return EventListenerMemoryLeakChecker.getJButtonCount((JButton)c);
        }
        if (c instanceof JComboBox) {
            return EventListenerMemoryLeakChecker.getJComboBoxCount((JComboBox)c);
        }
        return 0;
    }

    public static void checkComponents(Component ... components) {
        if (enabled) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                int count = EventListenerMemoryLeakChecker.getNewListenerCount(c);
                EventListenerMemoryLeakChecker.checkComponentCount(c, count);
                ++n2;
            }
        }
    }
}

