/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.viewfacade.lang;

import com.ur.lang.PrimitiveUtils;
import com.ur.math.Revolution;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Vector3;
import com.ur.util.logging.Log;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class URMath {
    public static final double EQUALS_PRECISION = 1.0E-5;
    public static final int HASH_CODE_PRECISION = PrimitiveUtils.getDecimals((double)1.0E-5);
    public static final double RAD_PER_DEGREE = Math.PI / 180;
    public static final double DEGREES_PER_RAD = 57.29577951308232;
    public static final double PI_2 = Math.PI * 2;

    private URMath() {
    }

    @Deprecated
    public static int revolutionsFromRadiansLegacy3_0(double angle) {
        int result = 0;
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
            ++result;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
            --result;
        }
        return result;
    }

    @Deprecated
    public static double normalizeInRadiansLegacy3_0(double angle) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double unwrapAngle(double angle) {
        Revolution r = new Revolution(angle);
        return r.getOffsetAngle();
    }

    public static float unwrapAngle(float angle) {
        Revolution r = new Revolution((double)angle);
        return (float)r.getOffsetAngle();
    }

    public static float[] unwrapJointPositionVector(JointPositionVector jointPositionVector) {
        double[] joints = jointPositionVector.getJoints();
        float[] safeHomePositionTmp = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        int i = 0;
        while (i < joints.length) {
            safeHomePositionTmp[i] = (float)URMath.unwrapAngle(joints[i]);
            ++i;
        }
        return safeHomePositionTmp;
    }

    public static boolean arrayEpsilonEquals(float[] a, float[] b, float epsilon) {
        boolean equal = true;
        int i = 0;
        while (i < a.length) {
            if (Math.abs(a[i] - b[i]) > epsilon) {
                equal = false;
            }
            ++i;
        }
        return equal;
    }

    public static Transform3D getTransform(Pose6d pose) {
        return URMath.getTransform(pose.getPos(), pose.getRot());
    }

    public static Transform3D getTransform(Point3d position, Point3d rotationVector) {
        return URMath.getTransform(new Vector3d((Tuple3d)position), new Vector3d((Tuple3d)rotationVector));
    }

    public static Transform3D getTransform(Vector3d position, Vector3d rotationVector) {
        Transform3D toolTransform = new Transform3D();
        double angle = rotationVector.length();
        AxisAngle4d toolAxisAngleVec = new AxisAngle4d(rotationVector, angle);
        toolTransform.set(toolAxisAngleVec);
        toolTransform.setTranslation(position);
        return toolTransform;
    }

    public static Matrix3d getRotationMatrixForZAxis(Vector3 newZAxis) {
        Vector3d zAxis = newZAxis.toVector3d();
        Vector3d xAxis = new Vector3d();
        xAxis.cross(zAxis, Vector3.Z_AXIS.toVector3d());
        if (xAxis.lengthSquared() <= 1.0E-5) {
            xAxis = Vector3.X_AXIS.toVector3d();
        } else {
            xAxis.normalize();
        }
        Vector3d yAxis = new Vector3d();
        yAxis.cross(zAxis, xAxis);
        yAxis.normalize();
        Matrix3d visualizationTransformRotation = new Matrix3d();
        visualizationTransformRotation.setColumn(0, xAxis);
        visualizationTransformRotation.setColumn(1, yAxis);
        visualizationTransformRotation.setColumn(2, zAxis);
        return visualizationTransformRotation;
    }

    public static Vector3 getRotationVectorForZAxis(Vector3 zAxis) {
        Vector3d rotationAxis = new Vector3d();
        rotationAxis.cross(Vector3.Z_AXIS.toVector3d(), zAxis.toVector3d());
        if (rotationAxis.lengthSquared() <= 1.0E-5) {
            if (zAxis.angle(Vector3.Z_AXIS) <= 1.5707963267948966) {
                rotationAxis.set(0.0, 0.0, 0.0);
            } else {
                rotationAxis.set(Math.PI, 0.0, 0.0);
            }
        } else {
            rotationAxis.normalize();
            rotationAxis.scale(zAxis.angle(Vector3.Z_AXIS));
        }
        return Vector3.fromVector3d((Vector3d)rotationAxis);
    }

    public static Vector3 rotate(Vector3 inputVector, Vector3 rotationVector) {
        Matrix3d rotationMatrix = URMath.getRotationMatrix(rotationVector);
        Vector3d input = inputVector.toVector3d();
        rotationMatrix.transform((Tuple3d)input);
        return Vector3.fromVector3d((Vector3d)input);
    }

    private static Matrix3d getRotationMatrix(Vector3 rotationVector) {
        Matrix3d result = new Matrix3d();
        result.set(URMath.getAxisAngle(rotationVector));
        return result;
    }

    private static AxisAngle4d getAxisAngle(Vector3 rotationVector) {
        return new AxisAngle4d(rotationVector.toVector3d(), rotationVector.length());
    }

    public static Vector3d getRotationVector(Matrix3d m) {
        double epsilon = 1.0E-6;
        double epsilon2 = 1.0E-6;
        if (Math.abs(m.m01 - m.m10) < epsilon && Math.abs(m.m02 - m.m20) < epsilon && Math.abs(m.m12 - m.m21) < epsilon) {
            double z;
            double y;
            double x;
            if (Math.abs(m.m01 + m.m10) < epsilon2 && Math.abs(m.m02 + m.m20) < epsilon2 && Math.abs(m.m12 + m.m21) < epsilon2 && Math.abs(m.m00 + m.m11 + m.m22 - 3.0) < epsilon2) {
                return new Vector3d(0.0, 0.0, 0.0);
            }
            double xx = (m.m00 + 1.0) / 2.0;
            double yy = (m.m11 + 1.0) / 2.0;
            double zz = (m.m22 + 1.0) / 2.0;
            double xy = (m.m01 + m.m10) / 4.0;
            double xz = (m.m02 + m.m20) / 4.0;
            double yz = (m.m12 + m.m21) / 4.0;
            if (xx > yy && xx > zz) {
                if (xx < epsilon) {
                    x = 0.0;
                    y = 0.7071;
                    z = 0.7071;
                } else {
                    x = Math.sqrt(xx);
                    y = xy / x;
                    z = xz / x;
                }
            } else if (yy > zz) {
                if (yy < epsilon) {
                    x = 0.7071;
                    y = 0.0;
                    z = 0.7071;
                } else {
                    y = Math.sqrt(yy);
                    x = xy / y;
                    z = yz / y;
                }
            } else if (zz < epsilon) {
                x = 0.7071;
                y = 0.7071;
                z = 0.0;
            } else {
                z = Math.sqrt(zz);
                x = xz / z;
                y = yz / z;
            }
            Vector3d rotationVector = new Vector3d(x, y, z);
            rotationVector.normalize();
            rotationVector.scale(Math.PI);
            return rotationVector;
        }
        double angle = Math.acos((m.m00 + m.m11 + m.m22 - 1.0) / 2.0);
        double denominator = Math.sqrt((m.m21 - m.m12) * (m.m21 - m.m12) + (m.m02 - m.m20) * (m.m02 - m.m20) + (m.m10 - m.m01) * (m.m10 - m.m01));
        double x = (m.m21 - m.m12) / denominator;
        double y = (m.m02 - m.m20) / denominator;
        double z = (m.m10 - m.m01) / denominator;
        Vector3d rotationVector = new Vector3d(x, y, z);
        rotationVector.normalize();
        rotationVector.scale(angle);
        return rotationVector;
    }

    public static AxisAngle4d getAxisAngle(Matrix3d m) {
        Vector3d rotationVector = URMath.getRotationVector(m);
        return new AxisAngle4d(rotationVector, rotationVector.length());
    }

    public static double getMaxValue(double[] testValues) {
        if (testValues == null || testValues.length == 0) {
            Log.error((String)"Array argument was either null or empty, returning 0.0");
            return 0.0;
        }
        double maxVal = testValues[0];
        double[] dArray = testValues;
        int n = testValues.length;
        int n2 = 0;
        while (n2 < n) {
            double testValue = dArray[n2];
            if (testValue > maxVal) {
                maxVal = testValue;
            }
            ++n2;
        }
        return maxVal;
    }

    public static double roundDouble(double value, int numberOfDecimals) {
        BigDecimal valueAsBigDecimal = BigDecimal.valueOf(value).setScale(numberOfDecimals, RoundingMode.FLOOR);
        return valueAsBigDecimal.doubleValue();
    }

    public static double roundUpDouble(double value, int numberOfDecimals) {
        BigDecimal valueAsBigDecimal = BigDecimal.valueOf(value).setScale(numberOfDecimals, RoundingMode.HALF_UP);
        return valueAsBigDecimal.doubleValue();
    }
}

