/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.viewfacade.move.wizard;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.move.legacy.MoveCallback;
import com.ur.polyscope.move.legacy.MoveRequester;
import com.ur.polyscope.move.legacy.PositionRequester;
import com.ur.polyscope.viewfacade.internal.TextResource;
import com.ur.polyscope.viewfacade.resources.ViewfacadeImageResource;
import com.ur.polyscope.visualizer.canvas.VisualizerFactory;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.wizard.AbstractWizardPage;
import com.ur.swing.wizard.ButtonEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SelectPoseWizardPage
extends AbstractWizardPage {
    public static final String BUTTON_SET_POSITION = "setPosition." + SelectPoseWizardPage.class.getSimpleName();
    public static final String BUTTON_MOVE_TO_POSITION = "moveToPosition." + SelectPoseWizardPage.class.getSimpleName();
    protected final TextResource textResource;
    private final CardPanel cardPanel;
    private JButton moveScreenButton;
    protected Pose6d pose = null;
    protected JointPositionVector jointPositionVector = null;
    private JPanel imagePanel;
    private JPanel imageCardPanel;
    protected ViewContext viewContext;
    private final VisualizerFactory visualizerFactory;
    private final Component robotCanvas3D;
    private final PositionRequester positionRequester;
    private final MoveRequester moveRequester;

    public SelectPoseWizardPage(String title, ViewContext viewContext, VisualizerFactory visualizerFactory, Component robotCanvas3D, String description, Icon image, CardPanel cardPanel, PositionRequester positionRequester, MoveRequester moveRequester) {
        super(title);
        JComponent topComponent;
        this.viewContext = viewContext;
        this.robotCanvas3D = robotCanvas3D;
        this.visualizerFactory = visualizerFactory;
        this.setIcon(ViewfacadeImageResource.grayLed());
        this.cardPanel = cardPanel;
        this.positionRequester = positionRequester;
        this.moveRequester = moveRequester;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.setLayout(new BorderLayout());
        JPanel northPane = new JPanel();
        northPane.setLayout(new BoxLayout(northPane, 1));
        JPanel centerPane = new JPanel();
        centerPane.setLayout(new GridLayout());
        JPanel leftPane = new JPanel();
        leftPane.setLayout(new BoxLayout(leftPane, 1));
        JPanel middlePane = new JPanel();
        middlePane.setLayout(new BoxLayout(middlePane, 1));
        JPanel rightPane = new JPanel();
        rightPane.setLayout(new BoxLayout(rightPane, 1));
        JLabel undefinedPoseLabel = new JLabel("?");
        undefinedPoseLabel.setFont(viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.HUGE));
        undefinedPoseLabel.setHorizontalAlignment(0);
        JPanel undefinedPosePanel = new JPanel();
        Dimension visualiserDimension = new Dimension(200, 200);
        undefinedPosePanel.setPreferredSize(visualiserDimension);
        undefinedPosePanel.setMaximumSize(visualiserDimension);
        undefinedPosePanel.setLayout(new BorderLayout());
        undefinedPosePanel.setAlignmentX(0.5f);
        undefinedPosePanel.add(undefinedPoseLabel);
        this.imagePanel = new JPanel();
        this.imagePanel.setPreferredSize(visualiserDimension);
        this.imagePanel.setMaximumSize(visualiserDimension);
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setAlignmentX(0.5f);
        this.imageCardPanel = new JPanel(new CardLayout());
        this.imageCardPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.imageCardPanel.setMinimumSize(visualiserDimension);
        this.imageCardPanel.setPreferredSize(visualiserDimension);
        this.imageCardPanel.setMaximumSize(visualiserDimension);
        this.imageCardPanel.setAlignmentX(0.5f);
        this.imageCardPanel.add((Component)undefinedPosePanel, "UNDEFINED");
        this.imageCardPanel.add((Component)this.imagePanel, "3D");
        this.moveScreenButton = new JButton(this.textResource.wizardPointSetPosition());
        Dimension buttonDimension = new Dimension(200, 40);
        this.moveScreenButton.setMinimumSize(buttonDimension);
        this.moveScreenButton.setPreferredSize(buttonDimension);
        this.moveScreenButton.setMaximumSize(buttonDimension);
        this.moveScreenButton.setAlignmentX(0.5f);
        this.moveScreenButton.addActionListener(this.createSwitchToMoveScreenAction());
        this.moveScreenButton.setName(BUTTON_SET_POSITION);
        JButton moveToButton = new JButton(this.textResource.moveRobotHere());
        moveToButton.setMinimumSize(buttonDimension);
        moveToButton.setPreferredSize(buttonDimension);
        moveToButton.setMaximumSize(buttonDimension);
        moveToButton.setAlignmentX(0.5f);
        moveToButton.addActionListener(this.createMoveToAction());
        moveToButton.setName(BUTTON_MOVE_TO_POSITION);
        Box.Filler glue = new Box.Filler(new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        JLabel illustration = new JLabel(image);
        if (image != null) {
            illustration.setBorder(new EmptyBorder(20, 30, 20, 30));
            leftPane.add(illustration);
        }
        if ((topComponent = this.createTopComponent()) != null) {
            northPane.add(topComponent);
        }
        northPane.add(Box.createVerticalStrut(20));
        northPane.add(SelectPoseWizardPage.toHTMLFormattedJLabel((String)description));
        middlePane.add(Box.createVerticalStrut(20));
        middlePane.add(this.imageCardPanel);
        middlePane.add(Box.createVerticalStrut(20));
        middlePane.add(this.moveScreenButton);
        middlePane.add(Box.createVerticalStrut(20));
        middlePane.add(moveToButton);
        middlePane.add(glue);
        centerPane.add(leftPane);
        centerPane.add(middlePane);
        centerPane.add(rightPane);
        this.add(northPane, "North");
        this.add(centerPane, "Center");
    }

    private void addCanvas() {
        this.imagePanel.add(this.robotCanvas3D, "Center");
    }

    private void removeCanvas() {
        this.imagePanel.remove(this.robotCanvas3D);
    }

    protected JComponent createTopComponent() {
        return null;
    }

    private ActionListener createSwitchToMoveScreenAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectPoseWizardPage.this.robotCanvas3D.setVisible(false);
                SelectPoseWizardPage.this.positionRequester.requestPosition(SelectPoseWizardPage.this.cardPanel, new MoveCallback(){

                    public void onOk(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
                        SelectPoseWizardPage.this.updateComponents();
                        SelectPoseWizardPage.this.poseSelectedOnOk(pose, jointPositionVector, tcpOffset);
                    }

                    public void onCancel() {
                        SelectPoseWizardPage.this.updateComponents();
                        SelectPoseWizardPage.this.poseSelectedOnCancel();
                    }
                });
            }
        };
    }

    private ActionListener createMoveToAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SelectPoseWizardPage.this.isPoseSelected()) {
                    SelectPoseWizardPage.this.moveRequester.moveTo(SelectPoseWizardPage.this.cardPanel.getFlipManager(), SelectPoseWizardPage.this.jointPositionVector);
                }
            }
        };
    }

    public void setupWizardButtons() {
        if (this.isPoseSelected()) {
            this.fireButtonEvent(ButtonEvent.ButtonEventType.ENABLE_BUTTON, AbstractWizardPage.BUTTON_NEXT);
        } else {
            this.fireButtonEvent(ButtonEvent.ButtonEventType.DISABLE_BUTTON, AbstractWizardPage.BUTTON_NEXT);
        }
        this.fireButtonEvent(ButtonEvent.ButtonEventType.ENABLE_BUTTON, AbstractWizardPage.BUTTON_PREV);
        this.fireButtonEvent(ButtonEvent.ButtonEventType.CHANGE_BUTTON_TEXT, "STEP");
    }

    public boolean isPoseSelected() {
        return this.pose != null && this.jointPositionVector != null;
    }

    protected void setPoseAndJointPositionVector(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
        this.pose = pose;
        this.jointPositionVector = jointPositionVector;
    }

    protected void updateComponents() {
        if (this.isPoseSelected()) {
            this.setIcon(ViewfacadeImageResource.greenLed());
            this.moveScreenButton.setText(this.textResource.wizardPointChangePosition());
            ((CardLayout)this.imageCardPanel.getLayout()).show(this.imageCardPanel, "3D");
            this.robotCanvas3D.setVisible(true);
            this.visualizerFactory.showRobot(this.robotCanvas3D, this.jointPositionVector);
        } else {
            this.setIcon(ViewfacadeImageResource.grayLed());
            this.moveScreenButton.setText(this.textResource.wizardPointSetPosition());
            ((CardLayout)this.imageCardPanel.getLayout()).show(this.imageCardPanel, "UNDEFINED");
            this.robotCanvas3D.setVisible(false);
        }
    }

    public void enter(Object o) {
        this.addCanvas();
        this.updateComponents();
    }

    public Object exit() {
        this.robotCanvas3D.setVisible(false);
        this.removeCanvas();
        return null;
    }

    public void reset() {
        this.pose = null;
        this.jointPositionVector = null;
        this.updateComponents();
    }

    public Pose6d getPose() {
        return this.pose;
    }

    public void poseSelectedOnOk(Pose6d pose, JointPositionVector jointPositionVector, Pose6d tcpOffset) {
        this.setPoseAndJointPositionVector(pose, jointPositionVector, tcpOffset);
        this.updateComponents();
        this.setupWizardButtons();
    }

    public void poseSelectedOnCancel() {
    }
}

