/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.viewfacade.program;

import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import java.io.File;
import java.util.EventListener;

public interface ProgramEventListener
extends EventListener {
    public void handleProgramEvent(ProgramEventType var1);

    public void handleProgramEvent(ProgramEventType var1, ProgramRootNode var2);

    public void handleProgramEvent(ProgramEventType var1, File var2);

    public static class Template
    implements ProgramEventListener {
        @Override
        public void handleProgramEvent(ProgramEventType event) {
            switch (event) {
                case PRE_NEW_PROGRAM: {
                    this.onPreNewProgram();
                    break;
                }
                case POST_NEW_PROGRAM: {
                    this.onPostNewProgram();
                    break;
                }
                case PRE_PROGRAM_SAVE: {
                    this.onPreProgramSave();
                    break;
                }
                case POST_PROGRAM_SAVE: {
                    this.onPostProgramSave();
                    break;
                }
                case PRE_NEW_INSTALLATION: {
                    this.onPreNewInstallation();
                    break;
                }
                case POST_NEW_INSTALLATION: {
                    this.onPostNewInstallation();
                    break;
                }
                case LOAD_PROGRAM_FAILED: {
                    this.onLoadProgramFailed();
                }
            }
        }

        @Override
        public void handleProgramEvent(ProgramEventType event, ProgramRootNode programRootNode) {
            switch (event) {
                case PRE_NEW_PROGRAM: {
                    this.onPreNewProgram(programRootNode);
                    break;
                }
                case POST_NEW_PROGRAM: {
                    this.onPostNewProgram(programRootNode);
                    break;
                }
                case POST_POST_NEW_PROGRAM: {
                    this.onPostPostNewProgram(programRootNode);
                    break;
                }
                case PRE_PROGRAM_SAVE: {
                    this.onPreProgramSave(programRootNode);
                    break;
                }
                case POST_PROGRAM_SAVE: {
                    this.onPostProgramSave(programRootNode);
                    break;
                }
                case PRE_NEW_INSTALLATION: {
                    this.onPreNewInstallation();
                    break;
                }
                case POST_NEW_INSTALLATION: {
                    this.onPostNewInstallation();
                }
            }
        }

        @Override
        public void handleProgramEvent(ProgramEventType event, File programFile) {
            switch (event) {
                case POST_NEW_PROGRAM: {
                    this.onPostNewProgram();
                    break;
                }
                case PRE_PROGRAM_SAVE: {
                    this.onPreProgramSave();
                    break;
                }
                case POST_PROGRAM_SAVE: {
                    this.onPostProgramSave();
                    break;
                }
                case PRE_NEW_INSTALLATION: {
                    this.onPreNewInstallation();
                    break;
                }
                case POST_NEW_INSTALLATION: {
                    this.onPostNewInstallation();
                    break;
                }
                case LOAD_PROGRAM_FAILED: {
                    this.onLoadProgramFailed();
                }
            }
        }

        public void onPreNewProgram(ProgramRootNode programRootNode) {
            this.onPreNewProgram();
        }

        public void onPostNewProgram(ProgramRootNode programRootNode) {
            this.onPostNewProgram();
        }

        public void onPostPostNewProgram(ProgramRootNode programRootNode) {
        }

        public void onPreProgramSave(ProgramRootNode programRootNode) {
            this.onPreProgramSave();
        }

        public void onPostProgramSave(ProgramRootNode programRootNode) {
            this.onPostProgramSave();
        }

        public void onPreNewProgram() {
        }

        public void onPostNewProgram() {
        }

        public void onPreProgramSave() {
        }

        public void onPostProgramSave() {
        }

        public void onPreNewInstallation() {
        }

        public void onPostNewInstallation() {
        }

        public void onLoadProgramFailed() {
        }
    }
}

