/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.ateachposition;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.NamedUUID;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.pallet.UpdateChildrenStrategy;
import com.ur.polyscope.pallet.impl.ateachposition.AtEach;
import com.ur.polyscope.pallet.impl.ateachposition.AtEachPositionProgramNodeView;
import com.ur.polyscope.pallet.impl.ateachposition.PatternPosition;
import com.ur.polyscope.pallet.impl.generated.GenerateMovementNodeService;
import com.ur.polyscope.pallet.impl.generated.GeneratedMovement;
import com.ur.polyscope.pallet.impl.pallet.Pallet;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.position.DataModelPosition;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.pallet.impl.wizard.AbstractPalletWizardContribution;
import com.ur.polyscope.pallet.impl.wizard.MoveDefinition;
import com.ur.polyscope.pallet.impl.wizard.WizardAction;
import com.ur.polyscope.program.nodes.NonVisitable;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionLoadCompleteContext;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.builtin.FolderNode;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.util.logging.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.vecmath.Tuple3d;

public class AtEachPositionProgramNodeContribution
extends AbstractPalletWizardContribution
implements AtEach,
IconContribution,
NonVisitable {
    private static final String KEY_SELECTED_POSITION_ID = "selectedPosition";
    private static final String KEY_SELECTED_PATTERN_ID = "selectedPattern";
    private static final String KEY_REF_BASE_TO_FEATURE = "refBaseToFeature";
    private static final String KEY_REF_POSE = "refPose";
    private final AtEachPositionProgramNodeView view;
    private boolean inManualMode = false;

    AtEachPositionProgramNodeContribution(ProgramAPIProvider apiProvider, TextResource textResource, AtEachPositionProgramNodeView view, DataModel model, PalletMotionService palletMotionService, PalletFeatureService palletFeatureService) {
        super(apiProvider.getProgramAPI(), apiProvider.getProgramAPI().getUndoRedoManager(), model, textResource, palletMotionService, palletFeatureService);
        this.view = view;
    }

    public void openView() {
        this.updateView(!this.inManualMode);
        this.setInManualMode(false);
    }

    @Override
    protected void updateView(boolean allowWizardOverride) {
        this.updateReferencePoint();
        WizardAction wizard = this.getWizardState();
        if (wizard == WizardAction.MANUAL && allowWizardOverride) {
            wizard = WizardAction.LANDING;
        }
        PatternPosition selectedPatternAndPosition = this.getSelectedPatternAndPosition();
        Position selectedPosition = selectedPatternAndPosition.getPosition();
        PalletProgramFeature referencePointFeature = this.getPallet().getReferencePointFeature();
        if (selectedPosition != null && referencePointFeature != null && referencePointFeature.isUndefined()) {
            this.setFeaturePositionFromPosition(selectedPosition, UpdateChildrenStrategy.FORCE_UPDATE);
        }
        this.view.updateReferencePointSelection(selectedPatternAndPosition.getPattern(), selectedPosition, this.getPallet().getPatterns().getDefinedPatterns(), this.getPositionsByPattern());
        this.view.navigate(wizard, this::positionSet, this.getMoveDefinition());
        if (wizard.hasGraphics()) {
            PatternPosition wizardReferencePoint;
            JointPositionVector jpv = null;
            if (wizard == WizardAction.TEACH_APPROACH || wizard == WizardAction.TEACH_EXIT) {
                String waypointName = wizard == WizardAction.TEACH_APPROACH ? "Approach" : "Exit";
                jpv = TypeConversion.getPolyScopeJPV(DataModelPosition.getJointPositions(this.model, waypointName));
            } else if (selectedPosition != null && (wizardReferencePoint = this.getWizardReferencePoint()) != null) {
                Position position = wizardReferencePoint.getPosition();
                jpv = position.getActualJointPositions();
            }
            this.view.updateGraphics(jpv);
        }
        if (wizard != WizardAction.SHOW_DONE) {
            boolean navigationAllowed = this.allowNavigation(wizard.nextState());
            if (!navigationAllowed) {
                this.view.disableForwardNavigation(this.getDisallowedNavigationMessage(wizard.nextState()));
            } else {
                this.view.enableForwardNavigation();
            }
        }
    }

    private void updateView(Pattern selectedPattern, Position selectedPosition) {
        this.view.updateReferencePointSelection(selectedPattern, selectedPosition, this.getPallet().getPatterns().getDefinedPatterns(), this.getPositionsByPattern());
    }

    private Map<Pattern, List<Position>> getPositionsByPattern() {
        return this.getPallet().getPatterns().getDefinedPatterns().stream().collect(Collectors.toMap(pattern -> pattern, Pattern::getPositions));
    }

    private PatternPosition getSelectedPatternAndPosition() {
        String selectedPatternId = this.model.get(KEY_SELECTED_PATTERN_ID, "");
        String selectedPositionId = this.model.get(KEY_SELECTED_POSITION_ID, "");
        Pattern selectedPattern = null;
        Position selectedPosition = null;
        if (!selectedPatternId.isEmpty() && (selectedPattern = this.getNamedItem(UUID.fromString(selectedPatternId), this.getPallet().getPatterns().getDefinedPatterns())) != null && !selectedPositionId.isEmpty()) {
            selectedPosition = this.getNamedItem(UUID.fromString(selectedPositionId), selectedPattern.getPositions());
        }
        return new PatternPosition(selectedPattern, selectedPosition);
    }

    @Override
    public Position getSelectedPosition() {
        return this.getSelectedPatternAndPosition().getPosition();
    }

    @Override
    public void updateReferencePoint() {
        PatternPosition referencePoint = this.getWizardReferencePoint();
        if (referencePoint != null) {
            this.model.set(KEY_SELECTED_PATTERN_ID, referencePoint.getPattern().getUUID().toString());
            this.model.set(KEY_SELECTED_POSITION_ID, referencePoint.getPosition().getUUID().toString());
            PatternPosition selectedPatternAndPosition = this.getSelectedPatternAndPosition();
            Position selectedPosition = selectedPatternAndPosition.getPosition();
            PalletProgramFeature referencePointFeature = this.getPallet().getReferencePointFeature();
            if (referencePointFeature != null && selectedPosition != null && !referencePointFeature.isUndefined()) {
                this.setFeaturePositionFromPosition(selectedPosition, UpdateChildrenStrategy.FORCE_UPDATE);
            }
        }
    }

    private <T extends NamedUUID> T getNamedItem(UUID id, List<T> items) {
        return (T)((NamedUUID)items.stream().filter(item -> item.getUUID().equals(id)).findFirst().orElse(null));
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.atEachItem();
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(ScriptWriter writer) {
        writer.writeChildren();
    }

    void next() {
        this.undoRedoManager.recordChanges(() -> {
            PatternPosition wizardReferencePoint;
            WizardAction wizard = this.getWizardState();
            if (wizard == WizardAction.SHOW_INFO && (wizardReferencePoint = this.getWizardReferencePoint()) != null) {
                this.setFeature(wizardReferencePoint.getPosition(), wizardReferencePoint.getPattern(), UpdateChildrenStrategy.SKIP_UPDATE);
            }
            if ((wizard = this.setWizardState(wizard.nextState(), false)) == WizardAction.SHOW_DONE) {
                this.finalizeSubTree(this.getSelectedPatternAndPosition().getPosition());
            }
            this.updateView(false);
        });
    }

    void previous() {
        this.undoRedoManager.recordChanges(() -> {
            this.setWizardState(this.getWizardState().previousState(), false);
            this.updateView(false);
        });
    }

    void cancel() {
        this.undoRedoManager.recordChanges(() -> {
            WizardAction wizard = this.getWizardState();
            if (wizard == WizardAction.SHOW_INFO) {
                this.setWizardState(WizardAction.MANUAL, false);
            } else {
                this.setWizardState(WizardAction.LANDING, false);
            }
            this.resetNode();
            this.updateView(false);
        });
    }

    void setInManualMode(boolean inManualMode) {
        this.inManualMode = inManualMode;
    }

    private boolean allowNavigation(WizardAction nextState) {
        boolean result = true;
        if (nextState != null) {
            switch (nextState) {
                case SHOW_INFO: 
                case LANDING: 
                case MANUAL: {
                    break;
                }
                case MOVE_APPROACH: {
                    Pattern pattern = this.getPallet().getLayers().getFirstLayerPattern();
                    result = pattern != null;
                    break;
                }
                case TEACH_EXIT: 
                case TEACH_APPROACH: {
                    PatternPosition wizardReferencePoint = this.getWizardReferencePoint();
                    result = wizardReferencePoint != null && this.isAtlocation(wizardReferencePoint.getPosition());
                    break;
                }
                case MOVE_EXIT: {
                    result = this.palletMotionService.getInternalPoseFromDataModel(this.model, "Approach") != null;
                    break;
                }
                case SHOW_DONE: {
                    result = this.palletMotionService.getInternalPoseFromDataModel(this.model, "Exit") != null;
                }
            }
        }
        return result;
    }

    private String getDisallowedNavigationMessage(WizardAction nextState) {
        return nextState == WizardAction.MOVE_APPROACH ? this.textResource.warningDefineLayer() : "";
    }

    private PatternPosition getWizardReferencePoint() {
        Pattern pattern = this.getPallet().getLayers().getFirstLayerPattern();
        if (pattern != null) {
            List<Position> positions = this.getPositionsByPattern().get(pattern);
            if (positions == null) {
                return null;
            }
            Position position = positions.get(0);
            return new PatternPosition(pattern, position);
        }
        return null;
    }

    @Override
    protected Map<String, WaypointNode> createChildren(Feature feature) {
        HashMap<String, WaypointNode> waypointMap = new HashMap<String, WaypointNode>();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        MoveNode approachMoveNode = this.createMoveJNode();
        WaypointNode approachFixedWaypoint = this.createFixedWaypoint("Approach");
        waypointMap.put("Approach", approachFixedWaypoint);
        MoveNode ppMoveNode = this.createMoveLNode(feature);
        WaypointNode ppFixedWaypoint = this.createFixedWaypoint("ToolActionPoint");
        waypointMap.put("ToolActionPoint", ppFixedWaypoint);
        FolderNode gripperActionNode = this.programAPI.getProgramModel().getProgramNodeFactory().createFolderNode();
        gripperActionNode.setName("Tool action");
        MoveNode exitMoveNode = this.createMoveLNode(feature);
        WaypointNode exitFixedWaypoint = this.createFixedWaypoint("Exit");
        waypointMap.put("Exit", exitFixedWaypoint);
        TreeNode genMoveTreeNode = this.findGeneratedMovementNode();
        try {
            if (genMoveTreeNode == null) {
                URCapProgramNode genMoveURCapNode = this.programAPI.getProgramModel().getProgramNodeFactory().createURCapProgramNode(GenerateMovementNodeService.class);
                genMoveTreeNode = rootTreeNode.addChild((ProgramNode)genMoveURCapNode);
            }
            TreeNode approachTreeNode = genMoveTreeNode.addChild((ProgramNode)approachMoveNode);
            approachTreeNode.addChild((ProgramNode)approachFixedWaypoint);
            this.palletFeatureService.setFeatureOnMoveJHack(feature, approachMoveNode);
            TreeNode pptreeNode = genMoveTreeNode.addChild((ProgramNode)ppMoveNode);
            pptreeNode.addChild((ProgramNode)ppFixedWaypoint);
            genMoveTreeNode.addChild((ProgramNode)gripperActionNode);
            TreeNode exitTreeNode = genMoveTreeNode.addChild((ProgramNode)exitMoveNode);
            exitTreeNode.addChild((ProgramNode)exitFixedWaypoint);
        }
        catch (TreeStructureException e) {
            Log.error((String)"Unable to create child nodes", (Throwable)e);
        }
        return waypointMap;
    }

    private TreeNode findGeneratedMovementNode() {
        TreeNode result = null;
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        for (TreeNode child : rootTreeNode.getChildren()) {
            if (!(child.getProgramNode() instanceof URCapProgramNode) || !((URCapProgramNode)child.getProgramNode()).canGetAs(GeneratedMovement.class)) continue;
            result = child;
        }
        return result;
    }

    void setFeatureToBasePosition(Position selectedPosition, Pattern selectedPattern, UpdateChildrenStrategy updateStrategy, boolean undoable) {
        if (selectedPosition == null) {
            return;
        }
        if (undoable) {
            this.undoRedoManager.recordChanges(() -> {
                this.resetNode();
                this.setFeature(selectedPosition, selectedPattern, updateStrategy);
            });
        } else {
            this.resetNode();
            this.setFeature(selectedPosition, selectedPattern, updateStrategy);
        }
    }

    private void setFeature(Position selectedPosition, Pattern selectedPattern, UpdateChildrenStrategy updateStrategy) {
        this.setFeaturePositionFromPosition(selectedPosition, updateStrategy);
        if (this.findGeneratedMovementNode() == null) {
            Feature f = this.createFeature();
            if (updateStrategy != UpdateChildrenStrategy.SKIP_UPDATE) {
                Map<String, WaypointNode> wps = this.createChildren(f);
                this.initializeActionPoint(wps.get("ToolActionPoint"), selectedPosition);
            }
        }
        this.model.set(KEY_SELECTED_PATTERN_ID, selectedPattern.getUUID().toString());
        this.model.set(KEY_SELECTED_POSITION_ID, selectedPosition.getUUID().toString());
        boolean isAtlocation = this.isAtlocation(selectedPosition);
        if (!isAtlocation && !this.isWizardSelected()) {
            this.view.showPopup();
        }
        this.updateView(false);
    }

    private void positionSet(String waypointName, Pose pose, JointPositions jointPositions) {
        this.undoRedoManager.recordChanges(() -> this.palletMotionService.setPositionInDataModel(pose, jointPositions, this.model, this.getPallet().getPalletFeatureName(), waypointName));
        this.updateView(false);
    }

    private void setFeaturePositionFromPosition(Position selectedPosition, UpdateChildrenStrategy updateStrategy) {
        PalletProgramFeature referencePointFeature = this.getPallet().getReferencePointFeature();
        if (referencePointFeature != null) {
            referencePointFeature.setPosition(this.getPallet().getPalletFeatureName(), selectedPosition.getToolPosition(), selectedPosition.getToolAxisAngle(), selectedPosition.getBaseToFeature());
            this.model.set(KEY_REF_BASE_TO_FEATURE, TypeConversion.getFromPolyScopePose(selectedPosition.getBaseToFeature(), this.programAPI));
            this.model.set(KEY_REF_POSE, TypeConversion.getFromPolyScopePose(new Pose6d((Tuple3d)selectedPosition.getToolPosition(), (Tuple3d)selectedPosition.getToolAxisAngle()), this.programAPI));
            this.updateMoveNodes(updateStrategy, referencePointFeature);
        }
    }

    private void setFeaturePositionFromDataModel(UpdateChildrenStrategy updateStrategy) {
        PalletProgramFeature referencePointFeature;
        Pallet pallet = this.getPallet();
        if (pallet != null && (referencePointFeature = pallet.getReferencePointFeature()) != null) {
            Pose baseToFeature = this.model.get(KEY_REF_BASE_TO_FEATURE, (Pose)null);
            Pose refPose = this.model.get(KEY_REF_POSE, (Pose)null);
            referencePointFeature.setPosition(baseToFeature, refPose, pallet.getPalletFeatureName());
            this.updateMoveNodes(updateStrategy, referencePointFeature);
        }
    }

    private void updateMoveNodes(UpdateChildrenStrategy updateStrategy, PalletProgramFeature referencePointFeature) {
        if (updateStrategy == UpdateChildrenStrategy.UPDATE || updateStrategy == UpdateChildrenStrategy.FORCE_UPDATE) {
            Feature feature = this.palletFeatureService.wrapFeature((SpatialFeature)referencePointFeature);
            TreeNode generatedMovementNode = this.findGeneratedMovementNode();
            if (generatedMovementNode != null) {
                generatedMovementNode.traverse(this.palletFeatureService.createFeatureUpdateVisitor(updateStrategy, feature, false, "referencePoint", this.undoRedoManager));
            }
        }
    }

    @Override
    protected Feature createFeature() {
        PalletProgramFeature referencePointFeature = this.getPallet().getReferencePointFeature();
        return this.palletFeatureService.wrapFeature((SpatialFeature)referencePointFeature);
    }

    private Pallet getPallet() {
        return (Pallet)this.getParentContribution();
    }

    void patternSelected(Pattern selectedPattern) {
        this.updateView(selectedPattern, null);
    }

    void positionSelected(Pattern selectedPattern, Position selectedPosition) {
        this.updateView(selectedPattern, selectedPosition);
    }

    @Override
    protected void resetNode() {
        this.model.remove(KEY_SELECTED_PATTERN_ID);
        this.model.remove(KEY_SELECTED_POSITION_ID);
        DataModelPosition.removePosition(this.model, "Approach");
        DataModelPosition.removePosition(this.model, "Exit");
        TreeNode generatedMovementNode = this.findGeneratedMovementNode();
        if (generatedMovementNode != null) {
            try {
                this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).removeChild(generatedMovementNode);
            }
            catch (TreeStructureException e) {
                Log.error((String)"Unable to remove child", (Throwable)e);
            }
        }
    }

    private MoveDefinition getMoveDefinition() {
        return new MoveDefinition(){

            @Override
            public JointPositionVector getJointPositionVector(String waypointName) {
                JointPositionVector result = null;
                if (waypointName != null) {
                    result = AtEachPositionProgramNodeContribution.this.palletMotionService.getJointPositionVectorFromDataModel(AtEachPositionProgramNodeContribution.this.model, waypointName);
                } else {
                    PatternPosition selectedPatternPosition = AtEachPositionProgramNodeContribution.this.getSelectedPatternAndPosition();
                    if (selectedPatternPosition.getPosition() != null) {
                        result = selectedPatternPosition.getPosition().getActualJointPositions();
                    }
                }
                return result;
            }

            @Override
            public boolean isAtPosition(String waypointName) {
                JointPositionVector jpv = null;
                if (waypointName != null) {
                    jpv = AtEachPositionProgramNodeContribution.this.palletMotionService.getJointPositionVectorFromDataModel(AtEachPositionProgramNodeContribution.this.model, waypointName);
                } else {
                    PatternPosition selectedPatternPosition = AtEachPositionProgramNodeContribution.this.getSelectedPatternAndPosition();
                    if (selectedPatternPosition.getPosition() != null) {
                        jpv = selectedPatternPosition.getPosition().getActualJointPositions();
                    }
                }
                return jpv != null && AtEachPositionProgramNodeContribution.this.isAtlocation(jpv);
            }
        };
    }

    public Icon getIcon(boolean isUndefined) {
        return isUndefined ? PalletImageResource.atEachUndefined() : PalletImageResource.atEachDefined();
    }

    @Override
    public void loadComplete(ContributionLoadCompleteContext contributionLoadCompleteContext) {
        super.loadComplete(contributionLoadCompleteContext);
        this.initialize(UpdateChildrenStrategy.SKIP_UPDATE);
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        super.onInserted(contributionInsertedContext);
        if (contributionInsertedContext.isCloning()) {
            this.initialize(UpdateChildrenStrategy.FORCE_UPDATE);
        } else if (this.model.isSet(KEY_REF_BASE_TO_FEATURE)) {
            this.initialize(UpdateChildrenStrategy.FORCE_UPDATE);
        } else {
            this.setWizardState(WizardAction.SHOW_INFO, false);
        }
    }

    @Override
    protected WizardAction setWizardState(WizardAction newState, boolean undoable) {
        if (undoable) {
            this.undoRedoManager.recordChanges(() -> this.model.set("currentWizardState", newState.name()));
        } else {
            this.model.set("currentWizardState", newState.name());
        }
        return newState;
    }

    private void initialize(UpdateChildrenStrategy updateStrategy) {
        this.setFeaturePositionFromDataModel(updateStrategy);
    }
}

