/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.ateachposition;

import com.google.common.collect.Maps;
import com.ur.monitor.model.JointPositionVector;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.polyscope.pallet.UpdateChildrenStrategy;
import com.ur.polyscope.pallet.impl.ateachposition.AtEachPositionProgramNodeContribution;
import com.ur.polyscope.pallet.impl.ateachposition.NamedUUIDListCellRenderer;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.service.InternalPalletUIService;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.pallet.impl.util.PatternIconResource;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.pallet.impl.wizard.MoveDefinition;
import com.ur.polyscope.pallet.impl.wizard.MoveHereActionListener;
import com.ur.polyscope.pallet.impl.wizard.NavigationControls;
import com.ur.polyscope.pallet.impl.wizard.SetWaypointCallback;
import com.ur.polyscope.pallet.impl.wizard.WizardAction;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingFormBuilder;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.dialog.WarningMessage;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.UserInterfaceAPI;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class AtEachPositionProgramNodeView
implements SwingProgramNodeView<AtEachPositionProgramNodeContribution> {
    private static final Dimension ROBOT_3D_IMAGE_SIZE = new Dimension(220, 180);
    private static final Color BETWEEN_CARD_COLOR = new Color(230, 230, 230);
    private static final int CONTENT_WIDTH = 675;
    private static final int CONTENT_HEIGHT = 385;
    private static final Dimension CONTENT_PANEL_DIMENSION = new Dimension(675, 385);
    private static final int TOTAL_WIZARD_STEPS = 6;
    private static final String CONTENT_HEADER = "<html><h2>%s (%d / %d)</h2></html>";
    private final Color NEXT_ENABLED = new Color(86, 160, 211);
    private final UserInterfaceAPI userInterfaceAPI;
    private final TextResource textResource;
    private final InternalPalletUIService palletUIService;
    private final int buttonHeight = 35;
    private JComboBox<Position> positionComboBox;
    private JComboBox<Pattern> patternComboBox;
    private JButton setButton;
    private JButton moveHereButton;
    private JLabel patternLabel;
    private JPanel navigationPanel;
    private JPanel manualPanel;
    private JButton next;
    private JButton previous;
    private JButton finish;
    private JButton cancel;
    private JPanel infoPanel;
    private JPanel infoIllustrationPanel;
    private JPanel teachPanel;
    private JPanel landingPanel;
    private JLabel teachIllustration;
    private JButton teachWaypointButton;
    private JButton moveRobotToWaypointButton;
    private JLabel contentTitle;
    private JPanel contentTitlePanel;
    private JLabel teachPanelDescription;
    private RobotCanvas3D teachCanvas;
    private ProgramVisualization teachVisualizer;
    private ImagePlaceHolder undefinedGraphics;
    private JLabel navigationInfo;
    private Dimension finishCancelDimension;
    private Map<WizardAction, JPanel> stateToPanelMapping;
    private JLabel infoLabel;
    private ContributionProvider<AtEachPositionProgramNodeContribution> provider;

    AtEachPositionProgramNodeView(UserInterfaceAPI userInterfaceAPI, TextResource textResource, InternalPalletUIService palletUIService) {
        this.userInterfaceAPI = userInterfaceAPI;
        this.textResource = textResource;
        this.palletUIService = palletUIService;
    }

    void updateReferencePointSelection(Pattern selectedPattern, Position selectedPosition, List<Pattern> patterns, Map<Pattern, List<Position>> positionsByPattern) {
        if (patterns.isEmpty()) {
            this.clearComboBoxModels();
            return;
        }
        if (selectedPattern == null) {
            selectedPattern = patterns.get(0);
        }
        this.setupComboBoxModel(selectedPattern, patterns, this.patternComboBox);
        List<Position> positionsInPattern = positionsByPattern.get(selectedPattern);
        if (selectedPosition == null) {
            selectedPosition = positionsInPattern.get(0);
        }
        this.setupComboBoxModel(selectedPosition, positionsInPattern, this.positionComboBox);
        this.moveHereButton.setEnabled(this.positionComboBox.getSelectedItem() != null);
        this.setButton.setEnabled(this.positionComboBox.getSelectedItem() != null);
        if (selectedPattern != null && selectedPosition != null) {
            ImageIcon patternImageIcon = PatternIconResource.getPatternImageIcon(selectedPattern.getPatternType(), positionsInPattern.indexOf(selectedPosition));
            this.patternLabel.setIcon(patternImageIcon);
        } else {
            this.patternLabel.setIcon(PalletImageResource.grid());
        }
    }

    private <T> void setupComboBoxModel(T selectedPattern, List<? extends T> patterns, JComboBox<T> comboBox) {
        Object[] array = patterns.toArray();
        DefaultComboBoxModel<Object> patternsModel = new DefaultComboBoxModel<Object>(array);
        patternsModel.setSelectedItem(selectedPattern);
        comboBox.setModel(patternsModel);
        comboBox.setRenderer(new NamedUUIDListCellRenderer());
    }

    private void clearComboBoxModels() {
        DefaultComboBoxModel patternModel = new DefaultComboBoxModel();
        this.patternComboBox.setModel(patternModel);
        DefaultComboBoxModel positionModel = new DefaultComboBoxModel();
        this.positionComboBox.setModel(positionModel);
    }

    void navigate(WizardAction wizard, SetWaypointCallback callback, MoveDefinition moveCallback) {
        this.toggleButtonsEnabled(wizard.getNavigationControls());
        this.contentTitlePanel.setVisible(true);
        this.navigationPanel.setVisible(true);
        this.togglePanelVisibility(wizard);
        this.cancel.setText(this.textResource.cancel());
        this.setDimensions(this.cancel, this.finishCancelDimension);
        this.finish.setVisible(true);
        this.infoIllustrationPanel.setVisible(false);
        switch (wizard) {
            case SHOW_INFO: {
                this.setContentTitle(this.textResource.wizardStepInfo(), 1);
                this.infoLabel.setText(this.textResource.wizardDesc());
                this.cancel.setText(this.textResource.manualConfiguration());
                this.setDimensions(this.cancel, new Dimension(250, 35));
                this.finish.setVisible(false);
                this.infoIllustrationPanel.setVisible(true);
                break;
            }
            case MOVE_APPROACH: {
                this.setContentTitle(this.textResource.moveToReferencePointShort(), 2);
                this.teachPanelDescription.setText(this.textResource.wizardRefPoint(this.textResource.approach()));
                this.teachIllustration.setIcon(PalletImageResource.referencePoint());
                this.teachWaypointButton.setEnabled(false);
                this.setupMoveToWaypointButton(moveCallback, null, false);
                break;
            }
            case TEACH_APPROACH: {
                this.setContentTitle(this.textResource.wizardStepTeachApproach(), 3);
                this.teachPanelDescription.setText(this.textResource.approachDescription());
                this.teachIllustration.setIcon(PalletImageResource.approachLarge());
                this.setupTeachButton("Approach", callback);
                this.setupMoveToWaypointButton(moveCallback, "Approach", true);
                break;
            }
            case MOVE_EXIT: {
                this.setContentTitle(this.textResource.moveToReferencePointShort(), 4);
                this.teachPanelDescription.setText(this.textResource.wizardRefPoint(this.textResource.exit()));
                this.teachIllustration.setIcon(PalletImageResource.referencePoint());
                this.teachWaypointButton.setEnabled(false);
                this.setupMoveToWaypointButton(moveCallback, null, false);
                break;
            }
            case TEACH_EXIT: {
                this.setContentTitle(this.textResource.wizardStepTeachExit(), 5);
                this.teachPanelDescription.setText(this.textResource.exitDescription());
                this.teachIllustration.setIcon(PalletImageResource.exitLarge());
                this.setupTeachButton("Exit", callback);
                this.setupMoveToWaypointButton(moveCallback, "Exit", true);
                break;
            }
            case SHOW_DONE: {
                this.setContentTitle(this.textResource.wizardStepFinished(), 6);
                this.infoLabel.setText(this.textResource.wizardCompleted());
                break;
            }
            case LANDING: 
            case MANUAL: {
                this.contentTitlePanel.setVisible(false);
                this.navigationPanel.setVisible(false);
            }
        }
    }

    private void setContentTitle(String title, int index) {
        this.contentTitle.setText(String.format(CONTENT_HEADER, title, index, 6));
    }

    void updateGraphics(JointPositionVector jpv) {
        boolean undefined;
        boolean bl = undefined = jpv == null || jpv.isUndefined();
        if (!undefined) {
            this.teachCanvas.setVisible(true);
            this.teachCanvas.addQueue(() -> {
                this.teachCanvas.setRobotAttached(true);
                this.teachCanvas.setJointAngleVector(jpv);
                this.teachVisualizer.clearVisualization();
            });
        }
        this.undefinedGraphics.setVisible(undefined);
        this.teachCanvas.setVisible(!undefined);
        this.moveRobotToWaypointButton.setEnabled(!undefined);
    }

    private void toggleButtonsEnabled(NavigationControls navigationControls) {
        this.previous.setEnabled(navigationControls.isPreviousEnabled());
        this.next.setEnabled(navigationControls.isNextEnabled());
        this.styleNextButton(navigationControls.isNextEnabled());
        this.finish.setEnabled(navigationControls.isFinishEnabled());
    }

    private void styleNextButton(boolean enabled) {
        if (enabled) {
            this.next.setBackground(this.NEXT_ENABLED);
            this.next.setBorder(new LineBorder(Color.BLACK, 1));
        } else {
            this.next.setBackground(Color.WHITE);
            this.next.setBorder(new LineBorder(Color.LIGHT_GRAY, 2));
        }
    }

    private void togglePanelVisibility(WizardAction wizardAction) {
        JPanel panelToShow = this.stateToPanelMapping.get((Object)wizardAction);
        panelToShow.setVisible(true);
        for (JPanel panel : this.stateToPanelMapping.values()) {
            if (panel == panelToShow) continue;
            panel.setVisible(false);
        }
    }

    private void createLandingPanel(final ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        this.landingPanel = this.createContentPanel();
        this.landingPanel.setLayout(new BoxLayout(this.landingPanel, 1));
        JButton manualButton = new JButton(this.textResource.manual());
        manualButton.setName("AtEachPositionProgramNodeView.manual");
        manualButton.addActionListener(actionEvent -> ((AtEachPositionProgramNodeContribution)provider.get()).manual());
        JButton wizardButton = new JButton(this.textResource.redoWizard());
        wizardButton.setName("AtEachPositionProgramNodeView.redoWizard");
        wizardButton.addActionListener(actionEvent -> this.palletUIService.confirmMessageDialog(this.getWizardToggleWarningMessage(), new ConfirmationDialogListener(){

            public void onOkClicked() {
                ((AtEachPositionProgramNodeContribution)provider.get()).wizard();
            }
        }));
        JLabel landingDescription = new JLabel(this.textResource.landingDescription());
        this.setDimensions(landingDescription, new Dimension(675, 100));
        landingDescription.setBorder(new EmptyBorder(10, 10, 10, 10));
        landingDescription.setAlignmentX(0.5f);
        JPanel buttonPanel = new JPanel();
        this.setDimensions(buttonPanel, new Dimension(675, 40));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setAlignmentX(0.5f);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(manualButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        buttonPanel.add(wizardButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.landingPanel.add(landingDescription);
        this.landingPanel.add(buttonPanel);
    }

    private void createInfoPanel() {
        this.infoPanel = this.createContentPanel();
        this.infoLabel = new JLabel();
        this.setDimensions(this.infoLabel, new Dimension(665, 170));
        this.infoLabel.setBorder(new EmptyBorder(5, 10, 0, 10));
        this.infoLabel.setVerticalAlignment(1);
        this.infoPanel.add((Component)this.infoLabel, "North");
        this.infoIllustrationPanel = this.createIllustrationPanel();
        this.infoIllustrationPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.infoPanel.add((Component)this.infoIllustrationPanel, "Center");
    }

    private JPanel createIllustrationPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(new EmptyBorder(10, 0, 20, 0));
        JLabel approachIllustration = new JLabel();
        JLabel actionPointIllustration = new JLabel();
        JLabel exitIllustration = new JLabel();
        ImageIcon approachIcon = PalletImageResource.approach();
        ImageIcon actionIcon = PalletImageResource.actionPoint();
        ImageIcon exitIcon = PalletImageResource.exit();
        approachIllustration.setIcon(approachIcon);
        actionPointIllustration.setIcon(actionIcon);
        exitIllustration.setIcon(exitIcon);
        panel.add(this.createIllustrationWithCaption(this.textResource.approach(), approachIllustration));
        panel.add(Box.createHorizontalStrut(8));
        panel.add(this.createIllustrationWithCaption(this.textResource.actionPoint(), actionPointIllustration));
        panel.add(Box.createHorizontalStrut(8));
        panel.add(this.createIllustrationWithCaption(this.textResource.exit(), exitIllustration));
        return panel;
    }

    private void createTeachPanel() {
        this.teachPanel = this.createContentPanel();
        this.teachPanel.setLayout(new BoxLayout(this.teachPanel, 1));
        this.teachPanelDescription = new JLabel();
        this.teachPanelDescription.setAlignmentX(0.5f);
        this.teachPanelDescription.setHorizontalAlignment(0);
        this.teachPanelDescription.setVerticalAlignment(1);
        this.teachPanelDescription.setBorder(new EmptyBorder(5, 10, 0, 10));
        this.setDimensions(this.teachPanelDescription, new Dimension(665, 50));
        JPanel leftSide = new JPanel();
        leftSide.setLayout(new BoxLayout(leftSide, 1));
        this.setDimensions(leftSide, new Dimension(340, 325));
        this.teachIllustration = new JLabel();
        this.teachIllustration.setAlignmentX(0.5f);
        this.setDimensions(this.teachIllustration, new Dimension(275, 275));
        leftSide.add(Box.createVerticalStrut(40));
        leftSide.add(this.teachIllustration);
        Dimension buttonSize = new Dimension(220, 40);
        this.teachWaypointButton = new JButton(this.textResource.setItem(this.textResource.waypoint()));
        this.teachWaypointButton.setName("AtEachPositionProgramNodeView.setWaypoint");
        this.setDimensions(this.teachWaypointButton, buttonSize);
        this.teachWaypointButton.setAlignmentX(0.5f);
        this.moveRobotToWaypointButton = new JButton(this.textResource.moveHere());
        this.moveRobotToWaypointButton.setName("AtEachPositionProgramNodeView.moveToWaypoint");
        this.setDimensions(this.moveRobotToWaypointButton, buttonSize);
        this.moveRobotToWaypointButton.setAlignmentX(0.5f);
        int moveButtonPanelWidth = AtEachPositionProgramNodeView.ROBOT_3D_IMAGE_SIZE.width;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.setDimensions(buttonPanel, new Dimension(moveButtonPanelWidth, 100));
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(this.teachWaypointButton);
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(this.moveRobotToWaypointButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.teachCanvas = this.palletUIService.createRobotCanvas3d();
        this.teachCanvas.setDebugName("Pallet Teach 3D Canvas");
        this.teachVisualizer = this.palletUIService.createProgramVisualization(this.teachCanvas);
        this.teachVisualizer.clearVisualization();
        this.teachCanvas.setVisible(false);
        Dimension canvasDimension = new Dimension(220, 220);
        this.teachCanvas.getComponent().setPreferredSize(canvasDimension);
        this.teachCanvas.getComponent().setMaximumSize(canvasDimension);
        this.teachCanvas.getComponent().setMinimumSize(canvasDimension);
        JPanel imagePlaceholder = new JPanel(new CardLayout());
        imagePlaceholder.setBorder(BorderFactory.createLineBorder(BETWEEN_CARD_COLOR, 3));
        this.setDimensions(imagePlaceholder, canvasDimension);
        this.undefinedGraphics = new ImagePlaceHolder();
        imagePlaceholder.add(this.undefinedGraphics);
        imagePlaceholder.add(this.teachCanvas.getComponent());
        JPanel rightSide = new JPanel();
        rightSide.setLayout(new BoxLayout(rightSide, 1));
        this.setDimensions(rightSide, new Dimension(moveButtonPanelWidth, 250));
        rightSide.add(Box.createRigidArea(new Dimension(0, 10)));
        rightSide.add(imagePlaceholder);
        rightSide.add(Box.createVerticalGlue());
        rightSide.add(buttonPanel);
        rightSide.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel contentPanel = new JPanel(new GridLayout(1, 2));
        contentPanel.add(leftSide);
        contentPanel.add(rightSide);
        this.teachPanel.add(this.teachPanelDescription);
        this.teachPanel.add(contentPanel);
    }

    private void setupTeachButton(final String waypointName, final SetWaypointCallback callback) {
        for (ActionListener actionListener : this.teachWaypointButton.getActionListeners()) {
            this.teachWaypointButton.removeActionListener(actionListener);
        }
        this.teachWaypointButton.setEnabled(true);
        this.teachWaypointButton.addActionListener(event -> this.userInterfaceAPI.getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback(){

            public void onOk(Pose pose, JointPositions jointPositions) {
                callback.apply(waypointName, pose, jointPositions);
            }
        }));
    }

    private void setupMoveToWaypointButton(MoveDefinition moveDefinition, String waypointName, boolean doNotStyleButton) {
        for (ActionListener actionListener : this.moveRobotToWaypointButton.getActionListeners()) {
            this.moveRobotToWaypointButton.removeActionListener(actionListener);
        }
        this.moveRobotToWaypointButton.addActionListener(new MoveHereActionListener(this.userInterfaceAPI, moveDefinition, waypointName, new RobotMovementCallback(){

            public void onComplete(MovementCompleteEvent movementCompleteEvent) {
                ((AtEachPositionProgramNodeContribution)AtEachPositionProgramNodeView.this.provider.get()).openView();
            }
        }));
        if (doNotStyleButton || moveDefinition.isAtPosition(waypointName)) {
            this.moveRobotToWaypointButton.setBackground(Color.WHITE);
            this.moveRobotToWaypointButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 2));
        } else {
            this.moveRobotToWaypointButton.setBackground(this.NEXT_ENABLED);
            this.moveRobotToWaypointButton.setBorder(new LineBorder(Color.BLACK, 1));
        }
    }

    private JPanel createContentPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new LineBorder(BETWEEN_CARD_COLOR, 2, true));
        this.setDimensions(panel, CONTENT_PANEL_DIMENSION);
        panel.setAlignmentX(0.5f);
        return panel;
    }

    private JPanel createIllustrationWithCaption(String caption, JComponent component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(160, 192);
        jPanel.setMinimumSize(dimension);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.add((Component)component, "Center");
        JLabel lb = new JLabel(caption);
        lb.setHorizontalAlignment(0);
        this.setDimensions(lb, new Dimension(150, 30));
        jPanel.add((Component)lb, "South");
        return jPanel;
    }

    public void buildUI(JPanel mainPanel, ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        this.provider = provider;
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.createContentPanelTitle();
        this.createNavigationPanel(provider);
        this.createInfoPanel();
        this.createTeachPanel();
        this.createManualPanel(provider);
        this.createLandingPanel(provider);
        mainPanel.add(this.contentTitlePanel);
        mainPanel.add(this.infoPanel);
        mainPanel.add(this.teachPanel);
        mainPanel.add(this.manualPanel);
        mainPanel.add(this.landingPanel);
        mainPanel.add(Box.createVerticalGlue());
        mainPanel.add(this.navigationPanel);
        this.stateToPanelMapping = Maps.newHashMap();
        this.stateToPanelMapping.put(WizardAction.SHOW_INFO, this.infoPanel);
        this.stateToPanelMapping.put(WizardAction.MOVE_APPROACH, this.teachPanel);
        this.stateToPanelMapping.put(WizardAction.TEACH_APPROACH, this.teachPanel);
        this.stateToPanelMapping.put(WizardAction.MOVE_EXIT, this.teachPanel);
        this.stateToPanelMapping.put(WizardAction.TEACH_EXIT, this.teachPanel);
        this.stateToPanelMapping.put(WizardAction.SHOW_DONE, this.infoPanel);
        this.stateToPanelMapping.put(WizardAction.LANDING, this.landingPanel);
        this.stateToPanelMapping.put(WizardAction.MANUAL, this.manualPanel);
        WizardAction initialState = WizardAction.SHOW_INFO;
        this.togglePanelVisibility(initialState);
        this.toggleButtonsEnabled(initialState.getNavigationControls());
    }

    private void createContentPanelTitle() {
        this.contentTitlePanel = new JPanel();
        this.contentTitlePanel.setLayout(new BoxLayout(this.contentTitlePanel, 0));
        this.setDimensions(this.contentTitlePanel, new Dimension(675, 40));
        this.contentTitlePanel.setAlignmentX(0.5f);
        this.contentTitle = new JLabel();
        this.contentTitle.setHorizontalAlignment(0);
        this.contentTitle.setVerticalAlignment(0);
        this.setDimensions(this.contentTitle, new Dimension(450, 30));
        this.contentTitlePanel.add(Box.createHorizontalGlue());
        this.contentTitlePanel.add(this.contentTitle);
        this.contentTitlePanel.add(Box.createHorizontalGlue());
    }

    private void createNavigationPanel(ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        this.navigationPanel = new JPanel();
        this.navigationPanel.setLayout(new BorderLayout(10, 0));
        this.navigationPanel.setAlignmentX(0.5f);
        this.setDimensions(this.navigationPanel, new Dimension(675, 90));
        this.navigationInfo = new JLabel("");
        this.setDimensions(this.navigationInfo, new Dimension(675, 30));
        this.navigationPanel.add((Component)this.navigationInfo, "North");
        JPanel navigationButtonsPanel = this.createNavigationButtonsPanel(provider);
        this.navigationPanel.add((Component)navigationButtonsPanel, "South");
    }

    private JPanel createNavigationButtonsPanel(final ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        Dimension navButtonDimension = new Dimension(180, 35);
        this.previous = new JButton(this.textResource.previous(), PalletImageResource.buttonBack());
        this.setDimensions(this.previous, navButtonDimension);
        this.previous.setName("AtEachPositionProgramNodeView.previous");
        this.previous.setEnabled(false);
        this.previous.addActionListener(event -> ((AtEachPositionProgramNodeContribution)provider.get()).previous());
        this.next = new JButton(this.textResource.next(), PalletImageResource.buttonForward());
        this.setDimensions(this.next, navButtonDimension);
        this.next.setName("AtEachPositionProgramNodeView.next");
        this.next.setHorizontalTextPosition(10);
        this.next.addActionListener(event -> ((AtEachPositionProgramNodeContribution)provider.get()).next());
        this.finishCancelDimension = new Dimension(135, 35);
        this.finish = new JButton(this.textResource.finish(), PalletImageResource.buttonFinish());
        this.setDimensions(this.finish, this.finishCancelDimension);
        this.finish.setName("AtEachPositionProgramNodeView.finish");
        this.finish.setEnabled(false);
        this.finish.addActionListener(event -> ((AtEachPositionProgramNodeContribution)provider.get()).finish());
        this.cancel = new JButton(this.textResource.cancel());
        this.setDimensions(this.cancel, this.finishCancelDimension);
        this.setDimensions(this.cancel, this.finishCancelDimension);
        this.cancel.setName("AtEachPositionProgramNodeView.cancel");
        this.cancel.addActionListener(event -> this.palletUIService.confirmMessageDialog(this.getWizardCancelWarningMessage(), new ConfirmationDialogListener(){

            public void onOkClicked() {
                ((AtEachPositionProgramNodeContribution)provider.get()).cancel();
            }
        }));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        this.setDimensions(buttonsPanel, new Dimension(675, 60));
        buttonsPanel.setAlignmentY(0.5f);
        buttonsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        buttonsPanel.add(this.previous);
        buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonsPanel.add(this.next);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.finish);
        buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonsPanel.add(this.cancel);
        return buttonsPanel;
    }

    private void createManualPanel(ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        this.manualPanel = new JPanel();
        this.setDimensions(this.manualPanel, new Dimension(675, 525));
        this.manualPanel.setAlignmentX(0.5f);
        JPanel titlePanel = this.createTitlePanel(provider);
        JPanel referencePointTitlePanel = this.createReferencePointTitlePanel();
        JPanel referencePointPanel = this.createReferencePointPanel(provider);
        JPanel teachTitlePanel = this.createTeachTitlePanel();
        JPanel teachIllustrationPanel = this.createIllustrationPanel();
        this.manualPanel.add(titlePanel);
        this.manualPanel.add(referencePointTitlePanel);
        this.manualPanel.add(referencePointPanel);
        this.manualPanel.add(teachTitlePanel);
        this.manualPanel.add(teachIllustrationPanel);
    }

    private JPanel createTeachTitlePanel() {
        Dimension teachTitleDimension = new Dimension(675, 60);
        JPanel teachTitlePanel = new JPanel(new BorderLayout());
        JLabel teachTitle = new JLabel(this.textResource.atEachSubNodes());
        teachTitlePanel.add((Component)teachTitle, "Center");
        teachTitlePanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.setDimensions(teachTitlePanel, teachTitleDimension);
        return teachTitlePanel;
    }

    private JPanel createReferencePointPanel(final ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        JPanel patternPanel = new JPanel();
        this.setDimensions(patternPanel, new Dimension(190, 135));
        patternPanel.setLayout(new BoxLayout(patternPanel, 1));
        this.patternLabel = new JLabel(PalletImageResource.irregular());
        this.setDimensions(this.patternLabel, new Dimension(185, 100));
        patternPanel.add(this.patternLabel);
        this.moveHereButton = new JButton(this.textResource.moveHere());
        this.setDimensions(this.moveHereButton, new Dimension(185, 30));
        this.moveHereButton.addActionListener(actionEvent -> {
            Position selectedPosition = (Position)this.positionComboBox.getSelectedItem();
            if (selectedPosition != null) {
                JointPositionVector actualJointPositions = selectedPosition.getActualJointPositions();
                this.userInterfaceAPI.getUserInteraction().getRobotMovement().requestUserToMoveRobot(TypeConversion.getURCapJPV(actualJointPositions), new RobotMovementCallback(){

                    public void onComplete(MovementCompleteEvent movementCompleteEvent) {
                        ((AtEachPositionProgramNodeContribution)provider.get()).setInManualMode(true);
                    }
                });
            }
        });
        JPanel moveHereButtonPanel = new JPanel();
        moveHereButtonPanel.setLayout(new BoxLayout(moveHereButtonPanel, 0));
        this.setDimensions(moveHereButtonPanel, new Dimension(210, 40));
        moveHereButtonPanel.setAlignmentX(0.0f);
        moveHereButtonPanel.add(Box.createHorizontalGlue());
        moveHereButtonPanel.add(this.moveHereButton);
        moveHereButtonPanel.add(Box.createHorizontalGlue());
        patternPanel.add(Box.createVerticalStrut(2));
        patternPanel.add(moveHereButtonPanel);
        Dimension comboBoxDimension = new Dimension(225, 32);
        this.patternComboBox = new JComboBox();
        this.setDimensions(this.patternComboBox, comboBoxDimension);
        this.patternComboBox.addActionListener(e -> ((AtEachPositionProgramNodeContribution)provider.get()).patternSelected((Pattern)this.patternComboBox.getSelectedItem()));
        this.positionComboBox = new JComboBox();
        this.setDimensions(this.positionComboBox, comboBoxDimension);
        this.positionComboBox.setName("AtEachPositionProgramNodeView.positions");
        this.positionComboBox.addActionListener(e -> ((AtEachPositionProgramNodeContribution)provider.get()).positionSelected((Pattern)this.patternComboBox.getSelectedItem(), (Position)this.positionComboBox.getSelectedItem()));
        JPanel buttonPanel = this.createButtonPanel(provider);
        SwingFormBuilder formBuilder = new SwingFormBuilder(this.palletUIService.getWidgetFactory());
        JPanel selectPanel = formBuilder.label(this.textResource.pattern(), new FormBuilder.PanelConstraints[0]).component(this.patternComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).spacer().end().label(this.textResource.referencePoint(), new FormBuilder.PanelConstraints[0]).component(this.positionComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).spacer().end(2).component((JComponent)buttonPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().getPanel();
        this.setDimensions(selectPanel, new Dimension(450, 150));
        JPanel selectionPanel = new JPanel(new BorderLayout());
        Dimension referencePointPanelDimensionsAdvanced = new Dimension(675, 150);
        this.setDimensions(selectionPanel, referencePointPanelDimensionsAdvanced);
        selectionPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        selectionPanel.add((Component)selectPanel, "Center");
        selectionPanel.add((Component)patternPanel, "East");
        return selectionPanel;
    }

    private JPanel createButtonPanel(final ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        this.setButton = new JButton(this.textResource.set());
        this.setButton.setName("AtEachPositionProgramNodeView.setPosition");
        this.setButton.setBackground(this.NEXT_ENABLED);
        this.setButton.addActionListener(e -> this.palletUIService.confirmMessageDialog(this.getManualResetWarningMessage(), new ConfirmationDialogListener(){

            public void onOkClicked() {
                ((AtEachPositionProgramNodeContribution)provider.get()).setFeatureToBasePosition((Position)AtEachPositionProgramNodeView.this.positionComboBox.getSelectedItem(), (Pattern)AtEachPositionProgramNodeView.this.patternComboBox.getSelectedItem(), UpdateChildrenStrategy.FORCE_UPDATE, true);
            }
        }));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(this.setButton);
        buttonPanel.add(Box.createGlue());
        return buttonPanel;
    }

    private JPanel createReferencePointTitlePanel() {
        JPanel selectionTitlePanel = new JPanel(new BorderLayout());
        JLabel selectionTitle = new JLabel(this.textResource.atEachReferencePoint());
        selectionTitlePanel.add((Component)selectionTitle, "Center");
        Dimension selectionTitleDimension = new Dimension(675, 47);
        this.setDimensions(selectionTitlePanel, selectionTitleDimension);
        selectionTitlePanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        return selectionTitlePanel;
    }

    private JPanel createTitlePanel(final ContributionProvider<AtEachPositionProgramNodeContribution> provider) {
        Dimension titlePanelDimension = new Dimension(675, 50);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.setDimensions(titlePanel, titlePanelDimension);
        titlePanel.setBorder(new EmptyBorder(10, 0, 0, 0));
        JLabel title = new JLabel(this.textResource.atEachItemDescription());
        JButton wizardButton = new JButton(PalletImageResource.wizard());
        wizardButton.setName("AtEachPositionProgramNodeView.wizard");
        wizardButton.addActionListener(event -> this.palletUIService.confirmMessageDialog(this.getWizardToggleWarningMessage(), new ConfirmationDialogListener(){

            public void onOkClicked() {
                ((AtEachPositionProgramNodeContribution)provider.get()).wizard();
            }
        }));
        titlePanel.add(title);
        titlePanel.add(Box.createHorizontalGlue());
        titlePanel.add(wizardButton);
        return titlePanel;
    }

    private void setDimensions(JComponent selectionPanel, Dimension dimensions) {
        selectionPanel.setPreferredSize(dimensions);
        selectionPanel.setMaximumSize(dimensions);
        selectionPanel.setMinimumSize(dimensions);
    }

    void showPopup() {
        this.palletUIService.warningMessageDialog(this.getWarningMessage(), new OkDialogListener());
    }

    private WarningMessage getWarningMessage() {
        return new WarningMessage(this.textResource.robotNotAtReferencePoint(), this.textResource.useMoveToReferencePoint());
    }

    private ConfirmationMessage getWizardToggleWarningMessage() {
        return new ConfirmationMessage(this.textResource.warning(), this.textResource.switchToWizardWarning(), this.textResource.ok(), this.textResource.cancel());
    }

    private ConfirmationMessage getWizardCancelWarningMessage() {
        return new ConfirmationMessage(this.textResource.warning(), this.textResource.cancelWizardWarning(), this.textResource.ok(), this.textResource.cancel());
    }

    private ConfirmationMessage getManualResetWarningMessage() {
        return new ConfirmationMessage(this.textResource.warning(), this.textResource.manualSetWarning(), this.textResource.ok(), this.textResource.cancel());
    }

    void disableForwardNavigation(String message) {
        this.navigationInfo.setText(message);
        this.navigationInfo.setIcon(message.isEmpty() ? null : PalletImageResource.warning());
        this.next.setEnabled(false);
        this.styleNextButton(false);
    }

    void enableForwardNavigation() {
        this.navigationInfo.setText("");
        this.navigationInfo.setIcon(null);
        this.next.setEnabled(true);
        this.styleNextButton(true);
    }

    public static class ImagePlaceHolder
    extends JLabel {
        final Font tempFont = new Font("Verdana", 1, 20);

        ImagePlaceHolder() {
            this.initComponent();
        }

        private void initComponent() {
            this.setHorizontalAlignment(0);
            this.setPreferredSize(ROBOT_3D_IMAGE_SIZE);
            this.setMaximumSize(ROBOT_3D_IMAGE_SIZE);
            this.setMinimumSize(ROBOT_3D_IMAGE_SIZE);
            this.setAlignmentX(0.0f);
            this.setText("?");
            this.setFont(this.tempFont);
        }
    }
}

