/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.layers;

import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.NamedUUID;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.util.DummyNamedUUID;
import com.ur.polyscope.pallet.impl.util.NamedUUIDRenderingStrategy;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.WidgetFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class LayerRowView
extends JPanel {
    private NamedUUID choosePattern;
    private int layerIndex;
    private JComboBox patternCombo;
    private JButton deleteButton;
    protected LayerSeparator separator;

    public LayerRowView(WidgetFactory widgetFactory, int layerIndex, List<Pattern> patterns, TextResource textResource, boolean[] separators) {
        super(new BorderLayout());
        this.initialize(widgetFactory, layerIndex, patterns, textResource);
        this.separator = new LayerSeparator(widgetFactory, separators);
    }

    public LayerRowView(WidgetFactory widgetFactory, int layerIndex, List<Pattern> patterns, TextResource textResource) {
        super(new BorderLayout());
        this.initialize(widgetFactory, layerIndex, patterns, textResource);
        this.separator = new LayerSeparator(widgetFactory);
    }

    private void initialize(WidgetFactory widgetFactory, int layerIndex, List<Pattern> patterns, TextResource textResource) {
        this.choosePattern = new DummyNamedUUID(textResource.choosePattern(), UUID.fromString("0-0-0-0-0"));
        this.layerIndex = layerIndex;
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BoxLayout(internalPanel, 2));
        internalPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.add((Component)internalPanel, "Center");
        internalPanel.add(Box.createHorizontalStrut(10));
        String layerName = textResource.layer() + "_" + (layerIndex + 1);
        JLabel nameLabel = new JLabel(layerName);
        nameLabel.setPreferredSize(new Dimension(93, 32));
        internalPanel.add(nameLabel);
        internalPanel.add(Box.createGlue());
        this.patternCombo = widgetFactory.createComboBox();
        this.patternCombo.setName(textResource.layer() + "_" + layerIndex);
        this.patternCombo.setMinimumSize(new Dimension(150, 32));
        this.patternCombo.setPreferredSize(new Dimension(275, 32));
        this.patternCombo.setMaximumSize(new Dimension(275, 32));
        ComboBoxRenderer.bindRenderer((JComboBox)this.patternCombo, new NamedUUIDRenderingStrategy<Pattern>(patterns, this.choosePattern));
        DefaultComboBoxModel<NamedUUID> comboBoxModel = new DefaultComboBoxModel<NamedUUID>();
        comboBoxModel.addElement(this.choosePattern);
        for (NamedUUID namedUUID : patterns) {
            comboBoxModel.addElement(namedUUID);
        }
        this.patternCombo.setModel(comboBoxModel);
        internalPanel.add(this.patternCombo);
        this.deleteButton = new JButton();
        this.deleteButton.setIcon(PalletImageResource.delete());
        this.deleteButton.setPreferredSize(new Dimension(32, 32));
        this.deleteButton.setMaximumSize(new Dimension(32, 32));
        internalPanel.add(Box.createHorizontalStrut(5));
        internalPanel.add(this.deleteButton);
    }

    public void setSelection(NamedUUID selection) {
        if (selection == null || this.choosePattern.getUUID().equals(selection.getUUID())) {
            this.patternCombo.setSelectedIndex(0);
        } else {
            this.patternCombo.setSelectedItem(selection);
        }
    }

    public void setDeleteButtonEnabled(boolean enabled) {
        this.deleteButton.setEnabled(enabled);
    }

    public void addPatternListener(ActionListener actionListener) {
        this.patternCombo.addActionListener(actionListener);
    }

    public void addDeleteLayerListener(ActionListener actionListener) {
        this.deleteButton.addActionListener(actionListener);
    }

    public void addSeparatorListener(ActionListener actionListener) {
        this.separator.addActionListener(actionListener);
    }

    public NamedUUID getSelection() {
        if (this.patternCombo.getSelectedIndex() == 0) {
            return null;
        }
        return (NamedUUID)this.patternCombo.getSelectedItem();
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    public class LayerSeparator {
        private final JCheckBox separator;

        public LayerSeparator(WidgetFactory widgetFactory) {
            this.separator = this.createCheckbox(widgetFactory);
            this.separator.setSelected(false);
            this.separator.setEnabled(false);
            LayerRowView.this.add((Component)this.createSeparatorPanel(this.separator), "North");
        }

        public LayerSeparator(WidgetFactory widgetFactory, boolean[] separators) {
            this.separator = this.createCheckbox(widgetFactory);
            if (separators != null) {
                this.separator.setSelected(separators[LayerRowView.this.layerIndex]);
            } else {
                this.separator.setSelected(true);
            }
            LayerRowView.this.add((Component)this.createSeparatorPanel(this.separator), "North");
        }

        public boolean isSelected() {
            return this.separator.isSelected();
        }

        JPanel createSeparatorPanel(JCheckBox separator) {
            JPanel internalPanel = new JPanel();
            internalPanel.setLayout(new BoxLayout(internalPanel, 2));
            internalPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            internalPanel.add(Box.createHorizontalStrut(10));
            internalPanel.add(separator);
            return internalPanel;
        }

        public void addActionListener(ActionListener actionListener) {
            this.separator.addActionListener(actionListener);
        }

        private JCheckBox createCheckbox(WidgetFactory widgetFactory) {
            JCheckBox checkBox = widgetFactory.createCheckBox("Separator");
            checkBox.setFocusPainted(false);
            return checkBox;
        }
    }
}

