/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.layers;

import com.ur.lang.adt.Pair;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.NamedUUID;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.pallet.impl.generated.GeneratedMovement;
import com.ur.polyscope.pallet.impl.layers.Layers;
import com.ur.polyscope.pallet.impl.layers.LayersProgramNodeView;
import com.ur.polyscope.pallet.impl.layers.layertraversal.PalletLayersTraverse;
import com.ur.polyscope.pallet.impl.pallet.Pallet;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.program.nodes.NonVisitable;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.VisualizedContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.media.j3d.Transform3D;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.commons.lang3.ArrayUtils;

public class LayersProgramNodeContribution
extends AbstractCustomProgramNodeContribution
implements Layers,
IconContribution,
VisualizedContribution,
NonVisitable {
    private static final String KEY_PATTERN_SELECTION = "selectedPatterns";
    private static final String KEY_SELECTED_SEPARATORS = "separators";
    private final UndoRedoManager undoRedoManager;
    private final TextResource textResource;
    private final LayersProgramNodeView view;
    private final DataModel model;
    private final ProgramAPIProvider apiProvider;
    private final PalletMotionService palletMotionService;
    private final PalletFeatureService palletFeatureService;

    public LayersProgramNodeContribution(ProgramAPIProvider apiProvider, TextResource textResource, LayersProgramNodeView view, DataModel model, PalletMotionService palletMotionService, PalletFeatureService palletFeatureService) {
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.textResource = textResource;
        this.view = view;
        this.model = model;
        this.apiProvider = apiProvider;
        this.palletMotionService = palletMotionService;
        this.palletFeatureService = palletFeatureService;
    }

    public void openView() {
        if (!this.model.isSet(KEY_PATTERN_SELECTION)) {
            this.initializePatternAndSeparator();
        }
        this.updateLayers();
        this.view.updateIllustration(this.getPallet().isPalletizing(), this.getPallet().getPalletFeatureName());
    }

    private void initializePatternAndSeparator() {
        String[] pnames = new String[]{null};
        this.model.set(KEY_PATTERN_SELECTION, pnames);
        boolean[] separators = new boolean[]{false};
        this.model.set(KEY_SELECTED_SEPARATORS, separators);
    }

    public void closeView() {
    }

    private void updateLayers() {
        this.view.setSeparatorEnabled(this.getPallet().getSeparator() != null);
        String[] stringsFromModel = this.getPatternSelections();
        this.view.setLayers(this.getPatternsWithIDs(stringsFromModel), this.getDefinedPatterns(), this.getSeparators());
    }

    private List<Pattern> getPatternsWithIDs(String[] ids) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        Pallet pallet = this.getPallet();
        if (pallet != null) {
            List<Pattern> patterns = pallet.getPatterns().getDefinedPatterns();
            for (String str : ids) {
                if (str == null) {
                    list.add(null);
                    continue;
                }
                UUID uuid = UUID.fromString(str);
                Pattern patternFromList = this.getPatternFromList(uuid, patterns);
                list.add(patternFromList);
            }
        }
        return list;
    }

    private Pattern getPatternFromList(UUID uuid, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.getUUID().equals(uuid)) continue;
            return pattern;
        }
        return null;
    }

    private List<Pattern> getDefinedPatterns() {
        List<Pattern> patterns = this.getPallet().getPatterns().getDefinedPatterns();
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        for (Pattern pattern : patterns) {
            if (!pattern.isDefined()) continue;
            list.add(pattern);
        }
        return list;
    }

    private Pallet getPallet() {
        return (Pallet)this.getParentContribution();
    }

    public String getTitle() {
        return this.textResource.layers();
    }

    @Override
    public boolean isDefined() {
        String[] patternIds = this.getPatternSelections();
        if (patternIds.length == 0) {
            return false;
        }
        List<Pattern> patternsWithIDs = this.getPatternsWithIDs(patternIds);
        for (Pattern ln : patternsWithIDs) {
            if (ln != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Pattern getFirstLayerPattern() {
        String patternId;
        String[] patternIds = this.getPatternSelections();
        if (patternIds.length > 0 && (patternId = patternIds[0]) != null) {
            return this.getPatternFromList(UUID.fromString(patternId), this.getPallet().getPatterns().getDefinedPatterns());
        }
        return null;
    }

    private String[] getPatternSelections() {
        String[] empty = new String[]{};
        return this.model.get(KEY_PATTERN_SELECTION, empty);
    }

    private boolean[] getSeparators() {
        boolean[] empty = new boolean[]{};
        return this.model.get(KEY_SELECTED_SEPARATORS, empty);
    }

    private void generatePoseDisplacement(ScriptWriter writer, String palletFeatureName, String toDisplace, double inM) {
        if (palletFeatureName.equals(this.apiProvider.getProgramAPI().getFeatureModel().getBaseFeature().getName())) {
            writer.assign("direction", "p[0,0,1,0,0,0]");
        } else {
            palletFeatureName = TypeConversion.toScriptCode(palletFeatureName);
            writer.assign("direction", "pose_trans(p[0,0,0," + palletFeatureName + "[3]," + palletFeatureName + "[4]," + palletFeatureName + "[5]], p[0,0,1,0,0,0])");
        }
        String displ = 0.001 * inM + "";
        writer.assign(toDisplace, "pose_add (" + toDisplace + ",p[" + displ + "*direction[0]," + displ + "*direction[1]," + displ + "*direction[2],0,0,0])");
    }

    public void generateScript(ScriptWriter writer) {
        Pallet pallet = this.getPallet();
        String[] stringsFromModel = this.getPatternSelections();
        PalletLayersTraverse palletTraverse = PalletLayersTraverse.createPalletLayersTraverse(pallet.isPalletizing(), pallet, this.getPatternsWithIDs(stringsFromModel), this.getSeparators());
        List<Pattern> patternsWithIDs = palletTraverse.getOrderedPatterns();
        boolean[] separators = palletTraverse.getOrderedSeparators();
        String countVariableScriptName = writer.getResolvedVariableName(pallet.getCountVariable());
        String layerNoVariableScriptName = writer.getResolvedVariableName(pallet.getLayerNumberVariable());
        String layerCountVariableScriptName = writer.getResolvedVariableName(pallet.getLayerCountVariable());
        String referencePointName = writer.getResolvedVariableName(pallet.getReferencePointVariable());
        String handleSeparatorVariableScriptName = writer.getResolvedVariableName(pallet.getHandleSeparatorVariable());
        String separatorFeaturePointName = writer.getResolvedVariableName(pallet.getSeparatorPointVariable());
        String qNearVariableName = writer.getResolvedVariableName(pallet.getQNearApproachVariable());
        Position separator = pallet.getPatterns().getSeparator();
        if (separator != null) {
            String separatorPositionPoseForScript = separator.createPositionPoseForScript();
            int sepCount = 1;
            for (int i = 0; i < separators.length; ++i) {
                if (!separators[i]) continue;
                int countValue = palletTraverse.getItemCountforSeparatorOnLayer(i);
                if (sepCount == 1) {
                    writer.ifCondition(countVariableScriptName + " == " + countValue);
                    writer.assign(handleSeparatorVariableScriptName, "True");
                } else {
                    writer.elseIfCondition(countVariableScriptName + " == " + countValue);
                    writer.assign(handleSeparatorVariableScriptName, "True");
                }
                writer.assign(separatorFeaturePointName, separatorPositionPoseForScript);
                double totalHeight = palletTraverse.getDisplacementForSeparator(i);
                this.generatePoseDisplacement(writer, pallet.getPalletFeatureName(), separatorFeaturePointName, totalHeight);
                ++sepCount;
            }
            if (sepCount > 1) {
                writer.end();
            }
        }
        int startCount = 0;
        int layerIndex = 0;
        for (Pattern p : patternsWithIDs) {
            int countMax = startCount + p.getPoints();
            if (startCount == 0) {
                writer.ifCondition(countVariableScriptName + " < " + (countMax + 1));
                writer.assign(layerNoVariableScriptName, "1");
                writer.assign(layerCountVariableScriptName, countVariableScriptName);
            } else {
                writer.elseIfCondition(countVariableScriptName + " < " + (countMax + 1));
                writer.assign(layerNoVariableScriptName, layerIndex + 1 + "");
                writer.assign(layerCountVariableScriptName, countVariableScriptName + " - " + startCount);
            }
            startCount = countMax;
            p.doGenerateScript(writer, layerCountVariableScriptName, countVariableScriptName, referencePointName, qNearVariableName);
            double displacementForLayer = palletTraverse.getDisplacementForLayer(layerIndex);
            this.generatePoseDisplacement(writer, pallet.getPalletFeatureName(), referencePointName, displacementForLayer);
            ++layerIndex;
        }
        writer.end();
        this.handleGeneratedMovement(writer, referencePointName, qNearVariableName);
    }

    private void handleGeneratedMovement(ScriptWriter writer, String refVar, String qNearVariableName) {
        Pallet pallet = this.getPallet();
        String pfn = pallet.getPalletFeatureName();
        GeneratedMovement generatedMovement = pallet.getGeneratedMovement();
        if (generatedMovement != null) {
            PalletProgramFeature referencePointFeature = pallet.getReferencePointFeature();
            Pose6d baseToFeature = referencePointFeature.getBaseToFeature();
            Pose6d baseToReferencePoint = new Pose6d((Tuple3d)referencePointFeature.getToolPosition(), (Tuple3d)referencePointFeature.getToolAxisAngle());
            String funcName = pallet.getComputePalletWaypointFunctionName();
            for (GeneratedMovement.MoveNodeFunction mnf : GeneratedMovement.MoveNodeFunction.values()) {
                String moveNodeFeature = this.palletFeatureService.getMoveNodeFeatureName(generatedMovement.getTopLevelMoveNode(mnf));
                for (Pair<String, WaypointNode> pair : generatedMovement.getWaypointsForMoveNode(mnf)) {
                    WaypointNode waypointNode = (WaypointNode)pair.getSecond();
                    Pose6d featureToWaypoint = this.palletMotionService.getWaypointPointPoseInFeatureCoordinates(waypointNode);
                    Transform3D baseToFeatureWaypointTransform = this.palletMotionService.getBaseToFeatureTransform(waypointNode);
                    Pose6d baseToFeatureWaypoint = this.palletMotionService.getPose6dEquivalentOfTransform3D(baseToFeatureWaypointTransform);
                    String featToRef = "pose_trans(pose_inv(" + baseToFeature + "), " + baseToReferencePoint + ")";
                    if (pallet.getPalletFeatureName().equals(this.apiProvider.getProgramAPI().getFeatureModel().getBaseFeature().getName())) {
                        pfn = "p[0.0,0.0,0.0,0.0,0.0,0.0]";
                    }
                    pfn = TypeConversion.toScriptCode(pfn);
                    String params = baseToFeature + ", " + featToRef + ", " + featureToWaypoint + ", " + pfn + ", " + refVar;
                    writer.assign((String)pair.getFirst() + "_p", funcName + "(" + params + ")");
                    writer.assign((String)pair.getFirst() + "_p", "pose_trans(" + baseToFeatureWaypoint + ", pose_trans(pose_inv(" + moveNodeFeature + "), " + (String)pair.getFirst() + "_p))");
                    if (!GeneratedMovement.MoveNodeFunction.APPROACH.equals((Object)mnf)) continue;
                    writer.assign((String)pair.getFirst() + "_q", qNearVariableName);
                }
            }
        }
    }

    @Override
    public int getPoints() {
        int count = 0;
        String[] stringsFromModel = this.getPatternSelections();
        List<Pattern> patternsWithIDs = this.getPatternsWithIDs(stringsFromModel);
        for (Pattern p : patternsWithIDs) {
            count += p.getPoints();
        }
        return count;
    }

    private boolean hasSelectionChanged(NamedUUID newPatternId, String oldId) {
        if (newPatternId == null) {
            return oldId != null;
        }
        return oldId == null || !oldId.equals(newPatternId.getUUID().toString());
    }

    void patternSelectedForLayer(NamedUUID newPatternId, int layerIndex) {
        String[] patternIDs = this.getPatternSelections();
        String oldPatternID = patternIDs[layerIndex];
        if (this.hasSelectionChanged(newPatternId, oldPatternID)) {
            this.undoRedoManager.recordChanges(() -> {
                patternIDs[layerIndex] = newPatternId == null ? null : newPatternId.getUUID().toString();
                this.model.set(KEY_PATTERN_SELECTION, patternIDs);
                if (layerIndex == 0) {
                    this.getPallet().updateReferencePoint();
                }
            });
            this.getPallet().resetItemCounter();
        }
    }

    private String[] extendArrayWithNull(String[] array) {
        String[] extended = new String[array.length + 1];
        extended[array.length] = null;
        System.arraycopy(array, 0, extended, 0, array.length);
        return extended;
    }

    private boolean[] extendArrayWithBoolean(boolean[] array, boolean value) {
        boolean[] extended = new boolean[array.length + 1];
        extended[array.length] = value;
        System.arraycopy(array, 0, extended, 0, array.length);
        return extended;
    }

    void addLayer() {
        this.undoRedoManager.recordChanges(() -> {
            String[] selectedPatternIds = this.getPatternSelections();
            boolean[] separators = this.getSeparators();
            boolean isEnabled = this.getPallet().getSeparator() != null;
            separators = this.extendArrayWithBoolean(separators, isEnabled);
            this.model.set(KEY_SELECTED_SEPARATORS, separators);
            selectedPatternIds = this.extendArrayWithNull(selectedPatternIds);
            this.model.set(KEY_PATTERN_SELECTION, selectedPatternIds);
        });
        this.updateLayers();
        this.getPallet().resetItemCounter();
    }

    void deleteLayer(int index) {
        this.undoRedoManager.recordChanges(() -> {
            Object[] selectedPatternIds = this.getPatternSelections();
            boolean[] separators = this.getSeparators();
            separators = ArrayUtils.remove((boolean[])separators, (int)index);
            selectedPatternIds = (String[])ArrayUtils.remove((Object[])selectedPatternIds, (int)index);
            this.model.set(KEY_PATTERN_SELECTION, (String[])selectedPatternIds);
            this.model.set(KEY_SELECTED_SEPARATORS, separators);
            if (index == 0) {
                this.getPallet().updateReferencePoint();
            }
        });
        this.updateLayers();
        this.getPallet().resetItemCounter();
    }

    void separatorChanged(int layerIndex, boolean b1) {
        boolean[] separators = this.getSeparators();
        separators[layerIndex] = b1;
        this.undoRedoManager.recordChanges(() -> this.model.set(KEY_SELECTED_SEPARATORS, separators));
        this.getPallet().resetItemCounter();
    }

    @Override
    public void setSeparatorEnabled(boolean isEnabled) {
        if (!this.model.isSet(KEY_PATTERN_SELECTION)) {
            this.initializePatternAndSeparator();
        }
        boolean[] separators = this.getSeparators();
        for (int i = 0; i < separators.length; ++i) {
            separators[i] = isEnabled;
        }
        this.undoRedoManager.recordChanges(() -> this.model.set(KEY_SELECTED_SEPARATORS, separators));
        this.view.setSeparatorEnabled(isEnabled);
    }

    @Override
    public boolean isPatternUsed(Pattern pattern) {
        List<String> ids = Arrays.asList(this.getPatternSelections());
        return ids.contains(pattern.getUUID().toString());
    }

    @Override
    public boolean isSeparatorUsed() {
        return !this.getEnabledSeparators().isEmpty();
    }

    public Icon getIcon(boolean isUndefined) {
        return isUndefined ? PalletImageResource.layerUndefined() : PalletImageResource.layerDefined();
    }

    @Override
    public JointPositionVector getActualJointPositionVector() {
        Pattern pattern;
        double displacement;
        Pallet pallet = this.getPallet();
        PalletLayersTraverse palletTraverse = PalletLayersTraverse.createPalletLayersTraverse(pallet.isPalletizing(), pallet, this.getPatternsWithIDs(this.getPatternSelections()), this.getSeparators());
        int startItemCount = pallet.getStartItemCount();
        if (startItemCount > 1) {
            Pair<Integer, Pattern> layerForItem = palletTraverse.getLayerForItem(startItemCount);
            displacement = palletTraverse.getDisplacementForLayer((Integer)layerForItem.getFirst());
            pattern = (Pattern)layerForItem.getSecond();
        } else {
            displacement = palletTraverse.getStartDisplacement();
            pattern = palletTraverse.getOrderedPatterns().get(0);
        }
        Position position = pattern.getPositions().get(0);
        Point3d toolPosition = position.getActualToolPosition();
        Point3d toolAxisAngle = position.getActualToolAxisAngle();
        Tuple3d newToolPosition = this.palletMotionService.displacePose((Tuple3d)toolPosition, displacement, pallet.getPalletFeatureName());
        return this.palletMotionService.getInverseKinematics(new Point3d(newToolPosition), toolAxisAngle, position.getActualJointPositions());
    }

    public Set<Vector3d> getPositionsAsVector3d() {
        HashSet<Vector3d> allPositions = new HashSet<Vector3d>();
        Pallet pallet = this.getPallet();
        if (pallet == null) {
            return allPositions;
        }
        List<Pattern> patternsWithIDs = this.getPatternsWithIDs(this.getPatternSelections());
        boolean[] separators = this.getSeparators();
        PalletLayersTraverse palletTraverse = PalletLayersTraverse.createPalletLayersTraverse(true, this.getPallet(), patternsWithIDs, separators);
        for (int i = 0; i < patternsWithIDs.size(); ++i) {
            Pattern p = patternsWithIDs.get(i);
            if (i != 0) {
                double displacementForLayer = palletTraverse.getDisplacementForLayer(i);
                allPositions.addAll(this.palletMotionService.displacePoses(p.getPositionsAsVector3d(), displacementForLayer, pallet.getPalletFeatureName()));
                continue;
            }
            allPositions.addAll(p.getPositionsAsVector3d());
        }
        if (pallet.getSeparator() != null) {
            Set<Integer> sepIndexes = this.getEnabledSeparators();
            Point3d toolPosition = pallet.getSeparator().getActualToolPosition();
            if (toolPosition != null && !sepIndexes.isEmpty()) {
                Vector3d sepPositionAsVector3d = new Vector3d((Tuple3d)toolPosition);
                Iterator<Integer> it = sepIndexes.iterator();
                while (it.hasNext()) {
                    double displacementForSeparator = palletTraverse.getDisplacementForSeparator(it.next());
                    Vector3d v = new Vector3d(sepPositionAsVector3d);
                    allPositions.add((Vector3d)this.palletMotionService.displacePose((Tuple3d)v, displacementForSeparator, pallet.getPalletFeatureName()));
                }
            }
        }
        return allPositions;
    }

    private Set<Integer> getEnabledSeparators() {
        HashSet<Integer> set = new HashSet<Integer>();
        boolean[] separators = this.getSeparators();
        for (int i = 0; i < separators.length; ++i) {
            if (!separators[i]) continue;
            set.add(i);
        }
        return set;
    }
}

