/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.layers;

import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.NamedUUID;
import com.ur.polyscope.pallet.impl.layers.LayerRowView;
import com.ur.polyscope.pallet.impl.layers.LayersProgramNodeContribution;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class LayersProgramNodeView
implements SwingProgramNodeView<LayersProgramNodeContribution> {
    private JPanel layersPanel;
    private WidgetFactory widgetFactory;
    private final TextResource textResource;
    private ContributionProvider<LayersProgramNodeContribution> layersProgramNodeContributionContributionProvider;
    private boolean separatorEnabled = false;
    private JLabel illustration;
    private JLabel layersDescription;

    public LayersProgramNodeView(WidgetFactory widgetFactory, TextResource textResource) {
        this.widgetFactory = widgetFactory;
        this.textResource = textResource;
    }

    public void buildUI(JPanel mainPanel, ContributionProvider<LayersProgramNodeContribution> provider) {
        this.layersProgramNodeContributionContributionProvider = provider;
        mainPanel.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel northEastPanel = new JPanel();
        this.illustration = new JLabel();
        this.setDimensions(this.illustration, new Dimension(184, 95));
        northEastPanel.add(this.illustration);
        int eastPanelWidth = 184;
        this.setDimensions(northEastPanel, new Dimension(eastPanelWidth, 100));
        northPanel.add((Component)northEastPanel, "East");
        JPanel northCenterPanel = new JPanel(new BorderLayout());
        this.layersDescription = new JLabel();
        northCenterPanel.add((Component)this.layersDescription, "North");
        JButton addLayersButton = this.widgetFactory.createButton((Action)((Object)new AddLayersAction()));
        this.setDimensions(addLayersButton, new Dimension(220, 40));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(addLayersButton);
        buttonPanel.add(Box.createHorizontalGlue());
        northPanel.add((Component)northCenterPanel, "Center");
        mainPanel.add((Component)northPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel centerEastPanel = new JPanel();
        this.setDimensions(centerEastPanel, new Dimension(eastPanelWidth, 500));
        centerEastPanel.add(buttonPanel);
        centerPanel.add((Component)centerEastPanel, "East");
        JScrollPane layersScrollPane = new JScrollPane();
        centerPanel.add((Component)layersScrollPane, "Center");
        mainPanel.add((Component)centerPanel, "Center");
        this.layersPanel = new JPanel();
        this.layersPanel.setLayout(new BoxLayout(this.layersPanel, 1));
        JPanel scrollViewPortPanel = new JPanel(new FlowLayout(0, 0, 0));
        scrollViewPortPanel.add(this.layersPanel);
        layersScrollPane.setViewportView(scrollViewPortPanel);
        layersScrollPane.setBackground(G5LookAndFeel.DEFAULT_BACKGROUND);
    }

    void updateIllustration(boolean isPalletizing, String featureName) {
        this.layersDescription.setText(isPalletizing ? this.textResource.layersPalletizing(featureName) : this.textResource.layersDepalletizing(featureName));
    }

    private void setDimensions(JComponent component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }

    private void selectIllustration(int size) {
        if (size < 2) {
            this.illustration.setIcon(PalletImageResource.layer1());
        } else if (size < 3) {
            this.illustration.setIcon(PalletImageResource.layer2());
        } else {
            this.illustration.setIcon(PalletImageResource.layer3());
        }
    }

    void setLayers(List<Pattern> selectedPatterns, List<Pattern> patterns, boolean[] separators) {
        this.selectIllustration(selectedPatterns.size());
        this.layersPanel.removeAll();
        boolean multiplePatterns = selectedPatterns.size() > 1;
        for (int i = 0; i < selectedPatterns.size(); ++i) {
            LayerRowView layerRow = this.separatorEnabled ? new LayerRowView(this.widgetFactory, i, patterns, this.textResource, separators) : new LayerRowView(this.widgetFactory, i, patterns, this.textResource);
            layerRow.setDeleteButtonEnabled(multiplePatterns);
            Pattern p = selectedPatterns.get(i);
            if (p == null) {
                layerRow.setSelection(null);
            } else {
                Optional<Pattern> optional = patterns.stream().filter(pattern -> pattern.getName().equals(p.getName())).findFirst();
                layerRow.setSelection(optional.isPresent() ? (NamedUUID)optional.get() : null);
            }
            layerRow.addPatternListener(e -> ((LayersProgramNodeContribution)this.layersProgramNodeContributionContributionProvider.get()).patternSelectedForLayer(layerRow.getSelection(), layerRow.getLayerIndex()));
            layerRow.addDeleteLayerListener(e -> ((LayersProgramNodeContribution)this.layersProgramNodeContributionContributionProvider.get()).deleteLayer(layerRow.getLayerIndex()));
            if (this.separatorEnabled) {
                layerRow.addSeparatorListener(e -> ((LayersProgramNodeContribution)this.layersProgramNodeContributionContributionProvider.get()).separatorChanged(layerRow.getLayerIndex(), layerRow.separator.isSelected()));
            }
            this.layersPanel.add((Component)layerRow, 0);
        }
        SwingUtilities.invokeLater(() -> {
            this.layersPanel.revalidate();
            this.layersPanel.repaint();
        });
    }

    void setSeparatorEnabled(boolean separatorEnabled) {
        this.separatorEnabled = separatorEnabled;
    }

    private class AddLayersAction
    extends AbstractActionDefinition {
        AddLayersAction() {
            this.putValue("Name", LayersProgramNodeView.this.textResource.addLayer());
            this.putValue("Function", ActionDefinition.Function.PRIMARY);
            this.putValue("InternalName", "ADD_LAYER");
        }

        public void actionPerformed(ActionEvent e) {
            ((LayersProgramNodeContribution)LayersProgramNodeView.this.layersProgramNodeContributionContributionProvider.get()).addLayer();
        }
    }
}

