/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.layers.layertraversal;

import com.ur.lang.adt.Pair;
import com.ur.polyscope.pallet.impl.layers.layertraversal.DePalletizeTraverse;
import com.ur.polyscope.pallet.impl.layers.layertraversal.PalletizeTraverse;
import com.ur.polyscope.pallet.impl.pallet.Pallet;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import java.util.List;

public abstract class PalletLayersTraverse {
    protected final double layerDisplacement;
    protected final double separatorDisplacement;
    protected final List<Pattern> patterns;
    protected final boolean[] separators;
    protected Pallet pallet;

    PalletLayersTraverse(Pallet pallet, List<Pattern> patternsWithIDs, boolean[] separators) {
        this.pallet = pallet;
        this.layerDisplacement = pallet.getObjectHeight();
        this.separatorDisplacement = pallet.getPatterns().getSeparatorHeight();
        this.patterns = patternsWithIDs;
        this.separators = separators;
    }

    public static PalletLayersTraverse createPalletLayersTraverse(boolean isPalletizing, Pallet pallet, List<Pattern> patternsWithIDs, boolean[] separators) {
        if (isPalletizing) {
            return new PalletizeTraverse(pallet, patternsWithIDs, separators);
        }
        return new DePalletizeTraverse(pallet, patternsWithIDs, separators);
    }

    public abstract List<Pattern> getOrderedPatterns();

    public abstract boolean[] getOrderedSeparators();

    public abstract double getDisplacementForSeparator(int var1);

    public abstract double getStartDisplacement();

    public abstract double getDisplacementForLayer(int var1);

    public abstract int getItemCountforSeparatorOnLayer(int var1);

    public Pair<Integer, Pattern> getLayerForItem(int item) {
        List<Pattern> orderedPatterns = this.getOrderedPatterns();
        int count = 0;
        for (int i = 0; i < orderedPatterns.size(); ++i) {
            Pattern p = orderedPatterns.get(i);
            if (item > (count += p.getPoints())) continue;
            return new Pair((Object)i, (Object)p);
        }
        return new Pair((Object)0, (Object)orderedPatterns.get(0));
    }
}

