/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.pallet;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.JointPositionVector;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletNamingService;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.pallet.impl.actionafter.ActionAfter;
import com.ur.polyscope.pallet.impl.actionafter.ActionAfterNodeService;
import com.ur.polyscope.pallet.impl.actionbefore.ActionBefore;
import com.ur.polyscope.pallet.impl.actionbefore.ActionBeforeNodeService;
import com.ur.polyscope.pallet.impl.ateachposition.AtEach;
import com.ur.polyscope.pallet.impl.ateachposition.AtEachPositionNodeService;
import com.ur.polyscope.pallet.impl.generated.GeneratedMovement;
import com.ur.polyscope.pallet.impl.layers.Layers;
import com.ur.polyscope.pallet.impl.layers.LayersNodeService;
import com.ur.polyscope.pallet.impl.pallet.CounterNameValidator;
import com.ur.polyscope.pallet.impl.pallet.Pallet;
import com.ur.polyscope.pallet.impl.pallet.PalletNameValidator;
import com.ur.polyscope.pallet.impl.pallet.PalletNewVersionToggle;
import com.ur.polyscope.pallet.impl.pallet.PalletProgramNodeView;
import com.ur.polyscope.pallet.impl.pallet.ScriptFunctions;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.patterns.Patterns;
import com.ur.polyscope.pallet.impl.patterns.PatternsNodeService;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.separatoraction.SeparatorAction;
import com.ur.polyscope.pallet.impl.separatoraction.SeparatorActionNodeService;
import com.ur.polyscope.pallet.impl.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.move.Positional;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionLoadCompleteContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionRemovedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionRemovedListener;
import com.ur.polyscope.valueobjects.Length;
import com.ur.swing.SwingUtil;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.BaseFeature;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.variable.GlobalVariable;
import com.ur.urcap.api.domain.variable.PersistedVariable;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class PalletProgramNodeContribution
extends AbstractCustomProgramNodeContribution
implements Pallet,
IconContribution,
Positional,
ContributionRemovedListener {
    private static final String KEY_NAME = "name";
    private static final String KEY_BEFORE_SELECTED = "beforeSelected";
    private static final String KEY_AFTER_SELECTED = "afterSelected";
    private static final String KEY_PALLET_FEATURE = "palletFeature";
    private static final String KEY_OBJECT_HEIGHT = "objectHeight";
    private static final String KEY_COUNT_VARIABLE = "globalCountingVariable";
    private static final String KEY_LAYERNO_VARIABLE = "layerNumberVariable";
    private static final String KEY_LAYERCOUNT_VARIABLE = "layerCountingVariable";
    private static final String KEY_TOTALCOUNT_VARIABLE = "totalCountVariable";
    private static final String KEY_HANDLE_SEPARATOR_VARIABLE = "handleSeparatorVariable";
    private static final String KEY_REMEMBER_TRAVERSAL = "rememberTraversal";
    private static final String KEY_IS_PALLETIZING = "isPalletizing";
    private static final String KEY_REFERENCE_POINT_VARIABLE = "referencePoint";
    private static final String KEY_SEPARATOR_POINT_VARIABLE = "separatorPoint";
    private static final String COUNT_VARIABLE_SUFFIX = "cnt";
    private static final String LAYER_VARIABLE_SUFFIX = "lno";
    private static final String LAYER_COUNT_VARIABLE_SUFFIX = "lct";
    private static final String TOTAL_COUNT_VARIABLE_SUFFIX = "tct";
    private static final String SEPARATOR_VARIABLE_SUFFIX = "sep";
    private static final String BASE = "Base";
    private static final String Q_NEAR_NAME = "qNearApproach";
    private static final double DELTA = 1.0E-4;
    private final ProgramAPI programAPI;
    private final UndoRedoManager undoRedoManager;
    private final TextResource textResource;
    private final KeyboardInputFactory keyboardFactory;
    private final PalletProgramNodeView view;
    private final DataModel model;
    private final PalletNamingService palletNamingService;
    private final PalletFeatureService palletFeatureService;
    private final String translatedBase;
    private volatile boolean creating;
    private final Icon palletUndefined;
    private final Icon palletDefined;
    private TreeNode rootNode = null;

    PalletProgramNodeContribution(ProgramAPIProvider apiProvider, TextResource textResource, PalletProgramNodeView view, DataModel model, PalletNamingService palletNamingService, PalletFeatureService palletFeatureService) {
        this.programAPI = apiProvider.getProgramAPI();
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.textResource = textResource;
        this.view = view;
        this.model = model;
        this.keyboardFactory = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.palletNamingService = palletNamingService;
        this.palletFeatureService = palletFeatureService;
        this.translatedBase = this.programAPI.getFeatureModel().getBaseFeature().getName();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(true);
        this.creating = true;
        this.palletUndefined = PalletImageResource.palletUndefined();
        this.palletDefined = PalletImageResource.palletDefined();
    }

    private static AbstractCustomProgramNodeContribution getTreeNodeAsAbstracContribution(TreeNode rootTreeNode, Class<?> intf) {
        return (AbstractCustomProgramNodeContribution)PalletProgramNodeContribution.getTreeNodeAsClass(rootTreeNode, intf);
    }

    private static <T> T getTreeNodeAsClass(TreeNode rootTreeNode, Class<T> intf) {
        TreeNode childTreeNode = PalletProgramNodeContribution.getChildTreeNode(rootTreeNode, intf);
        if (childTreeNode == null) {
            return null;
        }
        URCapProgramNode programNode = (URCapProgramNode)childTreeNode.getProgramNode();
        if (programNode == null) {
            return null;
        }
        if (!programNode.canGetAs(intf)) {
            return null;
        }
        return (T)programNode.getAs(intf);
    }

    private static void removeTreeNode(TreeNode rootTreeNode, TreeNode childTreeNode) {
        try {
            rootTreeNode.removeChild(childTreeNode);
        }
        catch (TreeStructureException e) {
            Log.error((String)"Unable to remove child node", (Throwable)e);
        }
    }

    private static TreeNode getChildTreeNode(TreeNode rootTreeNode, Class<?> intf) {
        for (TreeNode treeNode : rootTreeNode.getChildren()) {
            ProgramNode programNode = treeNode.getProgramNode();
            if (!(programNode instanceof URCapProgramNode) || !((URCapProgramNode)programNode).canGetAs(intf)) continue;
            return treeNode;
        }
        return null;
    }

    private void initializeGlobalVariables() {
        GlobalVariable palletNameVariable = this.createPalletNameVariable("Pallet_1");
        if (palletNameVariable == null) {
            return;
        }
        this.createCountingVariableWithName(palletNameVariable.getDisplayName() + "_" + COUNT_VARIABLE_SUFFIX);
        this.createLayerNumberVariable(palletNameVariable.getDisplayName() + "_" + LAYER_VARIABLE_SUFFIX);
        this.createLayerCountVariable(palletNameVariable.getDisplayName() + "_" + LAYER_COUNT_VARIABLE_SUFFIX);
        this.createHandleSeperatorVariable(palletNameVariable.getDisplayName() + "_" + SEPARATOR_VARIABLE_SUFFIX);
        this.createTotalCountVariable(palletNameVariable.getDisplayName() + "_" + TOTAL_COUNT_VARIABLE_SUFFIX);
    }

    public void openView() {
        this.checkAndCreateMissingInstallationVariable();
        this.updateView();
        this.validateFeatureSelection();
    }

    private void checkAndCreateMissingInstallationVariable() {
        Variable variable;
        if (this.hasRememberTraversal() && (variable = this.model.get(KEY_COUNT_VARIABLE, (Variable)null)) instanceof PersistedVariable && !((PersistedVariable)variable).isResolvable()) {
            Variable globalCountVariable = this.createInstallationVariable(this.getPalletName() + "_" + COUNT_VARIABLE_SUFFIX);
            this.undoRedoManager.recordChanges(() -> this.model.set(KEY_COUNT_VARIABLE, globalCountVariable));
        }
    }

    @Override
    public double getObjectHeight() {
        return this.getMetricHeight();
    }

    public void setObjectHeight(com.ur.urcap.api.domain.value.simple.Length height) {
        this.undoRedoManager.recordChanges(() -> {
            this.setHeight(height);
            this.updateView();
        });
    }

    KeyboardTextInput getPalletNameKeyboard() {
        KeyboardTextInput keyboard = this.keyboardFactory.createStringKeyboardInput();
        keyboard.setInitialValue(this.getPalletName());
        keyboard.setErrorValidator((InputValidator)new PalletNameValidator(this, this.textResource, this.palletNamingService));
        return keyboard;
    }

    KeyboardInputCallback<String> getPalletNameCallback() {
        return new KeyboardInputCallback<String>(){

            public void onOk(String s) {
                PalletProgramNodeContribution.this.setPalletName(s);
            }
        };
    }

    KeyboardTextInput getCounterNameKeyboard() {
        KeyboardTextInput keyboard = this.keyboardFactory.createStringKeyboardInput();
        keyboard.setInitialValue(this.getCountingVariableName());
        keyboard.setErrorValidator((InputValidator)new CounterNameValidator(this, this.textResource, this.palletNamingService));
        return keyboard;
    }

    KeyboardInputCallback<String> getCounterNameCallback() {
        return new KeyboardInputCallback<String>(){

            public void onOk(String s) {
                if (PalletProgramNodeContribution.this.hasRememberTraversal()) {
                    PalletProgramNodeContribution.this.palletNamingService.removeInstallationVariable(PalletProgramNodeContribution.this.getCountingVariableName());
                }
                PalletProgramNodeContribution.this.createCountingVariableWithName(s);
            }
        };
    }

    public void closeView() {
        this.view.close();
    }

    public String getTitle() {
        return this.getPalletName();
    }

    @Override
    protected List<AbstractCustomProgramNodeContribution> getProgramNodeContributionChildren() {
        ArrayList<AbstractCustomProgramNodeContribution> result = new ArrayList<AbstractCustomProgramNodeContribution>();
        if (this.rootNode == null) {
            this.rootNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        }
        this.addContributionIfNotNull(result, Layers.class);
        this.addContributionIfNotNull(result, AtEach.class);
        this.addContributionIfNotNull(result, Patterns.class);
        this.addContributionIfNotNull(result, ActionBefore.class);
        this.addContributionIfNotNull(result, SeparatorAction.class);
        this.addContributionIfNotNull(result, ActionAfter.class);
        return result;
    }

    private void addContributionIfNotNull(List<AbstractCustomProgramNodeContribution> result, Class<?> intf) {
        AbstractCustomProgramNodeContribution contribution = PalletProgramNodeContribution.getTreeNodeAsAbstracContribution(this.rootNode, intf);
        if (contribution != null) {
            result.add(contribution);
        }
    }

    public boolean isDefined() {
        Variable variable;
        Position separator;
        PalletProgramFeature separatorFeature = this.getSeparatorFeature();
        if (separatorFeature != null && separatorFeature.isUndefined() && (separator = this.getSeparator()) != null && separator.isDefined()) {
            this.setSeparatorFeaturePosition(separator);
        }
        boolean defined = true;
        if (this.hasRememberTraversal() && (variable = this.model.get(KEY_COUNT_VARIABLE, (Variable)null)) instanceof PersistedVariable) {
            defined = ((PersistedVariable)variable).isResolvable();
        }
        return defined && !EqualsUtil.equals((double)this.getMetricHeight(), (double)0.0, (double)1.0E-4);
    }

    public void generateScript(ScriptWriter writer) {
        String palletName = this.getPalletName();
        ScriptFunctions.generateComputePalletWaypointFunction(writer, palletName);
        Layers layers = this.getLayers();
        int totalCountValue = layers.getPoints();
        String totalCountVariableName = writer.getResolvedVariableName(this.model.get(KEY_TOTALCOUNT_VARIABLE, (Variable)null));
        writer.assign(totalCountVariableName, totalCountValue + "");
        String countVariableScriptName = writer.getResolvedVariableName(this.getCountVariable());
        writer.ifCondition(countVariableScriptName + " > " + totalCountValue + " or " + countVariableScriptName + " < 1");
        writer.assign(countVariableScriptName, "1");
        writer.end();
        writer.writeChildren();
        String handleSeparatorVariableScriptName = writer.getResolvedVariableName(this.getHandleSeparatorVariable());
        writer.assign(handleSeparatorVariableScriptName, "False");
        writer.ifCondition(countVariableScriptName + " >= " + totalCountValue);
        writer.assign(countVariableScriptName, "1");
        writer.elseCondition();
        writer.assign(countVariableScriptName, countVariableScriptName + " + 1");
        writer.end();
    }

    void setFeature(String feature) {
        this.undoRedoManager.recordChanges(() -> {
            this.setFeatureOnModel(feature);
            if (this.getLayers().isDefined()) {
                this.updateReferencePoint();
            }
        });
        this.validateFeatureSelection();
    }

    private void setFeatureOnModel(String feature) {
        feature = feature.equals(this.translatedBase) ? BASE : feature;
        this.model.set(KEY_PALLET_FEATURE, feature);
    }

    private String getFeatureFromModel(String defaultValue) {
        String feature = this.model.get(KEY_PALLET_FEATURE, defaultValue);
        return BASE.equals(feature) ? this.translatedBase : feature;
    }

    private Variable createNonInstallationVariable(String name) {
        return this.createNonInstallationVariable(name, "1");
    }

    private Variable createNonInstallationVariable(String name, String value) {
        try {
            Expression expr = this.programAPI.getValueFactoryProvider().createExpressionBuilder().append(value).build();
            return this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(name, expr);
        }
        catch (VariableException e) {
            Log.error((String)"Unable to create non installation variable", (Throwable)e);
        }
        catch (InvalidExpressionException e) {
            Log.error((String)"Unable to create initial variable expression", (Throwable)e);
        }
        return null;
    }

    String getPalletName() {
        Variable palletVarible = this.model.get(KEY_NAME, (Variable)null);
        return palletVarible == null ? "" : palletVarible.getDisplayName();
    }

    private void setPalletName(String name) {
        try {
            GlobalVariable variable = this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(name);
            this.undoRedoManager.recordChanges(() -> this.model.set(KEY_NAME, (Variable)variable));
        }
        catch (VariableException e) {
            Log.error((String)"Unable to create Pallet name variable", (Throwable)e);
        }
        this.updateView();
    }

    String getCountingVariableName() {
        return this.model.get(KEY_COUNT_VARIABLE, (Variable)null).getDisplayName();
    }

    private void createCountingVariableWithName(String suggestedName) {
        this.undoRedoManager.recordChanges(() -> {
            Variable variable = this.hasRememberTraversal() ? this.createInstallationVariable(suggestedName) : this.createNonInstallationVariable(suggestedName);
            this.model.set(KEY_COUNT_VARIABLE, variable);
        });
        this.updateView();
    }

    private boolean hasRememberTraversal() {
        return this.model.get(KEY_REMEMBER_TRAVERSAL, false);
    }

    void setRememberTraversal(boolean selected) {
        if (selected == this.hasRememberTraversal()) {
            return;
        }
        this.undoRedoManager.recordChanges(() -> {
            this.model.set(KEY_REMEMBER_TRAVERSAL, selected);
            if (selected) {
                String countingName = this.getCountingVariableName();
                this.model.remove(KEY_COUNT_VARIABLE);
                Variable globalCountVariable = this.createInstallationVariable(countingName);
                this.model.set(KEY_COUNT_VARIABLE, globalCountVariable);
            } else {
                String countingName = this.getCountingVariableName();
                this.palletNamingService.removeInstallationVariable(countingName);
                this.model.remove(KEY_COUNT_VARIABLE);
                this.model.set(KEY_COUNT_VARIABLE, this.createNonInstallationVariable(countingName));
            }
        });
        this.updateView();
    }

    @Override
    public void resetItemCounter() {
        if (this.hasRememberTraversal()) {
            this.undoRedoManager.recordChanges(() -> this.palletNamingService.updateInstallationVariableValue(this.getCountingVariableName(), "1"));
        }
    }

    private Variable createInstallationVariable(String name) {
        String[] checkName = new String[]{name};
        int postfix = 1;
        while (!this.programAPI.getVariableModel().get(variable -> variable.getDisplayName().equals(checkName[0])).isEmpty()) {
            checkName[0] = (name + postfix).length() > 15 ? name.substring(0, 15 - ("" + postfix).length()) + postfix : name + postfix;
            ++postfix;
        }
        return this.palletNamingService.createInstallationVariable(checkName[0], this.programAPI.getVariableModel());
    }

    @Override
    public void setActionBeforeSelected(boolean selected) {
        ProgramNodeFactory programNodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.undoRedoManager.recordChanges(() -> {
            this.model.set(KEY_BEFORE_SELECTED, selected);
            if (selected) {
                URCapProgramNode nodeToAdd = programNodeFactory.createURCapProgramNode(ActionBeforeNodeService.class);
                TreeNode childTreeNodeAfter = (TreeNode)rootTreeNode.getChildren().get(0);
                try {
                    rootTreeNode.insertChildBefore(childTreeNodeAfter, (ProgramNode)nodeToAdd);
                    ((AbstractCustomProgramNodeContribution)nodeToAdd.getAs(ActionBefore.class)).setParentContribution(this);
                }
                catch (TreeStructureException treeStructureException) {
                    Log.error((String)"Unable to insert Action Before node", (Throwable)treeStructureException);
                }
            } else {
                TreeNode childTreeNode = PalletProgramNodeContribution.getChildTreeNode(rootTreeNode, ActionBefore.class);
                PalletProgramNodeContribution.removeTreeNode(rootTreeNode, childTreeNode);
            }
        });
    }

    @Override
    public void setActionAfterSelected(boolean selected) {
        ProgramNodeFactory programNodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.undoRedoManager.recordChanges(() -> {
            this.model.set(KEY_AFTER_SELECTED, selected);
            if (selected) {
                URCapProgramNode nodeToAdd = programNodeFactory.createURCapProgramNode(ActionAfterNodeService.class);
                try {
                    rootTreeNode.addChild((ProgramNode)nodeToAdd);
                    ((AbstractCustomProgramNodeContribution)nodeToAdd.getAs(ActionAfter.class)).setParentContribution(this);
                }
                catch (TreeStructureException treeStructureException) {
                    Log.error((String)"Unable to insert Action After node", (Throwable)treeStructureException);
                }
            } else {
                TreeNode childTreeNode = PalletProgramNodeContribution.getChildTreeNode(rootTreeNode, ActionAfter.class);
                PalletProgramNodeContribution.removeTreeNode(rootTreeNode, childTreeNode);
            }
        });
    }

    @Override
    public void setSeparatorsEnabled(boolean isEnabled) {
        TreeNode layersNode;
        ProgramNodeFactory nodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        if (isEnabled) {
            URCapProgramNode separatorAction = nodeFactory.createURCapProgramNode(SeparatorActionNodeService.class);
            try {
                if (this.isPalletizing()) {
                    root.insertChildAfter(PalletProgramNodeContribution.getChildTreeNode(root, AtEach.class), (ProgramNode)separatorAction);
                } else {
                    root.insertChildBefore(PalletProgramNodeContribution.getChildTreeNode(root, AtEach.class), (ProgramNode)separatorAction);
                }
                ((AbstractCustomProgramNodeContribution)separatorAction.getAs(SeparatorAction.class)).setParentContribution(this);
            }
            catch (TreeStructureException e) {
                Log.error((String)"Unable to create Separator Action", (Throwable)e);
            }
        } else {
            for (TreeNode child : root.getChildren()) {
                ProgramNode programNode = child.getProgramNode();
                if (!(programNode instanceof URCapProgramNode) || !((URCapProgramNode)programNode).canGetAs(SeparatorAction.class)) continue;
                PalletProgramNodeContribution.removeTreeNode(root, child);
            }
        }
        if ((layersNode = PalletProgramNodeContribution.getChildTreeNode(root, Layers.class)) != null) {
            Layers layers = (Layers)((URCapProgramNode)layersNode.getProgramNode()).getAs(Layers.class);
            layers.setSeparatorEnabled(isEnabled);
        }
        this.separatorChanged();
    }

    private void setSeparatorFeaturePosition(Position selectedPosition) {
        PalletProgramFeature separatorFeature = this.getSeparatorFeature();
        separatorFeature.setPosition(this.getPalletFeatureName(), selectedPosition.getToolPosition(), selectedPosition.getToolAxisAngle(), selectedPosition.getBaseToFeature());
    }

    @Override
    public Position getSeparator() {
        TreeNode patternsTreeNode = PalletProgramNodeContribution.getChildTreeNode(this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this), Patterns.class);
        if (patternsTreeNode != null) {
            Patterns patterns = (Patterns)((URCapProgramNode)patternsTreeNode.getProgramNode()).getAs(Patterns.class);
            return patterns.getSeparator();
        }
        return null;
    }

    @Override
    public void setSeparator(Position selectedPosition) {
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        TreeNode separatorTreeNode = PalletProgramNodeContribution.getChildTreeNode(rootTreeNode, SeparatorAction.class);
        if (separatorTreeNode != null) {
            this.setSeparatorFeaturePosition(selectedPosition);
            separatorTreeNode.setChildSequenceLocked(false);
            this.separatorChanged();
        }
    }

    @Override
    public boolean isPalletizing() {
        return this.model.get(KEY_IS_PALLETIZING, true);
    }

    private com.ur.urcap.api.domain.value.simple.Length getHeight() {
        return this.model.get(KEY_OBJECT_HEIGHT, (com.ur.urcap.api.domain.value.simple.Length)null);
    }

    private void setHeight(com.ur.urcap.api.domain.value.simple.Length h) {
        this.model.set(KEY_OBJECT_HEIGHT, h);
    }

    private double getMetricHeight() {
        com.ur.urcap.api.domain.value.simple.Length length = this.getHeight();
        return length == null ? 0.0 : length.getAs(Length.Unit.MM);
    }

    private void updateView() {
        this.view.setPalletNameLabel(this.getPalletName());
        this.view.setActionAfter(this.model.get(KEY_AFTER_SELECTED, false));
        this.view.setActionBefore(this.model.get(KEY_BEFORE_SELECTED, false));
        this.view.setObjectHeight((Length)this.getHeight());
        this.view.setDirectionPalletizing(this.model.get(KEY_IS_PALLETIZING, true));
        Collection features = this.palletFeatureService.getApplicablePalletFeatures();
        BaseFeature baseFeature = this.programAPI.getFeatureModel().getBaseFeature();
        String selectedFeature = this.getFeatureFromModel(baseFeature.getName());
        this.view.updateFeatureModel(features, selectedFeature);
        Variable countingVariable = this.model.get(KEY_COUNT_VARIABLE, (Variable)null);
        this.view.setCountingVariable(countingVariable != null ? countingVariable.getDisplayName() : "");
        this.view.setRememberTraversal(this.model.get(KEY_REMEMBER_TRAVERSAL, false));
        this.updateReferencePoint();
    }

    private void validateFeatureSelection() {
        double mountingTiltAngle;
        String feature = this.getFeatureFromModel("");
        if (this.programAPI.getFeatureModel().getBaseFeature().getName().equals(feature) && !EqualsUtil.equals((double)(mountingTiltAngle = this.palletFeatureService.getMountingTiltAngle()), (double)0.0, (double)1.0E-4)) {
            this.view.nonVerticalBaseSelected(mountingTiltAngle);
        }
    }

    private void buildSubNodes() {
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        ProgramNodeFactory programNodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
        URCapProgramNode patternsNode = programNodeFactory.createURCapProgramNode(PatternsNodeService.class);
        URCapProgramNode atEachNode = programNodeFactory.createURCapProgramNode(AtEachPositionNodeService.class);
        URCapProgramNode layersNode = programNodeFactory.createURCapProgramNode(LayersNodeService.class);
        try {
            rootTreeNode.addChild((ProgramNode)patternsNode);
            rootTreeNode.addChild((ProgramNode)layersNode);
            rootTreeNode.addChild((ProgramNode)atEachNode);
        }
        catch (TreeStructureException e) {
            Log.error((String)"Unable to insert Layers and At Each nodes", (Throwable)e);
        }
    }

    @Override
    public Patterns getPatterns() {
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        return PalletProgramNodeContribution.getTreeNodeAsClass(rootTreeNode, Patterns.class);
    }

    @Override
    public Layers getLayers() {
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        return PalletProgramNodeContribution.getTreeNodeAsClass(rootTreeNode, Layers.class);
    }

    private void createFeature(String name, String variableKey) {
        String uniqueName = this.palletNamingService.getUniqueFeatureName(name);
        PalletProgramFeature palletProgramFeature = this.palletFeatureService.createProgramFeature();
        palletProgramFeature.setName(uniqueName);
        this.palletFeatureService.addProgramFeature(palletProgramFeature);
        Variable fv = this.palletNamingService.getFeatureVariable(palletProgramFeature, this.programAPI.getVariableModel());
        this.model.set(variableKey, fv);
    }

    @Override
    public String getPalletFeatureName() {
        return this.getFeatureFromModel("");
    }

    void setDirectionPalletizing(boolean palletizing) {
        this.undoRedoManager.recordChanges(() -> {
            if (this.model.get(KEY_IS_PALLETIZING, true) != palletizing) {
                this.model.set(KEY_IS_PALLETIZING, palletizing);
                this.setItemsBeforeSeparator(palletizing);
                this.view.setDirectionPalletizing(palletizing);
            }
        });
        this.resetItemCounter();
    }

    @Override
    public Variable getCountVariable() {
        return this.model.get(KEY_COUNT_VARIABLE, (Variable)null);
    }

    @Override
    public Variable getReferencePointVariable() {
        return this.model.get(KEY_REFERENCE_POINT_VARIABLE, (Variable)null);
    }

    @Override
    public Variable getSeparatorPointVariable() {
        return this.model.get(KEY_SEPARATOR_POINT_VARIABLE, (Variable)null);
    }

    @Override
    public Variable getLayerNumberVariable() {
        return this.model.get(KEY_LAYERNO_VARIABLE, (Variable)null);
    }

    @Override
    public Variable getLayerCountVariable() {
        return this.model.get(KEY_LAYERCOUNT_VARIABLE, (Variable)null);
    }

    @Override
    public Variable getHandleSeparatorVariable() {
        return this.model.get(KEY_HANDLE_SEPARATOR_VARIABLE, (Variable)null);
    }

    @Override
    public Variable getQNearApproachVariable() {
        return this.model.get(Q_NEAR_NAME, (Variable)null);
    }

    private void checkAndCreateMissingQNearVariable() {
        if (!this.model.isSet(Q_NEAR_NAME)) {
            this.createQNearVariable();
        }
    }

    private void createQNearVariable() {
        try {
            Expression expr = this.programAPI.getValueFactoryProvider().createExpressionBuilder().append("[0,0,0,0,0,0]").build();
            GlobalVariable qNearVariable = this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(Q_NEAR_NAME, expr);
            this.model.set(Q_NEAR_NAME, (Variable)qNearVariable);
        }
        catch (VariableException e) {
            Log.error((String)"Unable to create non installation variable", (Throwable)e);
        }
        catch (InvalidExpressionException e) {
            Log.error((String)"Unable to create initial variable expression", (Throwable)e);
        }
    }

    private Variable getTotalCountVariable() {
        return this.model.get(KEY_TOTALCOUNT_VARIABLE, (Variable)null);
    }

    @Override
    public void patternChanged(Pattern pattern) {
        if (pattern.isDefined() && this.getLayers().isPatternUsed(pattern)) {
            this.resetItemCounter();
        }
    }

    @Override
    public int getStartItemCount() {
        if (!this.hasRememberTraversal()) {
            return 1;
        }
        String variableValue = this.palletNamingService.getInstallationVariableValue(this.getCountingVariableName());
        return variableValue == null ? 1 : Integer.parseInt(variableValue);
    }

    private void separatorChanged() {
        if (this.getLayers().isSeparatorUsed()) {
            this.resetItemCounter();
        }
    }

    public Icon getIcon(boolean isUndefined) {
        return isUndefined ? this.palletUndefined : this.palletDefined;
    }

    @Override
    public void loadComplete(ContributionLoadCompleteContext contributionLoadCompleteContext) {
        this.creating = false;
        super.loadComplete(contributionLoadCompleteContext);
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(true);
        Variable referencePointVariable = this.model.get(KEY_REFERENCE_POINT_VARIABLE, (Variable)null);
        String referencePointName = referencePointVariable.getDisplayName();
        Variable separatorPointVariable = this.model.get(KEY_SEPARATOR_POINT_VARIABLE, (Variable)null);
        String separatorPointName = separatorPointVariable.getDisplayName();
        SwingUtil.invokeAndWait(() -> this.undoRedoManager.recordChanges(() -> {
            this.createFeature(referencePointName, KEY_REFERENCE_POINT_VARIABLE);
            this.checkAndCreateMissingInstallationVariable();
            this.createFeature(separatorPointName, KEY_SEPARATOR_POINT_VARIABLE);
            this.checkAndCreateMissingQNearVariable();
        }));
        Position separator = this.getSeparator();
        if (separator != null && separator.isDefined()) {
            this.setSeparatorFeaturePosition(separator);
        }
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        if (this.isUnsuppressing()) {
            return;
        }
        this.creating = false;
        this.createFeature(KEY_REFERENCE_POINT_VARIABLE, KEY_REFERENCE_POINT_VARIABLE);
        this.createFeature(KEY_SEPARATOR_POINT_VARIABLE, KEY_SEPARATOR_POINT_VARIABLE);
        this.createQNearVariable();
        if (contributionInsertedContext.isCloning() || !this.getPalletName().isEmpty()) {
            this.insertAsAClone(contributionInsertedContext);
        } else {
            this.initializeGlobalVariables();
            if (!this.isChildrenCreated()) {
                this.buildSubNodes();
            }
            this.setFeatureOnModel(BASE);
            this.model.set(KEY_IS_PALLETIZING, true);
            super.onInserted(contributionInsertedContext);
        }
        this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(true);
    }

    private void insertAsAClone(ContributionInsertedContext contributionInsertedContext) {
        super.onInserted(contributionInsertedContext);
        this.createPalletNameVariable(this.getPalletName());
        this.setVariablesToPreviousNames();
        Position separatorPosition = this.getSeparator();
        if (separatorPosition != null && separatorPosition.isDefined()) {
            this.setSeparatorFeaturePosition(separatorPosition);
        }
        this.callOnInsertedOnChildren(contributionInsertedContext);
    }

    private void callOnInsertedOnChildren(ContributionInsertedContext contributionInsertedContext) {
        this.getProgramNodeContributionChildren().forEach(child -> child.onInserted(contributionInsertedContext));
    }

    private void setVariablesToPreviousNames() {
        this.createCountingVariableWithName(this.getCountingVariableName());
        this.createLayerCountVariable(this.getLayerCountVariable().getDisplayName());
        this.createLayerNumberVariable(this.getLayerNumberVariable().getDisplayName());
        this.createHandleSeperatorVariable(this.getHandleSeparatorVariable().getDisplayName());
        this.createTotalCountVariable(this.getTotalCountVariable().getDisplayName());
    }

    private GlobalVariable createPalletNameVariable(String name) {
        try {
            GlobalVariable palletNameVariable = this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(name);
            this.model.set(KEY_NAME, (Variable)palletNameVariable);
            return palletNameVariable;
        }
        catch (VariableException e) {
            Log.error((String)"Unable to create variables", (Throwable)e);
            return null;
        }
    }

    private void createLayerCountVariable(String name) {
        Variable variable = this.createNonInstallationVariable(name);
        this.model.set(KEY_LAYERCOUNT_VARIABLE, variable);
    }

    private void createLayerNumberVariable(String name) {
        Variable variable = this.createNonInstallationVariable(name);
        this.model.set(KEY_LAYERNO_VARIABLE, variable);
    }

    private void createHandleSeperatorVariable(String name) {
        Variable variable = this.createNonInstallationVariable(name, "False");
        this.model.set(KEY_HANDLE_SEPARATOR_VARIABLE, variable);
    }

    private void createTotalCountVariable(String name) {
        Variable variable = this.createNonInstallationVariable(name);
        this.model.set(KEY_TOTALCOUNT_VARIABLE, variable);
    }

    private boolean isUnsuppressing() {
        return !this.creating && this.isGeomFeatureRegistered();
    }

    private boolean isGeomFeatureRegistered() {
        Variable referencePointVariable = this.model.get(KEY_REFERENCE_POINT_VARIABLE, (Variable)null);
        return this.palletFeatureService.getFeature(referencePointVariable) != null;
    }

    protected boolean isChildrenCreated() {
        return !this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).getChildren().isEmpty();
    }

    @Override
    public PalletProgramFeature getSeparatorFeature() {
        Variable separatorPointVariable = this.getSeparatorPointVariable();
        return this.palletFeatureService.getFeature(separatorPointVariable);
    }

    @Override
    public PalletProgramFeature getReferencePointFeature() {
        Variable referencePointVariable = this.getReferencePointVariable();
        return this.palletFeatureService.getFeature(referencePointVariable);
    }

    @Override
    public GeneratedMovement getGeneratedMovement() {
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        TreeNode atEachNode = PalletProgramNodeContribution.getChildTreeNode(rootTreeNode, AtEach.class);
        return PalletProgramNodeContribution.getTreeNodeAsClass(atEachNode, GeneratedMovement.class);
    }

    @Override
    public String getComputePalletWaypointFunctionName() {
        return ScriptFunctions.getComputePalletWaypointFunctionName(this.getPalletName());
    }

    @Override
    public void updateReferencePoint() {
        if (PalletNewVersionToggle.isActive()) {
            TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
            AtEach atEach = PalletProgramNodeContribution.getTreeNodeAsClass(rootTreeNode, AtEach.class);
            if (atEach != null) {
                atEach.updateReferencePoint();
            }
            this.updateSeparatorPointFeature();
        }
    }

    private void updateSeparatorPointFeature() {
        TreeNode rootTreeNode;
        SeparatorAction separatorAction;
        if (this.getSeparator() == null) {
            return;
        }
        if (PalletNewVersionToggle.isActive() && (separatorAction = PalletProgramNodeContribution.getTreeNodeAsClass(rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this), SeparatorAction.class)) != null) {
            separatorAction.updateSeparatorPointFeature();
        }
    }

    private void setItemsBeforeSeparator(boolean itemsBeforeSeparator) {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        try {
            TreeNode sepChildTreeNode = PalletProgramNodeContribution.getChildTreeNode(root, SeparatorAction.class);
            if (sepChildTreeNode == null) {
                return;
            }
            ((SeparatorAction)((URCapProgramNode)sepChildTreeNode.getProgramNode()).getAs(SeparatorAction.class)).setMovingNodeInProgramTree(true);
            root.removeChild(sepChildTreeNode);
            sepChildTreeNode = itemsBeforeSeparator ? root.insertChildAfter(PalletProgramNodeContribution.getChildTreeNode(root, AtEach.class), sepChildTreeNode.getProgramNode()) : root.insertChildBefore(PalletProgramNodeContribution.getChildTreeNode(root, AtEach.class), sepChildTreeNode.getProgramNode());
            ((SeparatorAction)((URCapProgramNode)sepChildTreeNode.getProgramNode()).getAs(SeparatorAction.class)).setMovingNodeInProgramTree(false);
        }
        catch (TreeStructureException e) {
            Log.error((String)"Unable to create Separator Action", (Throwable)e);
        }
    }

    public boolean isUndefined() {
        if (!this.getLayers().isDefined()) {
            return true;
        }
        return this.getActualJointPositionVector() == null;
    }

    public JointPositionVector getActualJointPositionVector() {
        return this.getLayers().getActualJointPositionVector();
    }

    public PositionNodeType getPositionNodeType() {
        return PositionNodeType.FIXED;
    }

    public void onRemoved(ContributionRemovedContext contributionRemovedContext) {
        if (this.hasRememberTraversal()) {
            this.palletNamingService.removeInstallationVariable(this.getCountingVariableName());
        }
    }
}

