/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.pallet;

import com.ur.lang.EqualsUtil;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.i18n.impl.TextResourceImpl;
import com.ur.polyscope.pallet.impl.pallet.PalletProgramNodeContribution;
import com.ur.polyscope.pallet.impl.service.InternalPalletUIService;
import com.ur.polyscope.pallet.impl.util.AllowNullOrEmpty;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.BindingRegistration;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.HorizontalLayout;

public class PalletProgramNodeView
implements SwingProgramNodeView<PalletProgramNodeContribution> {
    private static final Dimension LABEL_DIMENSION = new Dimension(225, 29);
    private static final Dimension ROW_DIMENSION = new Dimension(300, 29);
    private final TextResource textResource;
    private final InternalPalletUIService palletUIService;
    private JLabel countingVariable;
    private JCheckBox rememberCheckBox;
    private JComboBox<String> featureDropDown;
    NumberField objectHeightField;
    private JLabel palletVariable;
    private JCheckBox actionBefore;
    private JCheckBox actionAfter;
    private FeatureRenderingStrategy featureRenderingStrategy;
    private BindingRegistration toolTipBindingRegistration;
    private JRadioButton palletizingRadioButton;
    private JRadioButton dePalletizingRadioButton;
    private JLabel directionIllustration;
    private static final int ROW_HEIGHT = 29;

    PalletProgramNodeView(TextResource textResource, InternalPalletUIService palletUIService) {
        this.textResource = textResource;
        this.palletUIService = palletUIService;
    }

    public void buildUI(JPanel jPanel, ContributionProvider<PalletProgramNodeContribution> provider) {
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel description = new JLabel(this.textResource.palletDescription());
        description.setAlignmentX(0.0f);
        jPanel.add(description);
        jPanel.add(Box.createRigidArea(new Dimension(0, 0)));
        jPanel.add(this.createPalletizingAction(provider));
        jPanel.add(this.createSectionHeader(this.textResource.palletProperties()));
        jPanel.add(Box.createRigidArea(new Dimension(0, 0)));
        jPanel.add(this.createPropertiesPanel(provider));
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(this.createSectionHeader(this.textResource.palletActions()));
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.actionBefore = new JCheckBox(this.textResource.includeActionBeforePalletizing());
        this.actionBefore.addActionListener(e -> ((PalletProgramNodeContribution)provider.get()).setActionBeforeSelected(this.actionBefore.isSelected()));
        this.actionBefore.setName("PalletProgramNodeView.actionBefore");
        this.actionAfter = new JCheckBox(this.textResource.includeActionAfterPalletizing());
        this.actionAfter.addActionListener(e -> ((PalletProgramNodeContribution)provider.get()).setActionAfterSelected(this.actionAfter.isSelected()));
        this.actionAfter.setName("PalletProgramNodeView.actionAfter");
        jPanel.add(this.actionBefore);
        jPanel.add(this.actionAfter);
    }

    private JComponent createSectionHeader(String s) {
        JLabel result = new JLabel(s);
        result.setBackground(Color.LIGHT_GRAY);
        result.setOpaque(true);
        result.setBorder(new EmptyBorder(0, 10, 0, 0));
        return result;
    }

    private JPanel createPalletizingAction(ContributionProvider<PalletProgramNodeContribution> provider) {
        ButtonGroup directionButtonGroup = new ButtonGroup();
        this.palletizingRadioButton = new JRadioButton((Action)((Object)new Palletizing(provider, this.textResource)));
        this.dePalletizingRadioButton = new JRadioButton((Action)((Object)new DePalletizing(provider, this.textResource)));
        directionButtonGroup.add(this.palletizingRadioButton);
        directionButtonGroup.add(this.dePalletizingRadioButton);
        this.directionIllustration = new JLabel(PalletImageResource.palletizingSmall());
        this.directionIllustration.setAlignmentX(1.0f);
        Dimension directionIllustrationDimension = new Dimension(161, 124);
        this.setSizes(this.directionIllustration, directionIllustrationDimension);
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder(BorderFactory.createEmptyBorder());
        directionPanel.setLayout(new BoxLayout(directionPanel, 1));
        directionPanel.add(this.palletizingRadioButton);
        directionPanel.add(this.dePalletizingRadioButton);
        JPanel topSection = new JPanel();
        topSection.setLayout(new BoxLayout(topSection, 0));
        topSection.setBorder(new EmptyBorder(0, 0, 0, 0));
        topSection.setAlignmentX(0.0f);
        topSection.add(directionPanel);
        topSection.add(Box.createVerticalStrut(0));
        topSection.add(this.directionIllustration);
        return topSection;
    }

    private JPanel createPropertiesPanel(ContributionProvider<PalletProgramNodeContribution> provider) {
        Dimension fieldDimension = new Dimension(200, 29);
        Dimension countingDimension = new Dimension(165, 29);
        Dimension buttonDimension = new Dimension(35, 29);
        JPanel properties = this.setSizes(new JPanel(), new Dimension(465, 180));
        properties.setBorder(BorderFactory.createEmptyBorder());
        properties.setLayout(new GridLayout(5, 1));
        properties.add(this.createPropertyRow(this.textResource.palletName(), this.createPalletVariable(countingDimension), this.renamePalletButton(provider, buttonDimension)));
        properties.add(this.createPropertyRow(this.textResource.palletFeature(), this.createFeatureSelection(provider, fieldDimension)));
        properties.add(this.createPropertyRow(this.textResource.objectHeight(), this.createObjectHeight(provider)));
        properties.add(this.createPropertyRow(this.textResource.palletCountingVariable(), this.createCountingVariable(countingDimension), this.renameCountItem(provider, buttonDimension)));
        properties.add(this.rememberTraversalInstallationVariables(provider));
        JLabel illustration = this.setSizes(new JLabel(PalletImageResource.height()), new Dimension(200, 180));
        illustration.setAlignmentX(1.0f);
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createEmptyBorder());
        result.setLayout(new BoxLayout(result, 0));
        result.setAlignmentX(0.0f);
        result.add(properties);
        result.add(Box.createVerticalStrut(10));
        result.add(illustration);
        return result;
    }

    private JComponent createPalletVariable(Dimension countingDimension) {
        this.palletVariable = this.setSizes(new JLabel(), countingDimension);
        this.palletVariable.setName("PalletProgramNodeView.palletName");
        return this.palletVariable;
    }

    private JLabel createCountingVariable(Dimension countingDimension) {
        this.countingVariable = new JLabel();
        this.countingVariable.setName("PalletProgramNodeView.countingVariable");
        return this.setSizes(this.countingVariable, countingDimension);
    }

    private JCheckBox rememberTraversalInstallationVariables(ContributionProvider<PalletProgramNodeContribution> provider) {
        this.rememberCheckBox = new JCheckBox(this.textResource.rememberTraversal());
        this.rememberCheckBox.setName("PalletProgramNodeView.rememberTraversal");
        this.rememberCheckBox.addActionListener(actionEvent -> ((PalletProgramNodeContribution)provider.get()).setRememberTraversal(this.rememberCheckBox.isSelected()));
        this.rememberCheckBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        return this.rememberCheckBox;
    }

    private JButton renameCountItem(ContributionProvider<PalletProgramNodeContribution> provider, Dimension buttonDimension) {
        JButton renameCounterButton = this.setSizes(new JButton(PalletImageResource.rename()), buttonDimension);
        renameCounterButton.setName("renameCounter.PalletProgramNodeView");
        renameCounterButton.addActionListener(actionEvent -> {
            KeyboardTextInput keyboard = ((PalletProgramNodeContribution)provider.get()).getCounterNameKeyboard();
            keyboard.show(renameCounterButton, ((PalletProgramNodeContribution)provider.get()).getCounterNameCallback());
        });
        return renameCounterButton;
    }

    private JComponent createFeatureSelection(ContributionProvider<PalletProgramNodeContribution> provider, Dimension fieldDimension) {
        this.featureDropDown = this.setSizes(new JComboBox(), fieldDimension);
        this.featureDropDown.setName("PalletProgramNodeView.feature");
        this.featureDropDown.addActionListener(actionEvent -> {
            if (this.toolTipBindingRegistration != null) {
                this.toolTipBindingRegistration.removeRegistration();
            }
            ((PalletProgramNodeContribution)provider.get()).setFeature((String)this.featureDropDown.getSelectedItem());
        });
        this.featureRenderingStrategy = new FeatureRenderingStrategy();
        ComboBoxRenderer.bindRenderer(this.featureDropDown, (RenderingStrategy)this.featureRenderingStrategy);
        return this.featureDropDown;
    }

    private JComponent createObjectHeight(final ContributionProvider<PalletProgramNodeContribution> provider) {
        this.objectHeightField = new NumberField(UnitsValueConverterFactory.getLengthConverter(), true);
        this.objectHeightField.setErrorValidationStrategy(new ValidationStrategy[]{new AllowNullOrEmpty(ValidationFactory.getRangeValidator((double)0.0, (double)1000000.0, (UnitsConverter)Units.getMmConverter()))});
        this.objectHeightField.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getCannotBeEmptyValidatorNoErrorMessage()});
        this.objectHeightField.addActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Length value = (Length)PalletProgramNodeView.this.objectHeightField.getValue();
                ((PalletProgramNodeContribution)provider.get()).setObjectHeight((com.ur.urcap.api.domain.value.simple.Length)value);
            }
        });
        return this.setSizes(this.objectHeightField, new Dimension(200, 29));
    }

    private JButton renamePalletButton(ContributionProvider<PalletProgramNodeContribution> provider, Dimension buttonDimension) {
        JButton renamePalletButton = new JButton(PalletImageResource.rename());
        renamePalletButton.setName("rename.PalletProgramNodeView");
        this.setSizes(renamePalletButton, buttonDimension);
        renamePalletButton.addActionListener(actionEvent -> {
            KeyboardTextInput keyboard = ((PalletProgramNodeContribution)provider.get()).getPalletNameKeyboard();
            keyboard.show(renamePalletButton, ((PalletProgramNodeContribution)provider.get()).getPalletNameCallback());
        });
        return renamePalletButton;
    }

    private JPanel createPropertyRow(String labelText, JComponent ... components) {
        JPanel result = this.createRow(ROW_DIMENSION);
        result.add(this.setSizes(new JLabel(labelText), LABEL_DIMENSION));
        for (JComponent each : components) {
            result.add(each);
            each.setFocusable(false);
        }
        return result;
    }

    private JPanel createRow(Dimension rowDimension) {
        JPanel row = new JPanel((LayoutManager)new HorizontalLayout(0));
        row.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        row.setAlignmentX(0.0f);
        return this.setSizes(row, rowDimension);
    }

    private <T extends JComponent> T setSizes(T component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
        return component;
    }

    void setCountingVariable(String name) {
        this.countingVariable.setText(name);
    }

    void setRememberTraversal(boolean selected) {
        this.rememberCheckBox.setSelected(selected);
    }

    void setActionBefore(boolean actionBefore) {
        this.actionBefore.setSelected(actionBefore);
    }

    void setActionAfter(boolean actionAfter) {
        this.actionAfter.setSelected(actionAfter);
    }

    void setPalletNameLabel(String name) {
        this.palletVariable.setText(name);
    }

    void setObjectHeight(Length height) {
        if (height != null) {
            this.objectHeightField.setValue((Object)height);
        } else {
            this.objectHeightField.setText("");
        }
    }

    void updateFeatureModel(Collection<Feature> features, String selectedFeature) {
        List<String> featureNames = features.stream().map(Feature::getName).collect(Collectors.toList());
        this.featureRenderingStrategy.setFeatures(featureNames);
        String[] featureModel = featureNames.toArray(new String[0]);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(featureModel);
        model.setSelectedItem(selectedFeature);
        this.featureDropDown.setModel(model);
    }

    void nonVerticalBaseSelected(double mountingTiltAngle) {
        SwingUtilities.invokeLater(() -> {
            String message = EqualsUtil.equals((double)mountingTiltAngle, (double)Math.PI, (double)1.0E-4) ? this.textResource.basePalletizingReversed() : this.textResource.basePalletizingNotVertical();
            this.toolTipBindingRegistration = this.palletUIService.showTooltip(this.featureDropDown, message);
        });
    }

    void close() {
        if (this.toolTipBindingRegistration != null) {
            this.toolTipBindingRegistration.removeRegistration();
        }
    }

    void setDirectionPalletizing(boolean directionPalletizing) {
        this.palletizingRadioButton.setSelected(directionPalletizing);
        this.dePalletizingRadioButton.setSelected(!directionPalletizing);
        this.directionIllustration.setIcon(directionPalletizing ? PalletImageResource.palletizingSmall() : PalletImageResource.dePalletizingSmall());
    }

    protected static class DePalletizing
    extends AbstractActionDefinition {
        private final ContributionProvider<PalletProgramNodeContribution> provider;

        DePalletizing(ContributionProvider<PalletProgramNodeContribution> provider, TextResource text) {
            this.provider = provider;
            this.putValue("Name", text.depalletizing());
        }

        public void actionPerformed(ActionEvent e) {
            ((PalletProgramNodeContribution)this.provider.get()).setDirectionPalletizing(false);
        }
    }

    protected static class Palletizing
    extends AbstractActionDefinition {
        private final ContributionProvider<PalletProgramNodeContribution> provider;

        Palletizing(ContributionProvider<PalletProgramNodeContribution> provider, TextResource text) {
            this.provider = provider;
            if (FeatureToggle.isActive((String)"englishProgramming")) {
                text = ((TextResourceImpl)text).getDefaultLocale();
            }
            this.putValue("Name", text.palletizing());
        }

        public void actionPerformed(ActionEvent e) {
            ((PalletProgramNodeContribution)this.provider.get()).setDirectionPalletizing(true);
        }
    }

    private static class FeatureRenderingStrategy
    implements RenderingStrategy {
        private Collection<String> features = new ArrayList<String>();

        FeatureRenderingStrategy() {
        }

        void setFeatures(Collection<String> features) {
            this.features = features;
        }

        public String getText(Object o) {
            return o == null ? "" : (String)o;
        }

        public Icon getIcon(Object o) {
            return null;
        }

        public boolean hasError(Object o) {
            String feature = (String)o;
            return !this.features.contains(feature);
        }
    }
}

