/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.pallet;

import com.ur.urcap.api.domain.script.ScriptWriter;

public class ScriptFunctions {
    private static final String TRANSLATION_NAME_POSTFIX = "trans";
    private static final String ROTATION_NAME_POSTFIX = "rot";
    private static final String CPW_NAME_POSTFIX = "compute_pallet_waypoint";

    private static void generateTranslationFunction(ScriptWriter writer, String palletName) {
        ScriptFunctions.functionWithParameters(writer, ScriptFunctions.getTranslationFunctionName(palletName), "pose");
        writer.appendLine("return p[pose[0], pose[1], pose[2], 0, 0, 0]");
        writer.end();
    }

    private static String getTranslationFunctionName(String palletName) {
        return palletName + "_" + TRANSLATION_NAME_POSTFIX;
    }

    private static void generateRotationFunction(ScriptWriter writer, String palletName) {
        ScriptFunctions.functionWithParameters(writer, ScriptFunctions.getRotationFunctionName(palletName), "pose");
        writer.appendLine("return p[0, 0, 0, pose[3], pose[4], pose[5]]");
        writer.end();
    }

    private static String getRotationFunctionName(String palletName) {
        return palletName + "_" + ROTATION_NAME_POSTFIX;
    }

    static void generateComputePalletWaypointFunction(ScriptWriter writer, String palletName) {
        ScriptFunctions.generateTranslationFunction(writer, palletName);
        ScriptFunctions.generateRotationFunction(writer, palletName);
        String rot = ScriptFunctions.getRotationFunctionName(palletName);
        String trans = ScriptFunctions.getTranslationFunctionName(palletName);
        ScriptFunctions.functionWithParameters(writer, ScriptFunctions.getComputePalletWaypointFunctionName(palletName), "T_base_feature_taught, T_feature_referencePoint_taught, T_referencePoint_approach_taught, T_base_feature, T_base_referencePoint");
        writer.appendLine("local trans_referencePoint_approach_in_feature_taught = pose_sub(" + trans + "(pose_trans(T_feature_referencePoint_taught, T_referencePoint_approach_taught)), " + trans + "(T_feature_referencePoint_taught))");
        writer.appendLine("local rot_referencePoint_approach_in_feature_taught = pose_trans(" + rot + "(T_feature_referencePoint_taught), pose_trans(" + rot + "(T_referencePoint_approach_taught), pose_inv(" + rot + "(T_feature_referencePoint_taught))))");
        writer.appendLine("T_feature_referencePoint = pose_trans(pose_inv(T_base_feature), T_base_referencePoint)");
        writer.appendLine("rot_referencePoint_approach = pose_trans(pose_inv(" + rot + "(T_feature_referencePoint)), pose_trans(rot_referencePoint_approach_in_feature_taught, " + rot + "(T_feature_referencePoint)))");
        writer.appendLine("T_feature_approach = pose_trans(trans_referencePoint_approach_in_feature_taught, pose_trans(T_feature_referencePoint, rot_referencePoint_approach))");
        writer.appendLine("T_base_approach = pose_trans(T_base_feature, T_feature_approach)");
        writer.appendLine("return T_base_approach");
        writer.end();
    }

    static String getComputePalletWaypointFunctionName(String palletName) {
        return palletName + "_" + CPW_NAME_POSTFIX;
    }

    private static void functionWithParameters(ScriptWriter writer, String name, String args) {
        writer.appendLine("def " + name + "(" + args + "):");
    }
}

