/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.pattern;

import com.ur.polyscope.pallet.impl.position.Position;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PatternPositions {
    private PatternPositions() {
    }

    static Set<Vector3d> getIrregularPositionsAsVector3dSet(Map<Integer, Position> teachedPositions) {
        HashSet<Vector3d> vector3ds = new HashSet<Vector3d>();
        for (Position pos : teachedPositions.values()) {
            Point3d toolPosition = pos.getActualToolPosition();
            vector3ds.add(new Vector3d((Tuple3d)toolPosition));
        }
        return vector3ds;
    }

    static Set<Vector3d> getLinePositionsAsVector3dSet(Map<Integer, Position> teachedPositions, int count) {
        HashSet<Vector3d> vector3ds = new HashSet<Vector3d>();
        Point3d p3d1 = teachedPositions.get(0).getActualToolPosition();
        Point3d p3d2 = teachedPositions.get(1).getActualToolPosition();
        for (int i = 0; i < count; ++i) {
            vector3ds.add(new Vector3d(p3d1.x + (p3d2.x - p3d1.x) * (double)i / (double)(count - 1), p3d1.y + (p3d2.y - p3d1.y) * (double)i / (double)(count - 1), p3d1.z + (p3d2.z - p3d1.z) * (double)i / (double)(count - 1)));
        }
        return vector3ds;
    }

    static Set<Vector3d> getGridPositionsAsVector3dSet(Map<Integer, Position> teachedPositions, int xCount, int yCount) {
        HashSet<Vector3d> vector3ds = new HashSet<Vector3d>();
        Position p1 = teachedPositions.get(0);
        Position p2 = teachedPositions.get(1);
        Position p3 = teachedPositions.get(2);
        Position p4 = teachedPositions.get(3);
        for (int j = 0; j < xCount; ++j) {
            for (int i = 0; i < yCount; ++i) {
                Vector3d v11 = new Vector3d((Tuple3d)p1.getActualToolPosition());
                Vector3d v21 = new Vector3d((Tuple3d)p2.getActualToolPosition());
                Vector3d v12 = new Vector3d((Tuple3d)p4.getActualToolPosition());
                Vector3d v22 = new Vector3d((Tuple3d)p3.getActualToolPosition());
                double yfrac = (double)i / (double)(yCount - 1);
                double xfrac = (double)j / (double)(xCount - 1);
                v21.sub((Tuple3d)v11);
                v21.scale(yfrac);
                v21.add((Tuple3d)v11);
                v22.sub((Tuple3d)v12);
                v22.scale(yfrac);
                v22.add((Tuple3d)v12);
                v22.sub((Tuple3d)v21);
                v22.scale(xfrac);
                v22.add((Tuple3d)v21);
                vector3ds.add(v22);
            }
        }
        return vector3ds;
    }
}

