/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.pattern;

import com.ur.monitor.model.JointPositionVector;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.NamedUUID;
import com.ur.pallet.common.model.PatternType;
import com.ur.polyscope.pallet.PalletNamingService;
import com.ur.polyscope.pallet.impl.pallet.PalletNewVersionToggle;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.pattern.PatternPositions;
import com.ur.polyscope.pallet.impl.pattern.PatternProgramNodeView;
import com.ur.polyscope.pallet.impl.patterns.Patterns;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.position.PositionNodeService;
import com.ur.polyscope.pallet.impl.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.pallet.impl.validators.OrValidator;
import com.ur.polyscope.pallet.impl.validators.VariableNameCompositeValidator;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionLoadCompleteContext;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.variable.GlobalVariable;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.vecmath.Vector3d;

public class PatternProgramNodeContribution
extends AbstractCustomProgramNodeContribution
implements Pattern,
IconContribution {
    public static final String GRID_NAME = "Grid";
    public static final String IRREG_NAME = "Irreg";
    public static final String LINE_NAME = "Line";
    public static final String NO_TYPE_NAME = "No_Type";
    private static final String KEY_NAME = "nameVariable";
    private static final String KEY_ROWS = "rows";
    private static final int INITIAL_ROW_COUNT = 4;
    private static final String KEY_OBJECTS = "objects";
    private static final int INITIAL_OBJECT_COUNT = 3;
    private static final String KEY_COLUMNS = "columns";
    private static final int INITIAL_COLUMN_COUNT = 3;
    private static final String KEY_PATTERN_TYPE = "patternType";
    private static final String KEY_UUID = "UUID";
    private static final String PATTERN_NAME = "Pattern";
    private final ProgramAPI programAPI;
    private final UndoRedoManager undoRedoManager;
    private final KeyboardInputFactory keyboardFactory;
    private final TextResource textResource;
    private final PatternProgramNodeView view;
    private final DataModel model;
    private final PalletNamingService palletNamingService;
    private TreeNode cachedRootNode = null;
    private final Icon patternUndefined;
    private final Icon patternDefined;

    PatternProgramNodeContribution(ProgramAPIProvider apiProvider, TextResource textResource, PatternProgramNodeView view, DataModel model, PalletNamingService palletNamingService) {
        this.programAPI = apiProvider.getProgramAPI();
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.keyboardFactory = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.textResource = textResource;
        this.view = view;
        this.model = model;
        this.palletNamingService = palletNamingService;
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(true);
        if (model.get(KEY_UUID, "").equals("")) {
            this.createUUID();
        }
        this.patternUndefined = PalletImageResource.patternUndefined();
        this.patternDefined = PalletImageResource.patternDefined();
    }

    private void createUUID() {
        this.model.set(KEY_UUID, UUID.randomUUID().toString());
    }

    @Override
    public Patterns getPatterns() {
        return (Patterns)this.getParentContribution();
    }

    public void openView() {
        this.view.setPatternName(this.getTitle());
        this.updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.getName();
    }

    @Override
    protected List<AbstractCustomProgramNodeContribution> getProgramNodeContributionChildren() {
        ArrayList<AbstractCustomProgramNodeContribution> result = new ArrayList<AbstractCustomProgramNodeContribution>();
        List<Position> positions = this.getPositions();
        positions.forEach(position -> result.add((AbstractCustomProgramNodeContribution)((Object)position)));
        return result;
    }

    @Override
    public boolean isDefined() {
        boolean defined = false;
        PatternType patternType = this.getPatternType();
        if (patternType != null) {
            switch (patternType) {
                case LINE: {
                    int objects = this.getObjects();
                    defined = objects > 0;
                    break;
                }
                case GRID: {
                    int rows = this.getRows();
                    int columns = this.getColumns();
                    defined = rows >= 1 && columns >= 1;
                    break;
                }
                case IRREGULAR: {
                    defined = true;
                    break;
                }
            }
        }
        return defined;
    }

    @Override
    public void duplicate(Pattern finalPatternToDuplicate) {
        this.model.set(KEY_PATTERN_TYPE, finalPatternToDuplicate.getPatternType().name());
        this.model.set(KEY_COLUMNS, finalPatternToDuplicate.getColumns());
        this.model.set(KEY_ROWS, finalPatternToDuplicate.getRows());
        this.model.set(KEY_OBJECTS, finalPatternToDuplicate.getObjects());
        this.model.set(KEY_NAME, this.createPatternNameVariable(finalPatternToDuplicate.getName()));
        ProgramNodeFactory programNodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        for (Position position : finalPatternToDuplicate.getPositions()) {
            Position newPosition = this.createPosition(programNodeFactory, rootTreeNode);
            if (newPosition == null) continue;
            newPosition.duplicate(position);
        }
    }

    public Icon getIcon(boolean isUndefined) {
        return isUndefined ? this.patternUndefined : this.patternDefined;
    }

    public void generateScript(ScriptWriter writer) {
    }

    @Override
    public void doGenerateScript(ScriptWriter writer, String layerCountVariableScriptName, String countVariableScriptName, String referencePointName, String qNearApproachName) {
        Map<Integer, Variable> teachedPositionVariables = this.getAllPositionVariables();
        Map<Integer, Position> teachedPositions = this.getAllPositions();
        Collection<Position> values = this.getAllPositions().values();
        for (Position p : values) {
            p.doGenerateScript(writer);
        }
        String s = this.model.get(KEY_PATTERN_TYPE, "");
        PatternType patternType = PatternType.valueOf((String)s);
        int totalPointsCount = 0;
        String localCount = "(" + layerCountVariableScriptName + " - 1)";
        switch (patternType) {
            case GRID: {
                String countVariableScriptNameX = countVariableScriptName + "_x";
                String countVariableScriptNameY = countVariableScriptName + "_y";
                int yCount = this.getColumns();
                int xCount = this.getRows();
                writer.assign(countVariableScriptNameX, localCount + " % " + xCount);
                writer.assign(countVariableScriptNameY, "floor(" + localCount + " / " + xCount + ")");
                String wp0 = writer.getResolvedVariableName(teachedPositionVariables.get(0));
                String wp1 = writer.getResolvedVariableName(teachedPositionVariables.get(1));
                String wp2 = writer.getResolvedVariableName(teachedPositionVariables.get(2));
                String wp3 = writer.getResolvedVariableName(teachedPositionVariables.get(3));
                writer.assign(referencePointName, "interpolate_pose(interpolate_pose(" + wp0 + ", " + wp1 + ", " + countVariableScriptNameX + "/" + (xCount - 1) + "), interpolate_pose(" + wp3 + ", " + wp2 + "," + countVariableScriptNameX + "/" + (xCount - 1) + "), " + countVariableScriptNameY + "/" + (yCount - 1) + ")");
                JointPositionVector qNearGrid0 = this.getJointPosition(teachedPositions.get(0));
                JointPositionVector qNearGrid1 = this.getJointPosition(teachedPositions.get(1));
                JointPositionVector qNearGrid2 = this.getJointPosition(teachedPositions.get(2));
                JointPositionVector qNearGrid3 = this.getJointPosition(teachedPositions.get(3));
                writer.ifCondition(countVariableScriptNameX + " < " + (double)xCount / 2.0);
                writer.ifCondition(countVariableScriptNameY + " < " + (double)yCount / 2.0);
                writer.assign(qNearApproachName, qNearGrid0.toString());
                writer.elseCondition();
                writer.assign(qNearApproachName, qNearGrid3.toString());
                writer.end();
                writer.elseCondition();
                writer.ifCondition(countVariableScriptNameY + " < " + (double)yCount / 2.0);
                writer.assign(qNearApproachName, qNearGrid1.toString());
                writer.elseCondition();
                writer.assign(qNearApproachName, qNearGrid2.toString());
                writer.end();
                writer.end();
                break;
            }
            case IRREGULAR: {
                totalPointsCount = teachedPositionVariables.size();
                for (int i = 0; i < totalPointsCount; ++i) {
                    if (i == 0) {
                        writer.ifCondition(localCount + " == 0");
                    } else {
                        writer.elseIfCondition(localCount + " == " + i);
                    }
                    String wp = writer.getResolvedVariableName(teachedPositionVariables.get(i));
                    writer.assign(referencePointName, wp);
                    JointPositionVector qNearIrregular = this.getJointPosition(teachedPositions.get(i));
                    writer.assign(qNearApproachName, qNearIrregular.toString());
                }
                if (totalPointsCount <= 0) break;
                writer.end();
                break;
            }
            case LINE: {
                totalPointsCount = this.getObjects();
                String wp0 = writer.getResolvedVariableName(teachedPositionVariables.get(0));
                String wp1 = writer.getResolvedVariableName(teachedPositionVariables.get(1));
                writer.assign(referencePointName, "interpolate_pose(" + wp0 + ", " + wp1 + ", " + localCount + "/" + (totalPointsCount - 1) + ")");
                JointPositionVector qNearLine0 = this.getJointPosition(teachedPositions.get(0));
                JointPositionVector qNearLine1 = this.getJointPosition(teachedPositions.get(1));
                writer.ifCondition(localCount + " < " + (double)totalPointsCount / 2.0);
                writer.assign(qNearApproachName, qNearLine0.toString());
                writer.elseCondition();
                writer.assign(qNearApproachName, qNearLine1.toString());
                writer.end();
                break;
            }
        }
    }

    private JointPositionVector getJointPosition(Position position) {
        if (PalletNewVersionToggle.isActive()) {
            return TypeConversion.getPolyScopeJPV(position.getJointPositions());
        }
        return position.getActualJointPositions();
    }

    private Map<Integer, Variable> getAllPositionVariables() {
        HashMap<Integer, Variable> positionVariables = new HashMap<Integer, Variable>();
        Map<Integer, Position> positions = this.getAllPositions();
        for (int i = 0; i < positions.size(); ++i) {
            positionVariables.put(i, positions.get(i).getVariable());
        }
        return positionVariables;
    }

    private Map<Integer, Position> getAllPositions() {
        final HashMap<Integer, Position> positions = new HashMap<Integer, Position>();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.traverse(new ProgramNodeVisitor(){

            public void visit(URCapProgramNode programNode, int index, int depth) {
                if (programNode.canGetAs(Position.class)) {
                    Position position = (Position)programNode.getAs(Position.class);
                    positions.put(index, position);
                }
            }
        });
        return positions;
    }

    @Override
    public PatternType getPatternType() {
        String patternString = this.model.get(KEY_PATTERN_TYPE, "");
        if (!patternString.isEmpty()) {
            return PatternType.valueOf((String)patternString);
        }
        return null;
    }

    @Override
    public void setPatternType(PatternType patternType) {
        this.model.set(KEY_PATTERN_TYPE, patternType.name());
        switch (patternType) {
            case LINE: {
                this.setObjects(3);
                break;
            }
            case GRID: {
                this.setRows(4);
                this.setColums(3);
                break;
            }
            case IRREGULAR: {
                break;
            }
        }
        this.model.set(KEY_NAME, this.createPatternNameVariable());
        this.updateView();
        this.undoRedoManager.recordChanges(() -> this.createChildren(patternType));
    }

    @Override
    public List<Position> getPositions() {
        ArrayList<Position> positions = new ArrayList<Position>();
        if (this.cachedRootNode == null) {
            this.cachedRootNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        }
        for (TreeNode child : this.cachedRootNode.getChildren()) {
            URCapProgramNode programNode = (URCapProgramNode)child.getProgramNode();
            if (!programNode.canGetAs(Position.class)) continue;
            positions.add((Position)programNode.getAs(Position.class));
        }
        return positions;
    }

    @Override
    public void deletePosition(NamedUUID item) {
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        List<TreeNode> treeNodes = rootTreeNode.getChildren().stream().filter(node -> ((Position)((URCapProgramNode)node.getProgramNode()).getAs(Position.class)).getUUID().equals(item.getUUID())).collect(Collectors.toList());
        treeNodes.forEach(treeNode -> this.undoRedoManager.recordChanges(() -> {
            try {
                Pattern firstLayerPattern = this.getPatterns().getPallet().getLayers().getFirstLayerPattern();
                boolean updateReferencePoint = false;
                if (firstLayerPattern != null && firstLayerPattern.getUUID().equals(this.getUUID()) && PatternType.IRREGULAR == this.getPatternType()) {
                    updateReferencePoint = !firstLayerPattern.getPositions().isEmpty() && firstLayerPattern.getPositions().get(0).getUUID().equals(item.getUUID()) && firstLayerPattern.getPositions().size() > 1;
                }
                rootTreeNode.removeChild(treeNode);
                if (updateReferencePoint) {
                    this.getPatterns().getPallet().updateReferencePoint();
                }
            }
            catch (TreeStructureException treeStructureException) {
                Log.error((String)"Unable to remove position", (Throwable)treeStructureException);
            }
        }));
    }

    @Override
    public int getPoints() {
        int result = 0;
        PatternType patternType = this.getPatternType();
        if (patternType != null) {
            switch (patternType) {
                case GRID: {
                    result = this.getRows() * this.getColumns();
                    break;
                }
                case LINE: {
                    result = this.getObjects();
                    break;
                }
                case IRREGULAR: {
                    result = this.getPositions().size();
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    void deletePattern() {
        this.getPatterns().deletePattern(this);
    }

    @Override
    public void loadComplete(ContributionLoadCompleteContext contributionLoadCompleteContext) {
        super.loadComplete(contributionLoadCompleteContext);
        if (!this.model.isSet(KEY_NAME)) {
            this.model.set(KEY_NAME, this.createPatternNameVariable());
        }
    }

    private Variable createPatternNameVariable(String suggestion) {
        GlobalVariable variable = null;
        try {
            variable = this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(suggestion);
        }
        catch (VariableException variableException) {
            Log.error((String)"Unable to create pattern name variable", (Throwable)variableException);
        }
        return variable;
    }

    private Variable createPatternNameVariable() {
        PatternType patternType = this.getPatternType();
        String typeName = "";
        switch (patternType) {
            case GRID: {
                typeName = GRID_NAME;
                break;
            }
            case IRREGULAR: {
                typeName = IRREG_NAME;
                break;
            }
            case LINE: {
                typeName = LINE_NAME;
                break;
            }
            default: {
                typeName = NO_TYPE_NAME;
            }
        }
        String name = typeName + "_" + PATTERN_NAME + "_1";
        return this.createPatternNameVariable(name);
    }

    private void createChildren(PatternType patternType) {
        ProgramNodeFactory programNodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(true);
        for (int i = 0; i < patternType.getNumInitialPositions(); ++i) {
            this.createPosition(programNodeFactory, rootTreeNode, patternType);
        }
    }

    private void createPosition(ProgramNodeFactory programNodeFactory, TreeNode rootTreeNode, PatternType patternType) {
        int itemIndex = rootTreeNode.getChildren().size();
        Position pos = this.createPosition(programNodeFactory, rootTreeNode);
        if (pos != null) {
            pos.initialize(patternType, itemIndex);
        }
    }

    private Position createPosition(ProgramNodeFactory programNodeFactory, TreeNode rootTreeNode) {
        URCapProgramNode positionNode = programNodeFactory.createURCapProgramNode(PositionNodeService.class);
        try {
            rootTreeNode.addChild((ProgramNode)positionNode);
            Position position = (Position)positionNode.getAs(Position.class);
            ((AbstractCustomProgramNodeContribution)((Object)position)).setParentContribution(this);
            return position;
        }
        catch (TreeStructureException treeStructureException) {
            Log.error((String)"Unable to create position", (Throwable)treeStructureException);
            return null;
        }
    }

    KeyboardNumberInput<Integer> getRowsKeyboard() {
        KeyboardNumberInput<Integer> keyboard = this.getKeyboardForDimensionsField(2, this.getRowsErrorMessage());
        int initialValue = 0;
        if (PatternType.GRID == this.getPatternType()) {
            initialValue = this.getRows();
        } else if (PatternType.LINE == this.getPatternType()) {
            initialValue = this.getObjects();
        }
        if (initialValue > 0) {
            keyboard.setInitialValue((Object)initialValue);
        }
        return keyboard;
    }

    KeyboardInputCallback<Integer> getRowsCallback() {
        return new KeyboardInputCallback<Integer>(){

            public void onOk(Integer integer) {
                PatternProgramNodeContribution.this.setRowsOrObjects(integer);
            }
        };
    }

    private String getRowsErrorMessage() {
        if (this.getPatternType() == PatternType.GRID) {
            return this.textResource.gridRowErrorMessage();
        }
        return this.textResource.lineObjectsErrorMessage();
    }

    KeyboardNumberInput<Integer> getColumnsKeyboard() {
        KeyboardNumberInput<Integer> keyboard = this.getKeyboardForDimensionsField(2, this.textResource.gridColumnsErrorMessage());
        int columns = this.getColumns();
        if (columns > 0) {
            keyboard.setInitialValue((Object)columns);
        }
        return keyboard;
    }

    KeyboardInputCallback<Integer> getColumnsCallback() {
        return new KeyboardInputCallback<Integer>(){

            public void onOk(Integer integer) {
                PatternProgramNodeContribution.this.setColums(integer);
            }
        };
    }

    void setRowsOrObjects(int rowsOrObjects) {
        PatternType patternType = this.getPatternType();
        if (patternType == PatternType.GRID) {
            this.setRows(rowsOrObjects);
        }
        if (patternType == PatternType.LINE) {
            this.setObjects(rowsOrObjects);
        }
        this.updateView();
    }

    void setColums(int colums) {
        this.updatePatternProperty(KEY_COLUMNS, colums);
        this.updateView();
    }

    private void updateView() {
        this.view.updateView(this.getPatternType(), this.getRows(), this.getColumns(), this.getObjects());
    }

    @Override
    public int getColumns() {
        return this.model.get(KEY_COLUMNS, 3);
    }

    @Override
    public int getRows() {
        return this.model.get(KEY_ROWS, 4);
    }

    private void setRows(int rows) {
        this.updatePatternProperty(KEY_ROWS, rows);
    }

    @Override
    public int getObjects() {
        return this.model.get(KEY_OBJECTS, 3);
    }

    private void setObjects(int objects) {
        this.updatePatternProperty(KEY_OBJECTS, objects);
    }

    private void updatePatternProperty(String KEY, int value) {
        if (!this.model.isSet(KEY) || this.model.get(KEY, 0) != value) {
            this.model.set(KEY, value);
            this.getPatterns().getPallet().patternChanged(this);
        }
    }

    private KeyboardNumberInput<Integer> getKeyboardForDimensionsField(final int minvalue, final String ErroMessage) {
        InputValidator<Integer> val = new InputValidator<Integer>(){

            public boolean isValid(Integer integer) {
                return integer >= minvalue;
            }

            public String getMessage(Integer integer) {
                return ErroMessage;
            }
        };
        KeyboardNumberInput positiveIntegerKeypadInput = this.keyboardFactory.createPositiveIntegerKeypadInput();
        positiveIntegerKeypadInput.setErrorValidator((InputValidator)val);
        return positiveIntegerKeypadInput;
    }

    public String getName() {
        Variable variable = this.model.get(KEY_NAME, (Variable)null);
        if (variable == null) {
            return "Patternplholder";
        }
        return variable.getDisplayName();
    }

    public void setName(String value) {
        if (value.equals(this.getName())) {
            return;
        }
        this.undoRedoManager.recordChanges(() -> this.model.set(KEY_NAME, this.createPatternNameVariable(value)));
        this.view.setPatternName(value);
    }

    public UUID getUUID() {
        return UUID.fromString(this.model.get(KEY_UUID, ""));
    }

    void addPosition() {
        this.undoRedoManager.recordChanges(() -> {
            ProgramNodeFactory programNodeFactory = this.programAPI.getProgramModel().getProgramNodeFactory();
            TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
            this.createPosition(programNodeFactory, rootTreeNode, this.getPatternType());
        });
    }

    @Override
    public Set<Vector3d> getPositionsAsVector3d() {
        Set<Vector3d> result;
        String s = this.model.get(KEY_PATTERN_TYPE, "");
        PatternType patternType = PatternType.valueOf((String)s);
        Map<Integer, Position> teachedPositions = this.getAllPositions();
        switch (patternType) {
            case IRREGULAR: {
                result = PatternPositions.getIrregularPositionsAsVector3dSet(teachedPositions);
                break;
            }
            case LINE: {
                result = PatternPositions.getLinePositionsAsVector3dSet(teachedPositions, this.getObjects());
                break;
            }
            case GRID: {
                int xCount = this.getColumns();
                int yCount = this.getRows();
                result = PatternPositions.getGridPositionsAsVector3dSet(teachedPositions, xCount, yCount);
                break;
            }
            default: {
                result = new HashSet<Vector3d>();
            }
        }
        return result;
    }

    void duplicatePatternSelected() {
        this.getPatterns().duplicatePattern(this.getUUID());
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        super.onInserted(contributionInsertedContext);
        if (contributionInsertedContext.isCloning()) {
            this.model.set(KEY_NAME, this.createPatternNameVariable(this.getName()));
            this.getProgramNodeContributionChildren().forEach(child -> child.onInserted(contributionInsertedContext));
        }
    }

    public KeyboardTextInput getPatternNameKeyboard() {
        KeyboardTextInput keyboard = this.keyboardFactory.createStringKeyboardInput();
        keyboard.setInitialValue(this.getName());
        keyboard.setErrorValidator((InputValidator)new PatternNameValidator());
        return keyboard;
    }

    public KeyboardInputCallback<String> getPatternNameCallback() {
        return new KeyboardInputCallback<String>(){

            public void onOk(String s) {
                PatternProgramNodeContribution.this.setName(s);
            }
        };
    }

    private class CurrentPatternNameValidator
    implements ValidationStrategy {
        private CurrentPatternNameValidator() {
        }

        public boolean isValid(String uncheckedString) {
            return uncheckedString.equals(PatternProgramNodeContribution.this.getName());
        }

        public String getErrorMessage(String uncheckedString) {
            return "";
        }
    }

    private class PatternNameValidator
    implements InputValidator<String> {
        private final ValidationStrategy validator;

        PatternNameValidator() {
            this.validator = new OrValidator((ValidationStrategy)new VariableNameCompositeValidator(PatternProgramNodeContribution.this.textResource, PatternProgramNodeContribution.this.palletNamingService), new CurrentPatternNameValidator());
        }

        public boolean isValid(String s) {
            return this.validator.isValid(s);
        }

        public String getMessage(String s) {
            return this.validator.getErrorMessage(s);
        }
    }
}

