/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.pattern;

import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.PatternType;
import com.ur.polyscope.pallet.impl.pattern.PatternProgramNodeContribution;
import com.ur.polyscope.pallet.impl.service.InternalPalletUIService;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PatternProgramNodeView
implements SwingProgramNodeView<PatternProgramNodeContribution> {
    private final TextResource textResource;
    private final InternalPalletUIService palletUIService;
    private JLabel patternNameLabel;
    private JTextField rowsField;
    private JTextField columnsField;
    private JLabel rowsLabel;
    private JPanel columnsRow;
    private JLabel illustration;
    private JButton addPosition;
    private JPanel dimensionsEditor;
    private JPanel dimensionsEmpty;
    private JLabel explanation;

    PatternProgramNodeView(TextResource textResource, InternalPalletUIService palletUIService) {
        this.textResource = textResource;
        this.palletUIService = palletUIService;
    }

    public void buildUI(JPanel jPanel, final ContributionProvider<PatternProgramNodeContribution> provider) {
        Dimension buttonDimension = new Dimension(35, 25);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.explanation = new JLabel();
        JPanel explPanel = new JPanel(new BorderLayout());
        this.setDimensions(explPanel, new Dimension(700, 100));
        explPanel.add((Component)this.explanation, "North");
        explPanel.add(new JLabel(this.textResource.positionTeachHelp()));
        jPanel.add(explPanel);
        JPanel main = new JPanel();
        this.setDimensions(main, new Dimension(600, 250));
        main.setLayout(new BoxLayout(main, 1));
        jPanel.add(main);
        this.patternNameLabel = new JLabel();
        this.patternNameLabel.setName("PatternProgramNodeView.patternName");
        this.patternNameLabel.setBorder(new EmptyBorder(0, 10, 0, 0));
        JButton renamePatternButton = new JButton();
        renamePatternButton.setIcon(PalletImageResource.rename());
        this.setSizes(renamePatternButton, buttonDimension);
        renamePatternButton.addActionListener(actionEvent -> {
            KeyboardTextInput keyboard = ((PatternProgramNodeContribution)provider.get()).getPatternNameKeyboard();
            keyboard.show(renamePatternButton, ((PatternProgramNodeContribution)provider.get()).getPatternNameCallback());
        });
        JButton deleteButton = new JButton();
        deleteButton.addActionListener(actionListner -> ((PatternProgramNodeContribution)provider.get()).deletePattern());
        deleteButton.setName("PatternProgramNodeView.deletePattern");
        deleteButton.setIcon(PalletImageResource.delete());
        deleteButton.setPreferredSize(new Dimension(32, 32));
        deleteButton.setMaximumSize(new Dimension(32, 32));
        JButton duplicatePatternButton = this.palletUIService.getWidgetFactory().createButton((Action)new AbstractActionDefinition(){

            public void actionPerformed(ActionEvent e) {
                ((PatternProgramNodeContribution)provider.get()).duplicatePatternSelected();
            }
        });
        duplicatePatternButton.setText(this.textResource.duplicate());
        JPanel firstRow = new JPanel();
        firstRow.setLayout(new BoxLayout(firstRow, 0));
        firstRow.add(renamePatternButton);
        firstRow.add(Box.createHorizontalStrut(5));
        firstRow.add(this.patternNameLabel);
        firstRow.add(Box.createHorizontalGlue());
        firstRow.add((Component)deleteButton, Float.valueOf(1.0f));
        firstRow.add(Box.createHorizontalStrut(5));
        firstRow.add((Component)duplicatePatternButton, Float.valueOf(1.0f));
        main.add(firstRow);
        JPanel dimensionsPanel = this.buildDimensionsPanel(provider);
        main.add(dimensionsPanel);
    }

    private void setSizes(JComponent featureBox, Dimension fieldDimension) {
        featureBox.setMaximumSize(fieldDimension);
        featureBox.setMinimumSize(fieldDimension);
        featureBox.setPreferredSize(fieldDimension);
    }

    void updateView(PatternType patternType, int rows, int columns, int objects) {
        switch (patternType) {
            case GRID: {
                this.rowsLabel.setText(this.textResource.rows());
                this.columnsRow.setVisible(true);
                if (rows > 0) {
                    this.rowsField.setText(Integer.toString(rows));
                } else {
                    this.rowsField.setText("");
                }
                if (columns > 0) {
                    this.columnsField.setText(Integer.toString(columns));
                }
                this.illustration.setIcon(PalletImageResource.rowsAndColums());
                this.addPosition.setVisible(false);
                this.dimensionsEditor.setVisible(true);
                this.dimensionsEmpty.setVisible(false);
                this.explanation.setText(this.textResource.patternTeachHelpGrid());
                break;
            }
            case LINE: {
                this.rowsLabel.setText(this.textResource.items());
                this.columnsRow.setVisible(false);
                if (objects > 0) {
                    this.rowsField.setText(Integer.toString(objects));
                } else {
                    this.rowsField.setText("");
                }
                this.illustration.setIcon(PalletImageResource.lineEndPoints());
                this.addPosition.setVisible(false);
                this.dimensionsEditor.setVisible(true);
                this.dimensionsEmpty.setVisible(false);
                this.explanation.setText(this.textResource.patternTeachHelpLine());
                break;
            }
            case IRREGULAR: {
                this.illustration.setIcon(PalletImageResource.irregular());
                this.addPosition.setVisible(true);
                this.dimensionsEditor.setVisible(false);
                this.dimensionsEmpty.setVisible(true);
                this.explanation.setText(this.textResource.patternTeachHelpIrregular());
                break;
            }
        }
    }

    private JPanel buildDimensionsPanel(final ContributionProvider<PatternProgramNodeContribution> provider) {
        int labelWidth = 130;
        int textFieldWidth = 100;
        int height = 25;
        this.addPosition = new JButton(this.textResource.addItem());
        Dimension addButtonDimension = new Dimension(225, 35);
        this.setSizes(this.addPosition, addButtonDimension);
        this.addPosition.addActionListener(actionEvent -> ((PatternProgramNodeContribution)provider.get()).addPosition());
        Dimension textFieldDimension = new Dimension(textFieldWidth, height);
        Dimension labelDimension = new Dimension(labelWidth, height);
        Dimension rowDimension = new Dimension(300, 50);
        EmptyBorder emptyBorder = new EmptyBorder(0, 10, 0, 0);
        LineBorder lineBorder = new LineBorder(Color.LIGHT_GRAY);
        CompoundBorder textFieldBorder = new CompoundBorder(emptyBorder, lineBorder);
        this.rowsLabel = new JLabel();
        this.setDimensions(this.rowsLabel, labelDimension);
        this.rowsField = this.createTextField(textFieldDimension, textFieldBorder, "PatternProgramNodeView.rows");
        this.rowsField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                KeyboardNumberInput<Integer> keyboard = ((PatternProgramNodeContribution)provider.get()).getRowsKeyboard();
                keyboard.show(PatternProgramNodeView.this.rowsField, ((PatternProgramNodeContribution)provider.get()).getRowsCallback());
            }
        });
        JPanel rowsRow = new JPanel();
        rowsRow.setLayout(new BoxLayout(rowsRow, 0));
        this.setDimensions(rowsRow, rowDimension);
        rowsRow.add(this.rowsLabel);
        rowsRow.add(Box.createHorizontalStrut(10));
        rowsRow.add(this.rowsField);
        rowsRow.add(Box.createHorizontalGlue());
        JLabel columnLabel = new JLabel(this.textResource.columns());
        this.setDimensions(columnLabel, labelDimension);
        this.columnsField = this.createTextField(textFieldDimension, textFieldBorder, "PatternProgramNodeView.columns");
        this.columnsField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                KeyboardNumberInput<Integer> keyboard = ((PatternProgramNodeContribution)provider.get()).getColumnsKeyboard();
                keyboard.show(PatternProgramNodeView.this.columnsField, ((PatternProgramNodeContribution)provider.get()).getColumnsCallback());
            }
        });
        this.columnsRow = new JPanel();
        this.columnsRow.setLayout(new BoxLayout(this.columnsRow, 0));
        this.setDimensions(this.columnsRow, rowDimension);
        this.columnsRow.add(columnLabel);
        this.columnsRow.add(Box.createHorizontalStrut(10));
        this.columnsRow.add(this.columnsField);
        this.columnsRow.add(Box.createHorizontalGlue());
        this.dimensionsEditor = new JPanel();
        this.dimensionsEditor.setLayout(new BoxLayout(this.dimensionsEditor, 1));
        this.dimensionsEditor.setAlignmentX(0.0f);
        this.dimensionsEditor.setAlignmentY(0.5f);
        this.dimensionsEditor.add(rowsRow);
        this.dimensionsEditor.add(this.columnsRow);
        this.dimensionsEmpty = new JPanel();
        this.setDimensions(this.dimensionsEmpty, new Dimension(310, 200));
        this.dimensionsEmpty.setLayout(new BoxLayout(this.dimensionsEmpty, 1));
        this.dimensionsEmpty.add(Box.createVerticalStrut(50));
        JPanel bp = new JPanel();
        bp.setLayout(new BoxLayout(bp, 0));
        bp.add(Box.createHorizontalStrut(50));
        bp.add(this.addPosition);
        bp.add(Box.createHorizontalGlue());
        this.dimensionsEmpty.add(bp);
        this.dimensionsEmpty.add(Box.createVerticalGlue());
        Dimension illustrationDimension = new Dimension(300, 200);
        this.illustration = new JLabel();
        this.setDimensions(this.illustration, illustrationDimension);
        Dimension panelSize = new Dimension(600, 200);
        JPanel dimensions = new JPanel();
        dimensions.setLayout(new BoxLayout(dimensions, 0));
        this.setDimensions(dimensions, panelSize);
        dimensions.add(this.dimensionsEditor);
        dimensions.add(this.dimensionsEmpty);
        dimensions.add(Box.createHorizontalGlue());
        dimensions.add(this.illustration);
        return dimensions;
    }

    private void setDimensions(JComponent component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
    }

    private JTextField createTextField(Dimension dimension, Border border, String name) {
        JTextField field = new JTextField();
        this.setDimensions(field, dimension);
        field.setBorder(border);
        field.setAlignmentX(0.0f);
        field.setName(name);
        return field;
    }

    void setPatternName(String title) {
        this.patternNameLabel.setText(title);
    }
}

