/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.patterns;

import com.ur.lang.EqualsUtil;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.PatternType;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.pallet.impl.pallet.Pallet;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.pattern.PatternNodeService;
import com.ur.polyscope.pallet.impl.patterns.Patterns;
import com.ur.polyscope.pallet.impl.patterns.PatternsProgramNodeView;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.position.PositionNodeService;
import com.ur.polyscope.pallet.impl.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.program.nodes.NonVisitable;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionLoadCompleteContext;
import com.ur.polyscope.valueobjects.Length;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.Icon;

public class PatternsProgramNodeContribution
extends AbstractCustomProgramNodeContribution
implements Patterns,
IconContribution,
NonVisitable {
    private static final String KEY_SEPARATOR = "separator";
    private static final String KEY_SEPARATOR_HEIGHT = "separatorHeight";
    private final ProgramAPI programAPI;
    private final UndoRedoManager undoRedoManager;
    private final TextResource textResource;
    private DataModel model;
    private final PatternsProgramNodeView view;
    private TreeNode cachedRootNode = null;

    PatternsProgramNodeContribution(ProgramAPIProvider apiProvider, TextResource textResource, DataModel model, PatternsProgramNodeView view) {
        this.programAPI = apiProvider.getProgramAPI();
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.textResource = textResource;
        this.model = model;
        this.view = view;
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(true);
    }

    public void openView() {
        this.updateView();
    }

    private void updateView() {
        this.view.updateView(this.isSeparatorChecked());
        this.view.setSeparatorHeight((Length)this.getHeight());
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.patterns();
    }

    @Override
    protected List<AbstractCustomProgramNodeContribution> getProgramNodeContributionChildren() {
        ArrayList<AbstractCustomProgramNodeContribution> result = new ArrayList<AbstractCustomProgramNodeContribution>();
        this.getAllPatterns().forEach(pattern -> result.add((AbstractCustomProgramNodeContribution)((Object)pattern)));
        Position separator = this.getSeparator();
        if (separator != null) {
            result.add((AbstractCustomProgramNodeContribution)((Object)separator));
        }
        return result;
    }

    public boolean isDefined() {
        double separatorHeight;
        return !this.isSeparatorChecked() || !EqualsUtil.equals((double)(separatorHeight = this.getMetricHeight()), (double)0.0, (double)1.0E-4);
    }

    @Override
    public Pallet getPallet() {
        return (Pallet)this.getParentContribution();
    }

    public void generateScript(ScriptWriter writer) {
        writer.writeChildren();
    }

    void lineSelected() {
        this.undoRedoManager.recordChanges(() -> this.createPattern(PatternType.LINE));
    }

    void gridSelected() {
        this.undoRedoManager.recordChanges(() -> this.createPattern(PatternType.GRID));
    }

    void irregularSelected() {
        this.undoRedoManager.recordChanges(() -> this.createPattern(PatternType.IRREGULAR));
    }

    void separatorToggled(boolean checked) {
        this.undoRedoManager.recordChanges(() -> {
            this.model.set(KEY_SEPARATOR, checked);
            if (checked) {
                this.createSeparatorPosition();
            } else {
                this.removeSeparatorPosition();
                PalletProgramFeature separatorFeature = this.getPallet().getSeparatorFeature();
                if (separatorFeature != null) {
                    separatorFeature.resetPosition();
                }
                this.view.setSeparatorHeight(null);
                this.model.remove(KEY_SEPARATOR_HEIGHT);
            }
            this.getPallet().setSeparatorsEnabled(checked);
        });
    }

    @Override
    public Position getSeparator() {
        final Position[] result = new Position[]{null};
        if (this.isSeparatorChecked()) {
            TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
            root.traverse(new ProgramNodeVisitor(){

                public void visit(URCapProgramNode programNode, int index, int depth) {
                    if (programNode.canGetAs(Position.class)) {
                        Position position;
                        result[0] = position = (Position)programNode.getAs(Position.class);
                    }
                }
            });
        }
        return result[0];
    }

    @Override
    public void duplicatePattern(UUID uuid) {
        Pattern patternToDuplicate = null;
        List<Pattern> patterns = this.getAllPatterns();
        for (Pattern pattern : patterns) {
            if (pattern.getUUID().compareTo(uuid) != 0) continue;
            patternToDuplicate = pattern;
            break;
        }
        if (patternToDuplicate == null) {
            Log.error((String)("Unable to duplicate pattern with ID " + uuid.toString()));
            return;
        }
        Pattern finalPatternToDuplicate = patternToDuplicate;
        this.undoRedoManager.recordChanges(() -> {
            Pattern pattern = this.createPattern();
            pattern.duplicate(finalPatternToDuplicate);
        });
    }

    private Pattern createPattern(PatternType patternType) {
        Pattern pattern = this.createPattern();
        pattern.setPatternType(patternType);
        return pattern;
    }

    private Pattern createPattern() {
        Pattern pattern = null;
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        URCapProgramNode urCapProgramNode = this.programAPI.getProgramModel().getProgramNodeFactory().createURCapProgramNode(PatternNodeService.class);
        try {
            rootTreeNode.addChild((ProgramNode)urCapProgramNode);
            pattern = (Pattern)urCapProgramNode.getAs(Pattern.class);
            ((AbstractCustomProgramNodeContribution)((Object)pattern)).setParentContribution(this);
            Optional<TreeNode> separator = this.findSeparator();
            if (separator.isPresent()) {
                TreeNode separatorNode = separator.get();
                rootTreeNode.removeChild(separatorNode);
                rootTreeNode.addChild(separatorNode.getProgramNode());
            }
        }
        catch (TreeStructureException treeStructureException) {
            Log.error((String)"Unable to insert pattern node", (Throwable)treeStructureException);
        }
        return pattern;
    }

    private void createSeparatorPosition() {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        URCapProgramNode separatorNode = this.programAPI.getProgramModel().getProgramNodeFactory().createURCapProgramNode(PositionNodeService.class);
        try {
            root.addChild((ProgramNode)separatorNode);
            Position position = (Position)separatorNode.getAs(Position.class);
            position.initialize(PatternType.SEPARATOR, 0);
            ((AbstractCustomProgramNodeContribution)((Object)position)).setParentContribution(this);
        }
        catch (TreeStructureException treeStructureException) {
            Log.error((String)"Unable to insert separator node", (Throwable)treeStructureException);
        }
    }

    private void removeSeparatorPosition() {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        Optional<TreeNode> separator = this.findSeparator();
        if (separator.isPresent()) {
            try {
                root.removeChild(separator.get());
            }
            catch (TreeStructureException treeStructureException) {
                Log.error((String)"Unable to remove separator node", (Throwable)treeStructureException);
            }
        }
    }

    private Optional<TreeNode> findSeparator() {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        return root.getChildren().stream().filter(n -> ((URCapProgramNode)n.getProgramNode()).canGetAs(Position.class)).findFirst();
    }

    @Override
    public void deletePattern(Pattern pattern) {
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        List<TreeNode> treeNodes = rootTreeNode.getChildren().stream().filter(node -> ((URCapProgramNode)node.getProgramNode()).canGetAs(Pattern.class)).filter(node -> ((Pattern)((URCapProgramNode)node.getProgramNode()).getAs(Pattern.class)).getUUID().equals(pattern.getUUID())).collect(Collectors.toList());
        treeNodes.forEach(treeNode -> this.undoRedoManager.recordChanges(() -> {
            try {
                rootTreeNode.removeChild(treeNode);
            }
            catch (TreeStructureException treeStructureException) {
                Log.error((String)"Unable to delete pattern", (Throwable)treeStructureException);
            }
        }));
        this.getPallet().patternChanged(pattern);
    }

    @Override
    public List<Pattern> getDefinedPatterns() {
        return this.getPatterns(true);
    }

    @Override
    public List<Pattern> getAllPatterns() {
        return this.getPatterns(false);
    }

    private List<Pattern> getPatterns(boolean definedOnly) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (this.cachedRootNode == null) {
            this.cachedRootNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        }
        List treeNodes = this.cachedRootNode.getChildren();
        treeNodes.forEach(treeNode -> {
            if (((URCapProgramNode)treeNode.getProgramNode()).canGetAs(Pattern.class)) {
                List<Position> positions;
                Pattern pattern = (Pattern)((URCapProgramNode)treeNode.getProgramNode()).getAs(Pattern.class);
                if (!definedOnly) {
                    patterns.add(pattern);
                } else if (pattern.isDefined() && (positions = pattern.getPositions()).stream().allMatch(Position::isDefined) && !positions.isEmpty()) {
                    patterns.add(pattern);
                }
            }
        });
        return patterns;
    }

    private boolean isSeparatorChecked() {
        return this.model.get(KEY_SEPARATOR, false);
    }

    public Icon getIcon(boolean isUndefined) {
        return isUndefined ? PalletImageResource.patternsUndefined() : PalletImageResource.patternsDefined();
    }

    private void setHeight(com.ur.urcap.api.domain.value.simple.Length h) {
        this.model.set(KEY_SEPARATOR_HEIGHT, h);
    }

    public com.ur.urcap.api.domain.value.simple.Length getHeight() {
        return this.model.get(KEY_SEPARATOR_HEIGHT, (com.ur.urcap.api.domain.value.simple.Length)null);
    }

    private double getMetricHeight() {
        com.ur.urcap.api.domain.value.simple.Length length = this.model.get(KEY_SEPARATOR_HEIGHT, (com.ur.urcap.api.domain.value.simple.Length)null);
        return length == null ? 0.0 : length.getAs(Length.Unit.MM);
    }

    public void setSeparatorHeight(com.ur.urcap.api.domain.value.simple.Length val) {
        this.undoRedoManager.recordChanges(() -> this.setHeight(val));
        this.updateView();
    }

    @Override
    public double getSeparatorHeight() {
        return this.getMetricHeight();
    }

    @Override
    public void loadComplete(ContributionLoadCompleteContext contributionLoadCompleteContext) {
        super.loadComplete(contributionLoadCompleteContext);
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(true);
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        super.onInserted(contributionInsertedContext);
        if (contributionInsertedContext.isCloning()) {
            this.getProgramNodeContributionChildren().forEach(child -> child.onInserted(contributionInsertedContext));
        }
    }
}

