/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.patterns;

import com.ur.pallet.common.i18n.TextResource;
import com.ur.polyscope.pallet.impl.patterns.PatternsProgramNodeContribution;
import com.ur.polyscope.pallet.impl.service.InternalPalletUIService;
import com.ur.polyscope.pallet.impl.util.AllowNullOrEmpty;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PatternsProgramNodeView
implements SwingProgramNodeView<PatternsProgramNodeContribution> {
    private final TextResource textResource;
    private final InternalPalletUIService palletUIService;
    private final Dimension labelDimension = new Dimension(175, 50);
    private final Dimension buttonDimension = new Dimension(275, 110);
    private final Dimension rowDimension = new Dimension(650, 116);
    private final Border rowBorder = new EmptyBorder(5, 100, 5, 0);
    private final Dimension descriptionDimension = new Dimension(700, 75);
    private JCheckBox separatorCheckBox;
    private JLabel separatorLabel;
    private NumberField separatorHeightField;

    PatternsProgramNodeView(TextResource textResource, InternalPalletUIService palletUIService) {
        this.textResource = textResource;
        this.palletUIService = palletUIService;
    }

    public void buildUI(JPanel jPanel, ContributionProvider<PatternsProgramNodeContribution> provider) {
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel descriptionRow = new JPanel();
        descriptionRow.setLayout(new BoxLayout(descriptionRow, 0));
        this.setDimension(descriptionRow, this.descriptionDimension);
        descriptionRow.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel description = new JLabel(this.textResource.patternsHelp());
        description.setAlignmentX(0.0f);
        descriptionRow.add(description);
        JPanel lineRow = this.createPatternRow(this.textResource.line(), actionEvent -> ((PatternsProgramNodeContribution)provider.get()).lineSelected(), PalletImageResource.line(), "PatternsProgramNodeView.LineButton");
        JPanel gridRow = this.createPatternRow(this.textResource.grid(), actionEvent -> ((PatternsProgramNodeContribution)provider.get()).gridSelected(), PalletImageResource.grid(), "PatternsProgramNodeView.GridButton");
        JPanel irregularRow = this.createPatternRow(this.textResource.irregular(), actionEvent -> ((PatternsProgramNodeContribution)provider.get()).irregularSelected(), PalletImageResource.irregular(), "PatternsProgramNodeView.IrregularButton");
        jPanel.add(descriptionRow);
        jPanel.add(lineRow);
        jPanel.add(gridRow);
        jPanel.add(irregularRow);
        JPanel separatorRow = this.createSeparatorRow(provider);
        jPanel.add(separatorRow);
    }

    void updateView(boolean separatorChecked) {
        this.selectSeparator(separatorChecked);
    }

    private JPanel createPatternRow(String labelText, ActionListener listener, ImageIcon buttonIcon, String buttonName) {
        JLabel label = new JLabel(labelText);
        this.setDimension(label, this.labelDimension);
        label.setAlignmentY(0.5f);
        JButton button = new JButton();
        button.setBorder(new LineBorder(Color.LIGHT_GRAY));
        button.setIcon(buttonIcon);
        button.addActionListener(listener);
        button.setAlignmentY(0.5f);
        button.setName(buttonName);
        this.setDimension(button, this.buttonDimension);
        JPanel row = new JPanel();
        row.setLayout(new BoxLayout(row, 0));
        row.setAlignmentX(0.5f);
        row.setBorder(this.rowBorder);
        this.setDimension(row, this.rowDimension);
        row.add(label);
        row.add(button);
        return row;
    }

    private JPanel createSeparatorRow(final ContributionProvider<PatternsProgramNodeContribution> provider) {
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        JPanel separatorRow = new JPanel();
        separatorRow.setLayout(new BoxLayout(separatorRow, 0));
        separatorRow.setAlignmentX(0.5f);
        separatorRow.setBorder(this.rowBorder);
        this.setDimension(separatorRow, this.rowDimension);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        this.separatorCheckBox = new JCheckBox(this.textResource.separator());
        this.separatorCheckBox.setName("PatternsProgramNodeView.SeparatorCheckbox");
        this.separatorCheckBox.setHorizontalAlignment(2);
        leftPanel.add(this.createSeparatorSubPanel(this.separatorCheckBox, 0));
        main.add(separatorRow);
        this.separatorHeightField = new NumberField(UnitsValueConverterFactory.getLengthConverter(), true);
        this.separatorHeightField.setErrorValidationStrategy(new ValidationStrategy[]{new AllowNullOrEmpty(ValidationFactory.getRangeValidator((double)0.0, (double)1000000.0, (UnitsConverter)Units.getMmConverter()))});
        this.separatorHeightField.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getCannotBeEmptyValidatorNoErrorMessage()});
        this.separatorHeightField.addActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Length value = (Length)PatternsProgramNodeView.this.separatorHeightField.getValue();
                ((PatternsProgramNodeContribution)provider.get()).setSeparatorHeight((com.ur.urcap.api.domain.value.simple.Length)value);
            }
        });
        this.setDimension((JComponent)this.separatorHeightField, new Dimension(140, 32));
        this.separatorLabel = new JLabel(this.textResource.separatorHeight());
        leftPanel.add(this.createSeparatorSubPanel(this.separatorLabel, 12));
        leftPanel.add(this.createSeparatorSubPanel((JComponent)this.separatorHeightField, 12));
        this.separatorCheckBox.addActionListener(actionEvent -> {
            boolean checked = this.separatorCheckBox.isSelected();
            if (!checked) {
                this.palletUIService.confirmMessageDialog(this.getConfirmationMessage(), new ConfirmationDialogListener(){

                    public void onOkClicked() {
                        ((PatternsProgramNodeContribution)provider.get()).separatorToggled(false);
                        PatternsProgramNodeView.this.enableSeparator(false);
                    }

                    public void onCancelClicked() {
                        PatternsProgramNodeView.this.selectSeparator(true);
                    }
                });
            } else {
                ((PatternsProgramNodeContribution)provider.get()).separatorToggled(true);
                this.enableSeparator(true);
            }
        });
        separatorRow.add(leftPanel);
        separatorRow.add(Box.createHorizontalStrut(75));
        separatorRow.add(new JLabel(PalletImageResource.separatorHeight()));
        return main;
    }

    private JPanel createSeparatorSubPanel(JComponent jComponent, int spacesIn) {
        JPanel lp = new JPanel(new BorderLayout());
        this.setDimension(lp, new Dimension(200, 32));
        EmptyBorder empty = new EmptyBorder(0, spacesIn, 0, 0);
        lp.setBorder(empty);
        lp.add((Component)jComponent, "Center");
        return lp;
    }

    private void enableSeparator(boolean enable) {
        this.separatorLabel.setEnabled(enable);
        this.separatorHeightField.setEnabled(enable);
    }

    private void selectSeparator(boolean selected) {
        this.separatorCheckBox.setSelected(selected);
        this.enableSeparator(selected);
    }

    void setSeparatorHeight(Length height) {
        if (height != null) {
            this.separatorHeightField.setValue((Object)height);
        } else {
            this.separatorHeightField.setText("");
        }
    }

    private ConfirmationMessage getConfirmationMessage() {
        return new ConfirmationMessage(this.textResource.confirmDelete(), this.textResource.separatorDelete(), this.textResource.ok(), this.textResource.cancel());
    }

    private void setDimension(JComponent component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }
}

