/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.position;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.urcaps.jointposition.JointPositionUtil;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;

public final class DataModelPosition {
    private DataModelPosition() {
    }

    public static void removePosition(DataModel model, String keyPrefix) {
        model.remove(DataModelPosition.getKey("jointpositions", keyPrefix));
        model.remove(DataModelPosition.getKey("baseToFeature", keyPrefix));
        model.remove(DataModelPosition.getKey("TCPOffset", keyPrefix));
        model.remove(DataModelPosition.getKey("calibrationDeltaTheta", keyPrefix));
        model.remove(DataModelPosition.getKey("calibrationA", keyPrefix));
        model.remove(DataModelPosition.getKey("calibrationD", keyPrefix));
        model.remove(DataModelPosition.getKey("calibrationAlpha", keyPrefix));
        model.remove(DataModelPosition.getKey("calibrationJointChecksum", keyPrefix));
        model.remove(DataModelPosition.getKey("calibrationStatus", keyPrefix));
        model.remove(DataModelPosition.getKey("calibrationValidChecksum", keyPrefix));
    }

    static Pose6d getBaseToFeature(DataModel model, String keyPrefix) {
        double[] doubles = model.get(DataModelPosition.getKey("baseToFeature", keyPrefix), (double[])null);
        return new Pose6d(doubles);
    }

    static double[] getTCPOffset(DataModel model, String keyPrefix) {
        return model.get(DataModelPosition.getKey("TCPOffset", keyPrefix), (double[])null);
    }

    public static JointPositions getJointPositions(DataModel model, String keyPrefix) {
        return model.get(DataModelPosition.getKey("jointpositions", keyPrefix), JointPositionUtil.EMPTY_JOINT_POSITIONS);
    }

    static String getKey(String baseKey, String keyPrefix) {
        if (!keyPrefix.isEmpty()) {
            return keyPrefix + "_" + baseKey;
        }
        return baseKey;
    }
}

