/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.position;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.pallet.common.model.NamedUUID;
import com.ur.pallet.common.model.PatternType;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.impl.pallet.Pallet;
import com.ur.polyscope.pallet.impl.pallet.PalletNewVersionToggle;
import com.ur.polyscope.pallet.impl.pattern.Pattern;
import com.ur.polyscope.pallet.impl.patterns.Patterns;
import com.ur.polyscope.pallet.impl.position.DataModelPosition;
import com.ur.polyscope.pallet.impl.position.Pose6dTransformUtils;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.position.PositionProgramNodeView;
import com.ur.polyscope.pallet.impl.position.ScriptGeneration;
import com.ur.polyscope.pallet.impl.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.jointposition.JointPositionUtil;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.variable.GlobalVariable;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.util.logging.Log;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.media.j3d.Transform3D;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class PositionProgramNodeContribution
extends AbstractCustomProgramNodeContribution
implements Position,
IconContribution {
    private static final String KEY_VARIABLE = "variable";
    private static final String KEY_UUID = "UUID";
    private static final String KEY_PATTERN_TYPE = "patternType";
    private static final String KEY_INDEX = "index";
    private static final String ITEM_NAME = "Item";
    private static final String CORNER_ITEM_NAME = "CornerItem";
    private static final String START_ITEM_NAME = "StartItem";
    private static final String END_ITEM_NAME = "EndItem";
    private static final String SEPARATOR_NAME = "Separator";
    private static final String MODEL_KEY_PREFIX = "";
    private final DataModel model;
    private final UndoRedoManager undoRedoManager;
    private final ProgramAPI programAPI;
    private final PalletMotionService palletMotionService;
    private final PalletFeatureService palletFeatureService;
    private final PositionProgramNodeView view;
    private final Icon cornerUndefined;
    private final Icon cornerDefined;

    PositionProgramNodeContribution(ProgramAPIProvider programAPIProvider, PositionProgramNodeView view, DataModel dataModel, PalletMotionService palletMotionService, PalletFeatureService palletFeatureService) {
        this.programAPI = programAPIProvider.getProgramAPI();
        this.palletMotionService = palletMotionService;
        this.palletFeatureService = palletFeatureService;
        this.undoRedoManager = this.programAPI.getUndoRedoManager();
        this.view = view;
        this.model = dataModel;
        if (dataModel.get(KEY_UUID, MODEL_KEY_PREFIX).equals(MODEL_KEY_PREFIX)) {
            this.createUUID();
        }
        this.cornerUndefined = PalletImageResource.cornerUndefined();
        this.cornerDefined = PalletImageResource.cornerDefined();
    }

    private void createUUID() {
        this.model.set(KEY_UUID, UUID.randomUUID().toString());
    }

    @Override
    public Pattern getPattern() {
        return (Pattern)this.getParentContribution();
    }

    @Override
    public void duplicate(Position positionToDuplicate) {
        PatternType patternType = positionToDuplicate.getPatternType();
        int index = positionToDuplicate.getIndex();
        this.model.set(KEY_PATTERN_TYPE, patternType.name());
        this.model.set(KEY_INDEX, index);
        try {
            GlobalVariable positionVariable = this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(this.createInitialName(patternType, index));
            this.model.set(KEY_VARIABLE, (Variable)positionVariable);
        }
        catch (VariableException e) {
            Log.error((String)"Unable to create variable", (Throwable)e);
        }
        if (positionToDuplicate.isDefined()) {
            this.palletMotionService.setPositionInDataModel(positionToDuplicate.getPose(), positionToDuplicate.getJointPositions(), this.model, this.getPallet().getPalletFeatureName(), MODEL_KEY_PREFIX);
        }
    }

    public void openView() {
        this.updateView();
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.getName();
    }

    @Override
    public void initialize(PatternType patternType, int index) {
        this.model.set(KEY_PATTERN_TYPE, patternType.name());
        this.model.set(KEY_INDEX, index);
        this.setVariableName(this.createInitialName(patternType, index));
    }

    @Override
    public boolean isDefined() {
        JointPositions jointPositions = this.getJointPositions();
        double[] tcpOffset = this.getTCPOffset();
        return tcpOffset != null && !jointPositions.equals((Object)JointPositionUtil.EMPTY_JOINT_POSITIONS);
    }

    public Icon getIcon(boolean isUndefined) {
        return isUndefined ? this.cornerUndefined : this.cornerDefined;
    }

    public UUID getUUID() {
        return UUID.fromString(this.model.get(KEY_UUID, MODEL_KEY_PREFIX));
    }

    private Pallet getPallet() {
        if (this.getPatternType() == PatternType.SEPARATOR) {
            return ((Patterns)this.getParentContribution()).getPallet();
        }
        return this.getPattern().getPatterns().getPallet();
    }

    public void generateScript(ScriptWriter scriptWriter) {
    }

    @Override
    public void doGenerateScript(ScriptWriter scriptWriter) {
        String positionPose = this.createPositionPoseForScript();
        if (!positionPose.isEmpty()) {
            scriptWriter.assign(this.model.get(KEY_VARIABLE, (Variable)null), positionPose);
        }
        scriptWriter.writeChildren();
    }

    @Override
    public String createPositionPoseForScript() {
        String palletFeatureName = this.getPallet().getPalletFeatureName();
        String featureScriptPose = this.palletFeatureService.getFeatureScriptPose(palletFeatureName);
        Pose6d pose6d = this.getBaseToFeature();
        Pose6d pose = this.palletMotionService.getInternalPoseFromDataModel(this.model, MODEL_KEY_PREFIX);
        if (pose != null) {
            return ScriptGeneration.generatePositionProgramNodeScript(featureScriptPose, Pose6dTransformUtils.getTransform3D(pose6d), pose, this.palletMotionService);
        }
        return MODEL_KEY_PREFIX;
    }

    private String createInitialName(PatternType layerType, int index) {
        String result = null;
        switch (layerType) {
            case LINE: {
                result = this.onLineSwitch(index, result);
                break;
            }
            case GRID: {
                result = "CornerItem_" + (index + 1);
                break;
            }
            case IRREGULAR: {
                result = "Item_" + (index + 1);
                break;
            }
            case SEPARATOR: {
                result = SEPARATOR_NAME;
                break;
            }
            default: {
                result = MODEL_KEY_PREFIX;
            }
        }
        return result;
    }

    private String onLineSwitch(int index, String result) {
        switch (index) {
            case 0: {
                result = "StartItem_1";
                break;
            }
            case 1: {
                result = "EndItem_1";
                break;
            }
        }
        return result;
    }

    @Override
    public Pose6d getBaseToFeature() {
        return DataModelPosition.getBaseToFeature(this.model, MODEL_KEY_PREFIX);
    }

    private void setVariableName(String name) {
        try {
            GlobalVariable positionVariable = this.programAPI.getVariableModel().getVariableFactory().createGlobalVariable(name);
            this.undoRedoManager.recordChanges(() -> this.model.set(KEY_VARIABLE, (Variable)positionVariable));
        }
        catch (VariableException e) {
            Log.error((String)"Unable to create variable", (Throwable)e);
        }
    }

    void updateView() {
        this.getPallet().updateReferencePoint();
        this.view.updateUI(this.getActualJointPositionsUI(), this.getName(), this.getPatternType(), this.getIndex());
    }

    public String getName() {
        Variable positionVariable = this.model.get(KEY_VARIABLE, (Variable)null);
        return positionVariable == null ? MODEL_KEY_PREFIX : positionVariable.getDisplayName();
    }

    public void setName(String name) {
        this.setVariableName(name);
        this.updateView();
    }

    @Override
    public double[] getTCPOffset() {
        return DataModelPosition.getTCPOffset(this.model, MODEL_KEY_PREFIX);
    }

    void setPosition(Pose pose, JointPositions jointPositions) {
        this.undoRedoManager.recordChanges(() -> {
            this.palletMotionService.setPositionInDataModel(pose, jointPositions, this.model, this.getPallet().getPalletFeatureName(), MODEL_KEY_PREFIX);
            Pattern firstLayerPattern = this.getPallet().getLayers().getFirstLayerPattern();
            if (this.getPatternType() != PatternType.SEPARATOR && firstLayerPattern != null && firstLayerPattern.getUUID().equals(this.getPattern().getUUID())) {
                boolean updateReferencePoint = false;
                if (PatternType.IRREGULAR == this.getPatternType()) {
                    updateReferencePoint = firstLayerPattern.getPositions().get(0).getIndex() == this.getIndex();
                } else if (PatternType.LINE == this.getPatternType() || PatternType.GRID == this.getPatternType()) {
                    boolean bl = updateReferencePoint = this.getIndex() == 0;
                }
                if (updateReferencePoint) {
                    this.getPallet().updateReferencePoint();
                }
            }
            this.updateView();
        });
        if (this.getPatternType() == PatternType.SEPARATOR) {
            this.getPallet().setSeparator(this);
        } else {
            this.getPallet().patternChanged(this.getPattern());
        }
    }

    @Override
    public Pose getPose() {
        Pose6d internalPose = this.palletMotionService.getInternalPoseFromDataModel(this.model, MODEL_KEY_PREFIX);
        return TypeConversion.getFromPolyScopePose(internalPose, this.programAPI);
    }

    @Override
    public Point3d getToolPosition() {
        Pose6d internalPose = this.palletMotionService.getInternalPoseFromDataModel(this.model, MODEL_KEY_PREFIX);
        if (internalPose != null) {
            return TypeConversion.point3dFromTuple((Tuple3d)internalPose.getPos());
        }
        return null;
    }

    @Override
    public Point3d getActualToolPosition() {
        Pose6d pose6d = this.applyRelativeFeatureTransformToToolPose(new Pose6d((Tuple3d)this.getToolPosition(), (Tuple3d)this.getToolAxisAngle()));
        return new Point3d((Tuple3d)pose6d.getPos());
    }

    @Override
    public Point3d getActualToolAxisAngle() {
        Pose6d pose6d = this.applyRelativeFeatureTransformToToolPose(new Pose6d((Tuple3d)this.getToolPosition(), (Tuple3d)this.getToolAxisAngle()));
        return new Point3d((Tuple3d)pose6d.getRot());
    }

    @Override
    public Point3d getToolAxisAngle() {
        Pose6d internalPose = this.palletMotionService.getInternalPoseFromDataModel(this.model, MODEL_KEY_PREFIX);
        if (internalPose != null) {
            return TypeConversion.point3dFromTuple((Tuple3d)internalPose.getRot());
        }
        return null;
    }

    public Variable getVariable() {
        return this.model.get(KEY_VARIABLE, (Variable)null);
    }

    @Override
    public JointPositions getJointPositions() {
        return DataModelPosition.getJointPositions(this.model, MODEL_KEY_PREFIX);
    }

    @Override
    public JointPositionVector getActualJointPositions() {
        Pose6d internalPose = this.palletMotionService.getInternalPoseFromDataModel(this.model, MODEL_KEY_PREFIX);
        if (internalPose == null) {
            return null;
        }
        return this.tryGetTransformedJointPositions(internalPose);
    }

    private JointPositionVector getActualJointPositionsUI() {
        Pose6d internalPose = this.palletMotionService.getInternalPoseFromDataModel(this.model, MODEL_KEY_PREFIX);
        if (internalPose == null) {
            return new JointPositionVector();
        }
        if (PalletNewVersionToggle.isActive()) {
            return this.getTransformedJointPositions(internalPose);
        }
        return this.tryGetTransformedJointPositions(internalPose);
    }

    private JointPositionVector getTransformedJointPositions(Pose6d internalPose) {
        JointPositionVector jointPositions = TypeConversion.getPolyScopeJPV(this.getJointPositions());
        Pose6d transformedPose = this.applyRelativeFeatureTransformToToolPose(internalPose);
        return this.palletMotionService.getInverseKinematics(transformedPose, jointPositions);
    }

    private JointPositionVector tryGetTransformedJointPositions(Pose6d internalPose) {
        JointPositionVector jointPositions = TypeConversion.getPolyScopeJPV(this.getJointPositions());
        Pose6d transformedPose = this.applyRelativeFeatureTransformToToolPose(internalPose);
        JointPositionVector inverseKinematics = this.palletMotionService.getInverseKinematics(transformedPose, jointPositions);
        if (inverseKinematics == null) {
            Log.error((String)"Failed to get joint positions relative to pallet feature, falling back to taught values");
            return jointPositions;
        }
        return inverseKinematics;
    }

    private Pose6d applyRelativeFeatureTransformToToolPose(Pose6d baseToTool) {
        GeomFeature geomFeature = PalletNewVersionToggle.isActive() ? this.getPalletGeomFeature5_23() : this.getPalletGeomFeature();
        if (geomFeature == null) {
            return baseToTool;
        }
        Transform3D tBaseNewFeature = geomFeature.getTransform();
        Transform3D tFeatureTool = this.getWaypointInFeatureCoordinates(baseToTool);
        Transform3D tFeatureTransformedBaseToTool = new Transform3D();
        tFeatureTransformedBaseToTool.mul(tBaseNewFeature, tFeatureTool);
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D(tFeatureTransformedBaseToTool);
    }

    private GeomFeature getPalletGeomFeature() {
        Collection features = this.palletFeatureService.getApplicablePalletFeatures();
        String palletFeatureName = this.getPallet().getPalletFeatureName();
        Optional<Feature> feature = features.stream().filter(f -> f.getName().equals(palletFeatureName)).findFirst();
        if (!feature.isPresent() || palletFeatureName.equalsIgnoreCase("base")) {
            return null;
        }
        SpatialFeature unwrappedFeature = this.palletFeatureService.unwrapFeature(feature.get());
        return unwrappedFeature instanceof GeomFeature ? (GeomFeature)unwrappedFeature : null;
    }

    private GeomFeature getPalletGeomFeature5_23() {
        Collection features = this.palletFeatureService.getApplicablePalletFeatures();
        String palletFeatureName = this.getPallet().getPalletFeatureName();
        Optional<Feature> feature = features.stream().filter(f -> f.getName().equals(palletFeatureName)).findFirst();
        if (!feature.isPresent()) {
            return null;
        }
        SpatialFeature unwrappedFeature = this.palletFeatureService.unwrapFeature(feature.get());
        return unwrappedFeature instanceof GeomFeature ? (GeomFeature)unwrappedFeature : null;
    }

    private Transform3D getWaypointInFeatureCoordinates(Pose6d poseInBase) {
        Transform3D tBaseTool = Pose6dTransformUtils.getTransform3D(poseInBase);
        Pose6d baseToFeatureTransform = this.getBaseToFeature();
        Transform3D tFeatureTool = new Transform3D();
        Transform3D tFeatureBase = new Transform3D();
        tFeatureBase.invert(Pose6dTransformUtils.getTransform3D(baseToFeatureTransform));
        tFeatureTool.mul(tFeatureBase, tBaseTool);
        return tFeatureTool;
    }

    void deletePosition() {
        this.getPattern().deletePosition((NamedUUID)this);
        this.getPallet().patternChanged(this.getPattern());
    }

    @Override
    public PatternType getPatternType() {
        String pattern = this.model.get(KEY_PATTERN_TYPE, MODEL_KEY_PREFIX);
        if (!pattern.isEmpty()) {
            return PatternType.valueOf((String)pattern);
        }
        return null;
    }

    @Override
    public int getIndex() {
        return this.model.get(KEY_INDEX, -1);
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        super.onInserted(contributionInsertedContext);
        if (contributionInsertedContext.isCloning()) {
            String name = ((Position)((URCapProgramNode)this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).getProgramNode()).getAs(Position.class)).getName();
            this.setVariableName(name);
        }
    }
}

