/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.position;

import com.ur.monitor.model.JointPositionVector;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.pallet.common.model.PatternType;
import com.ur.polyscope.pallet.PalletNamingService;
import com.ur.polyscope.pallet.impl.pallet.PalletNewVersionToggle;
import com.ur.polyscope.pallet.impl.position.PositionProgramNodeContribution;
import com.ur.polyscope.pallet.impl.service.InternalPalletUIService;
import com.ur.polyscope.pallet.impl.util.PalletImageResource;
import com.ur.polyscope.pallet.impl.util.PatternIconResource;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.pallet.impl.validators.OrValidator;
import com.ur.polyscope.pallet.impl.validators.VariableNameCompositeValidator;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingFormBuilder;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.UserInterfaceAPI;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback;
import com.ur.urcap.api.domain.userinteraction.robot.movement.MovementCompleteEvent;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.java.balloontip.BalloonTip;

public class PositionProgramNodeView
implements SwingProgramNodeView<PositionProgramNodeContribution> {
    private static final Dimension ROBOT_3D_IMAGE_SIZE = new Dimension(200, 180);
    private static final Color BETWEEN_CARD_COLOR = new Color(230, 230, 230);
    private final UserInterfaceAPI userInterfaceAPI;
    private final WidgetFactory widgetFactory;
    private final TextResource textResource;
    private InternalPalletUIService palletUIService;
    private final PalletNamingService palletNamingService;
    private RobotCanvas3D robotCanvas3D;
    private ProgramVisualization programVisualizer;
    private ImagePlaceHolder undefinedGraphics;
    private ImagePlaceHolder unreachableGraphics;
    private JLabel positionNameLabel;
    private JButton deletePositionButton;
    private JLabel illustration;
    private JButton moveRobotHereButton;
    private JButton setPositionButton;
    private JLabel unreachableWaypointHelper;

    PositionProgramNodeView(UserInterfaceAPI userInterfaceAPI, TextResource textResource, InternalPalletUIService palletUIService, PalletNamingService palletNamingService) {
        this.userInterfaceAPI = userInterfaceAPI;
        this.textResource = textResource;
        this.widgetFactory = palletUIService.getWidgetFactory();
        this.palletUIService = palletUIService;
        this.palletNamingService = palletNamingService;
    }

    public void buildUI(JPanel jPanel, ContributionProvider<PositionProgramNodeContribution> contributionProvider) {
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        SwingFormBuilder formBuilder = new SwingFormBuilder(this.widgetFactory);
        JPanel helpPanel = new JPanel();
        Dimension helpPanelSize = new Dimension(680, 60);
        helpPanel.setMaximumSize(helpPanelSize);
        helpPanel.setMinimumSize(helpPanelSize);
        helpPanel.setPreferredSize(helpPanelSize);
        helpPanel.add(new JLabel(this.textResource.positionTeachHelp()));
        jPanel.add(helpPanel);
        JPanel contentPanel = new JPanel(new GridLayout(2, 1));
        RenamePositionAction renamePositionAction = new RenamePositionAction(contributionProvider);
        JButton renamePositionButton = this.widgetFactory.createButton((Action)((Object)renamePositionAction));
        renamePositionButton.setIcon(PalletImageResource.rename());
        renamePositionButton.setName("rename.PositionProgramNodeView");
        renamePositionAction.bind(renamePositionButton);
        this.positionNameLabel = new JLabel();
        this.deletePositionButton = this.widgetFactory.createButton((Action)((Object)new DeletePositionAction(contributionProvider)));
        this.deletePositionButton.setIcon(PalletImageResource.delete());
        JPanel namePanel = formBuilder.component((JComponent)renamePositionButton, new FormBuilder.PanelConstraints[0]).component((JComponent)this.positionNameLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.deletePositionButton, new FormBuilder.PanelConstraints[0]).getRow();
        this.setPositionButton = this.widgetFactory.createButton((Action)((Object)new SetPositionAction(contributionProvider)));
        JLabel cornerNote = new JLabel(HTML.html((String)this.textResource.cornerPositionNote()));
        cornerNote.setFont(new Font("DejaVu", 0, 12));
        Dimension cornerNoteSize = new Dimension(350, 60);
        cornerNote.setMaximumSize(cornerNoteSize);
        cornerNote.setMinimumSize(cornerNoteSize);
        cornerNote.setPreferredSize(cornerNoteSize);
        JPanel leftSide = new JPanel();
        Dimension leftSideSize = new Dimension(350, 250);
        leftSide.setMaximumSize(leftSideSize);
        leftSide.setMinimumSize(leftSideSize);
        leftSide.setPreferredSize(leftSideSize);
        JPanel leftPanel = formBuilder.component((JComponent)namePanel, new FormBuilder.PanelConstraints[0]).end().end().component((JComponent)this.setPositionButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.BUTTON_ROW}).end().end().component((JComponent)cornerNote, new FormBuilder.PanelConstraints[0]).end().getPanel();
        leftSide.add(leftPanel);
        Dimension moveButtonSize = new Dimension(PositionProgramNodeView.ROBOT_3D_IMAGE_SIZE.width, 40);
        this.moveRobotHereButton = new JButton(this.textResource.moveHere());
        this.moveRobotHereButton.addActionListener(actionEvent -> {
            JointPositionVector actualJointPositions = ((PositionProgramNodeContribution)contributionProvider.get()).getActualJointPositions();
            this.userInterfaceAPI.getUserInteraction().getRobotMovement().requestUserToMoveRobot(TypeConversion.getURCapJPV(actualJointPositions), new RobotMovementCallback(){

                public void onComplete(MovementCompleteEvent movementCompleteEvent) {
                }
            });
        });
        this.moveRobotHereButton.setMaximumSize(moveButtonSize);
        this.moveRobotHereButton.setMinimumSize(moveButtonSize);
        this.moveRobotHereButton.setPreferredSize(moveButtonSize);
        ImageIcon unreachableInfoIcon = PalletImageResource.questionMark();
        int spacerWidth = 2;
        int rightSpacerWidth = unreachableInfoIcon.getIconWidth() + spacerWidth;
        int moveButtonPanelWidth = PositionProgramNodeView.ROBOT_3D_IMAGE_SIZE.width + rightSpacerWidth;
        JPanel moveButtonPanel = new JPanel();
        moveButtonPanel.setLayout(new BorderLayout());
        moveButtonPanel.add((Component)this.moveRobotHereButton, "West");
        moveButtonPanel.setMaximumSize(new Dimension(moveButtonPanelWidth, 40));
        moveButtonPanel.setMinimumSize(new Dimension(moveButtonPanelWidth, 40));
        moveButtonPanel.setPreferredSize(new Dimension(moveButtonPanelWidth, 40));
        JPanel moveButtonSpacer = new JPanel();
        moveButtonSpacer.setSize(rightSpacerWidth, 40);
        moveButtonPanel.add((Component)moveButtonSpacer, "East");
        this.robotCanvas3D = this.palletUIService.createRobotCanvas3d();
        this.robotCanvas3D.setDebugName("Pallet Position Node 3D Canvas");
        this.programVisualizer = this.palletUIService.createProgramVisualization(this.robotCanvas3D);
        this.programVisualizer.clearVisualization();
        this.robotCanvas3D.setVisible(false);
        this.robotCanvas3D.getComponent().setPreferredSize(ROBOT_3D_IMAGE_SIZE);
        this.robotCanvas3D.getComponent().setMaximumSize(ROBOT_3D_IMAGE_SIZE);
        JPanel imagePlaceholder = new JPanel(new CardLayout());
        imagePlaceholder.setBorder(BorderFactory.createLineBorder(BETWEEN_CARD_COLOR, 3));
        imagePlaceholder.setPreferredSize(ROBOT_3D_IMAGE_SIZE);
        imagePlaceholder.setMaximumSize(ROBOT_3D_IMAGE_SIZE);
        this.undefinedGraphics = new ImagePlaceHolder(true, false);
        imagePlaceholder.add(this.undefinedGraphics);
        imagePlaceholder.add(this.robotCanvas3D.getComponent());
        this.unreachableGraphics = new ImagePlaceHolder(false, true);
        imagePlaceholder.add(this.unreachableGraphics);
        Dimension unreachableWaypointHelperSize = new Dimension(rightSpacerWidth, unreachableInfoIcon.getIconHeight());
        this.unreachableWaypointHelper = new JLabel();
        this.unreachableWaypointHelper.setIcon(unreachableInfoIcon);
        this.unreachableWaypointHelper.setMaximumSize(unreachableWaypointHelperSize);
        this.unreachableWaypointHelper.setMinimumSize(unreachableWaypointHelperSize);
        this.unreachableWaypointHelper.setPreferredSize(unreachableWaypointHelperSize);
        this.unreachableWaypointHelper.addMouseListener(this.createMouseListener());
        JPanel unreachablePanel = new JPanel();
        unreachablePanel.setLayout(new BorderLayout());
        unreachablePanel.setBorder(new EmptyBorder(0, spacerWidth, 0, 0));
        unreachablePanel.setPreferredSize(unreachableWaypointHelperSize);
        unreachablePanel.setMaximumSize(unreachableWaypointHelperSize);
        unreachablePanel.setMinimumSize(unreachableWaypointHelperSize);
        unreachablePanel.add((Component)this.unreachableWaypointHelper, "South");
        JPanel posePanel = new JPanel();
        posePanel.setLayout(new BorderLayout());
        posePanel.add((Component)imagePlaceholder, "Center");
        posePanel.add((Component)unreachablePanel, "East");
        JPanel rightSide = new JPanel(new BorderLayout(10, 10));
        rightSide.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        rightSide.setMaximumSize(new Dimension(moveButtonPanelWidth, 250));
        rightSide.setMinimumSize(new Dimension(moveButtonPanelWidth, 250));
        rightSide.setPreferredSize(new Dimension(moveButtonPanelWidth, 250));
        rightSide.add((Component)posePanel, "Center");
        rightSide.add((Component)moveButtonPanel, "South");
        JPanel middle = new JPanel();
        middle.setLayout(new BoxLayout(middle, 0));
        middle.setPreferredSize(new Dimension(jPanel.getWidth(), jPanel.getHeight() / 2));
        middle.setMaximumSize(new Dimension(jPanel.getWidth(), jPanel.getHeight() / 2));
        middle.setMinimumSize(new Dimension(jPanel.getWidth(), jPanel.getHeight() / 2));
        middle.add(Box.createHorizontalStrut(75));
        middle.add(leftSide);
        middle.add(Box.createHorizontalStrut(30));
        middle.add(rightSide);
        middle.add(Box.createHorizontalStrut(75));
        middle.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BETWEEN_CARD_COLOR));
        contentPanel.add(middle);
        JPanel bottom = new JPanel();
        bottom.setPreferredSize(new Dimension(jPanel.getWidth(), jPanel.getHeight() / 2));
        bottom.setMaximumSize(new Dimension(jPanel.getWidth(), jPanel.getHeight() / 2));
        bottom.setMinimumSize(new Dimension(jPanel.getWidth(), jPanel.getHeight() / 2));
        this.illustration = new JLabel();
        this.illustration.setBorder(new EmptyBorder(15, 0, 0, 0));
        bottom.add(this.illustration);
        contentPanel.add(bottom);
        jPanel.add(contentPanel);
    }

    void updateUI(JointPositionVector jpv, String name, PatternType patternType, int index) {
        boolean unreachable;
        this.positionNameLabel.setText(name);
        this.setPositionButton.setText(this.textResource.setItem(name));
        this.deletePositionButton.setVisible(patternType == PatternType.IRREGULAR);
        boolean bl = unreachable = PalletNewVersionToggle.isActive() && jpv == null;
        boolean undefined = PalletNewVersionToggle.isActive() ? jpv != null && jpv.isUndefined() : jpv == null || jpv.isUndefined();
        this.undefinedGraphics.setVisible(undefined);
        this.unreachableGraphics.setVisible(unreachable);
        this.robotCanvas3D.setVisible(!undefined && !unreachable);
        this.moveRobotHereButton.setEnabled(!undefined && !unreachable);
        this.unreachableWaypointHelper.setVisible(unreachable);
        if (!unreachable && !undefined) {
            this.robotCanvas3D.addQueue(() -> {
                this.robotCanvas3D.setRobotAttached(true);
                this.robotCanvas3D.setJointAngleVector(jpv);
                this.programVisualizer.clearVisualization();
            });
        }
        ImageIcon imageIcon = PatternIconResource.getPatternImageIcon(patternType, index);
        this.illustration.setIcon(imageIcon);
    }

    private MouseAdapter createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DisplayMessageFactory.informCloseAnyClick((JComponent)PositionProgramNodeView.this.unreachableWaypointHelper, (String)PositionProgramNodeView.this.textResource.unreachableCornerReset(), (BalloonTip.AttachLocation)BalloonTip.AttachLocation.NORTHWEST, (Dimension)new Dimension(100, 100), null);
            }
        };
    }

    private class RenamePositionAction
    extends AbstractActionDefinition {
        private final transient ContributionProvider<PositionProgramNodeContribution> contributionProvider;
        private final transient ValidationStrategy validator;

        RenamePositionAction(ContributionProvider<PositionProgramNodeContribution> contributionProvider) {
            this.contributionProvider = contributionProvider;
            this.validator = new OrValidator((ValidationStrategy)new VariableNameCompositeValidator(PositionProgramNodeView.this.textResource, PositionProgramNodeView.this.palletNamingService), new CurrentNameValidator(contributionProvider));
        }

        void bind(JComponent component) {
            TextHolder textHolder = new TextHolder(){

                public String getText() {
                    return ((PositionProgramNodeContribution)RenamePositionAction.this.contributionProvider.get()).getName();
                }

                public void setText(String text) {
                    ((PositionProgramNodeContribution)RenamePositionAction.this.contributionProvider.get()).setName(text);
                }
            };
            TextFieldUtils.bindTextPicker((JComponent)component, (TextHolder)textHolder, (ValidationStrategy)this.validator);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class SetPositionAction
    extends AbstractActionDefinition {
        private final transient ContributionProvider<PositionProgramNodeContribution> contributionProvider;

        SetPositionAction(ContributionProvider<PositionProgramNodeContribution> contributionProvider) {
            this.contributionProvider = contributionProvider;
            this.initAction();
        }

        private void initAction() {
            this.putValue("Function", ActionDefinition.Function.PRIMARY);
            this.putValue("InternalName", "PositionProgramNodeView.setPosition");
        }

        public void actionPerformed(ActionEvent e) {
            PositionProgramNodeView.this.userInterfaceAPI.getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback(){

                public void onOk(Pose pose, JointPositions jointPositions) {
                    ((PositionProgramNodeContribution)SetPositionAction.this.contributionProvider.get()).setPosition(pose, jointPositions);
                    ((PositionProgramNodeContribution)SetPositionAction.this.contributionProvider.get()).updateView();
                }
            });
        }
    }

    private static class DeletePositionAction
    extends AbstractActionDefinition {
        private final transient ContributionProvider<PositionProgramNodeContribution> contributionProvider;

        DeletePositionAction(ContributionProvider<PositionProgramNodeContribution> contributionProvider) {
            this.contributionProvider = contributionProvider;
        }

        public void actionPerformed(ActionEvent e) {
            ((PositionProgramNodeContribution)this.contributionProvider.get()).deletePosition();
        }
    }

    private static class CurrentNameValidator
    implements ValidationStrategy {
        private final ContributionProvider<PositionProgramNodeContribution> contributionProvider;

        CurrentNameValidator(ContributionProvider<PositionProgramNodeContribution> contributionProvider) {
            this.contributionProvider = contributionProvider;
        }

        public boolean isValid(String uncheckedString) {
            return uncheckedString.equals(((PositionProgramNodeContribution)this.contributionProvider.get()).getName());
        }

        public String getErrorMessage(String uncheckedString) {
            return "";
        }
    }

    private static class ImagePlaceHolder
    extends JLabel {
        final Font tempFont = new Font("Verdana", 1, 20);

        ImagePlaceHolder(boolean undefined, boolean unreachable) {
            this.initComponent(undefined, unreachable);
        }

        private void initComponent(boolean undefined, boolean unreachable) {
            this.setHorizontalAlignment(0);
            this.setPreferredSize(ROBOT_3D_IMAGE_SIZE);
            this.setMaximumSize(ROBOT_3D_IMAGE_SIZE);
            this.setAlignmentX(0.0f);
            if (undefined) {
                this.setText("?");
                this.setFont(this.tempFont);
            } else if (unreachable) {
                this.setBackground(G5LookAndFeel.UNDEFINED_WARNING_COLOR);
                this.updateOpacity(true);
            }
        }

        private void updateOpacity(boolean opaque) {
            this.setOpaque(opaque);
        }
    }
}

