/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.position;

import com.ur.lang.DecimalFormatFactory;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.media.j3d.Transform3D;
import javax.vecmath.Tuple3d;

final class ScriptGeneration {
    private static final DecimalFormat df = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"#.000000000000", (Locale)Locale.ENGLISH);

    private ScriptGeneration() {
    }

    static String generatePositionProgramNodeScript(String featurePose, Transform3D baseToFeatureTransform, Pose6d pose, PalletMotionService palletMotionService) {
        StringBuilder s = new StringBuilder();
        Transform3D featureToBaseTransform = new Transform3D();
        featureToBaseTransform.invert(baseToFeatureTransform);
        Pose6d pose6d = palletMotionService.getPose6dEquivalentOfTransform3D(featureToBaseTransform);
        String featureInverse = ScriptGeneration.generatePose((Tuple3d)pose6d.getPos(), (Tuple3d)pose6d.getRot());
        String poseStr = ScriptGeneration.generatePose((Tuple3d)pose.getPos(), (Tuple3d)pose.getRot());
        String featureToTCP = "pose_trans(" + featureInverse + ", " + poseStr + ")";
        ScriptGeneration.appendPoseTransformation(s, featurePose, featureToTCP);
        return s.toString();
    }

    private static void appendPoseTransformation(StringBuilder s, String featurePose, String pose) {
        s.append("pose_trans(");
        s.append(TypeConversion.toScriptCode(featurePose));
        s.append(", ");
        s.append(pose);
        s.append(")");
    }

    private static String generatePose(Tuple3d pos, Tuple3d rot) {
        return "p[" + df.format(pos.x) + ", " + df.format(pos.y) + ", " + df.format(pos.z) + ", " + df.format(rot.x) + ", " + df.format(rot.y) + ", " + df.format(rot.z) + "]";
    }
}

