/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.separatoraction;

import com.ur.monitor.model.JointPositionVector;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.PalletProgramFeature;
import com.ur.polyscope.pallet.UpdateChildrenStrategy;
import com.ur.polyscope.pallet.impl.pallet.Pallet;
import com.ur.polyscope.pallet.impl.position.DataModelPosition;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.separatoraction.SeparatorAction;
import com.ur.polyscope.pallet.impl.separatoraction.SeparatorActionProgramNodeView;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.pallet.impl.wizard.AbstractPalletWizardContribution;
import com.ur.polyscope.pallet.impl.wizard.MoveDefinition;
import com.ur.polyscope.pallet.impl.wizard.WizardAction;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionInsertedContext;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.lifecycle.ContributionLoadCompleteContext;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.builtin.FolderNode;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.util.logging.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SeparatorActionProgramNodeContribution
extends AbstractPalletWizardContribution
implements SeparatorAction {
    private static final String SEPARATOR_APPROACH_NAME = "Sep_Approach";
    private static final String SEPARATOR_ACTION_WAYPOINT_NAME = "Sep_Action";
    private static final String SEPARATOR_EXIT_NAME = "Sep_Exit";
    private final SeparatorActionProgramNodeView view;
    private boolean movingNodeInProgramTree = false;
    private boolean inManualMode = false;
    private boolean wasWizardSelectedLastTime = true;

    SeparatorActionProgramNodeContribution(TextResource textResource, ProgramAPI programAPI, SeparatorActionProgramNodeView view, DataModel model, PalletMotionService palletMotionService, PalletFeatureService palletFeatureService) {
        super(programAPI, programAPI.getUndoRedoManager(), model, textResource, palletMotionService, palletFeatureService);
        this.view = view;
        TreeNode rootTreeNode = programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        rootTreeNode.setChildSequenceLocked(true);
    }

    public void openView() {
        this.updateView(!this.inManualMode);
        this.setInManualMode(false);
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.separatorAction();
    }

    public boolean isDefined() {
        if (this.wasWizardSelectedLastTime != this.isWizardSelected()) {
            this.toggleTreeLock(this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this), this.isWizardSelected());
            this.wasWizardSelectedLastTime = this.isWizardSelected();
        }
        return true;
    }

    public void generateScript(ScriptWriter writer) {
        String handleSeparatorVariableScriptName = writer.getResolvedVariableName(this.getPallet().getHandleSeparatorVariable());
        writer.ifCondition(handleSeparatorVariableScriptName + " == True");
        writer.writeChildren();
        writer.end();
    }

    private void initializeChildren(Position separatorPosition) {
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        boolean isPalletizing = this.getPallet().isPalletizing();
        Feature f = this.createFeature();
        MoveNode approachMoveNode = this.createMoveJNode();
        WaypointNode approach = this.createFixedWaypoint(SEPARATOR_APPROACH_NAME);
        MoveNode actionMoveNode = this.createMoveLNode(f);
        WaypointNode actionWaypoint = this.createFixedWaypoint(SEPARATOR_ACTION_WAYPOINT_NAME);
        MoveNode exitMoveNode = this.createMoveLNode(f);
        WaypointNode exit = this.createFixedWaypoint(SEPARATOR_EXIT_NAME);
        try {
            if (isPalletizing) {
                this.addFolder(root, this.textResource.beforeAction());
            }
            TreeNode approachTreeNode = root.addChild((ProgramNode)approachMoveNode);
            approachTreeNode.addChild((ProgramNode)approach);
            this.palletFeatureService.setFeatureOnMoveJHack(f, approachMoveNode);
            TreeNode actionTreeNode = root.addChild((ProgramNode)actionMoveNode);
            actionTreeNode.addChild((ProgramNode)actionWaypoint);
            this.initializeActionPoint(actionWaypoint, separatorPosition);
            this.addFolder(root, "Tool action");
            TreeNode exitTreeNode = root.addChild((ProgramNode)exitMoveNode);
            exitTreeNode.addChild((ProgramNode)exit);
            if (!isPalletizing) {
                this.addFolder(root, this.textResource.afterAction());
            }
            root.setChildSequenceLocked(false);
        }
        catch (TreeStructureException treeStructureException) {
            Log.error((String)"Failed to initialize children", (Throwable)treeStructureException);
        }
    }

    private void addFolder(TreeNode root, String name) throws TreeStructureException {
        FolderNode beforeFolder = this.programAPI.getProgramModel().getProgramNodeFactory().createFolderNode();
        beforeFolder.setName(name);
        root.addChild((ProgramNode)beforeFolder);
    }

    @Override
    protected Feature createFeature() {
        PalletProgramFeature referencePointFeature = this.getPallet().getSeparatorFeature();
        return this.palletFeatureService.wrapFeature((SpatialFeature)referencePointFeature);
    }

    @Override
    public Pallet getPallet() {
        return (Pallet)this.getParentContribution();
    }

    @Override
    public void loadComplete(ContributionLoadCompleteContext contributionLoadCompleteContext) {
        super.loadComplete(contributionLoadCompleteContext);
        this.toggleTreeLock(this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this), this.isWizardSelected());
        this.updateFeatureOnMoveNodes();
    }

    @Override
    public void setMovingNodeInProgramTree(boolean isMoving) {
        this.movingNodeInProgramTree = isMoving;
    }

    @Override
    public void onInserted(ContributionInsertedContext contributionInsertedContext) {
        if (this.movingNodeInProgramTree) {
            return;
        }
        super.onInserted(contributionInsertedContext);
        this.toggleTreeLock(this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this), this.isWizardSelected());
        if (contributionInsertedContext.isCloning()) {
            this.updateFeatureOnMoveNodes();
        } else {
            String wizardState = this.model.get("currentWizardState", "");
            if (wizardState.isEmpty()) {
                this.setWizardState(WizardAction.SHOW_INFO, false);
            }
        }
    }

    private void updateFeatureOnMoveNodes() {
        PalletProgramFeature separatorFeature = this.getPallet().getSeparatorFeature();
        if (separatorFeature != null && separatorFeature.isDefined()) {
            Feature feature = this.palletFeatureService.wrapFeature((SpatialFeature)separatorFeature);
            TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
            root.traverse(this.palletFeatureService.createFeatureUpdateVisitor(UpdateChildrenStrategy.NONE, feature, true, "separatorPoint", this.undoRedoManager));
        }
    }

    @Override
    protected void updateView(boolean allowWizardOverride) {
        WizardAction wizard = this.getWizardState();
        if (wizard == WizardAction.MANUAL && allowWizardOverride) {
            wizard = WizardAction.LANDING;
        }
        Optional<Position> separator = this.getSeparatorPosition();
        boolean enableMoveHere = false;
        if (separator.isPresent()) {
            enableMoveHere = !this.isAtlocation(separator.get());
        }
        this.view.updateReferencePointSelection(enableMoveHere);
        this.view.navigate(wizard, this::positionSet, this.getMoveDefinition(), this.getPallet().isPalletizing());
        if (wizard.hasGraphics()) {
            JointPositionVector jpv = null;
            if (wizard == WizardAction.TEACH_APPROACH || wizard == WizardAction.TEACH_EXIT) {
                String waypointName = wizard == WizardAction.TEACH_APPROACH ? "Approach" : "Exit";
                jpv = TypeConversion.getPolyScopeJPV(DataModelPosition.getJointPositions(this.model, waypointName));
            } else if (separator.isPresent()) {
                Position position = separator.get();
                jpv = position.getActualJointPositions();
            }
            this.view.updateGraphics(jpv);
        }
        if (wizard != WizardAction.SHOW_DONE) {
            boolean navigationAllowed = this.allowNavigation(wizard.nextState());
            if (!navigationAllowed) {
                this.view.disableForwardNavigation(this.getDisallowedNavigationMessage(wizard.nextState()));
            } else {
                this.view.enableForwardNavigation();
            }
        }
        if (wizard == WizardAction.LANDING && !this.hasChildren()) {
            separator.ifPresent(this::initializeChildren);
        }
    }

    private boolean hasChildren() {
        return !this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this).getChildren().isEmpty();
    }

    private void positionSet(String waypointName, Pose pose, JointPositions jointPositions) {
        this.undoRedoManager.recordChanges(() -> {
            this.palletMotionService.setPositionInDataModel(pose, jointPositions, this.model, this.getPallet().getPalletFeatureName(), waypointName);
            this.updateView(false);
        });
    }

    private boolean allowNavigation(WizardAction nextState) {
        boolean result = true;
        Optional<Position> separatorPosition = this.getSeparatorPosition();
        boolean separatorDefined = separatorPosition.isPresent();
        if (nextState != null) {
            switch (nextState) {
                case SHOW_INFO: 
                case LANDING: 
                case MANUAL: {
                    break;
                }
                case MOVE_APPROACH: {
                    result = separatorDefined;
                    break;
                }
                case TEACH_EXIT: 
                case TEACH_APPROACH: {
                    result = separatorDefined && this.isAtlocation(separatorPosition.get());
                    break;
                }
                case MOVE_EXIT: {
                    result = this.palletMotionService.getInternalPoseFromDataModel(this.model, "Approach") != null;
                    break;
                }
                case SHOW_DONE: {
                    result = this.palletMotionService.getInternalPoseFromDataModel(this.model, "Exit") != null;
                }
            }
        }
        return result;
    }

    private String getDisallowedNavigationMessage(WizardAction nextState) {
        return nextState == WizardAction.MOVE_APPROACH ? this.textResource.warningDefineSeparator() : "";
    }

    private MoveDefinition getMoveDefinition() {
        return new MoveDefinition(){

            @Override
            public JointPositionVector getJointPositionVector(String waypointName) {
                JointPositionVector result = null;
                if (waypointName != null) {
                    result = SeparatorActionProgramNodeContribution.this.palletMotionService.getJointPositionVectorFromDataModel(SeparatorActionProgramNodeContribution.this.model, waypointName);
                } else {
                    Optional<Position> separator = SeparatorActionProgramNodeContribution.this.getSeparatorPosition();
                    if (separator.isPresent()) {
                        result = separator.get().getActualJointPositions();
                    }
                }
                return result;
            }

            @Override
            public boolean isAtPosition(String waypointName) {
                JointPositionVector result = null;
                if (waypointName != null) {
                    result = SeparatorActionProgramNodeContribution.this.palletMotionService.getJointPositionVectorFromDataModel(SeparatorActionProgramNodeContribution.this.model, waypointName);
                } else {
                    Optional<Position> separator = SeparatorActionProgramNodeContribution.this.getSeparatorPosition();
                    if (separator.isPresent()) {
                        result = separator.get().getActualJointPositions();
                    }
                }
                return result != null && SeparatorActionProgramNodeContribution.this.isAtlocation(result);
            }
        };
    }

    @Override
    protected Map<String, WaypointNode> createChildren(Feature feature) {
        HashMap<String, WaypointNode> waypointMap = new HashMap<String, WaypointNode>();
        TreeNode rootTreeNode = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        MoveNode approachMoveNode = this.createMoveJNode();
        WaypointNode approachFixedWaypoint = this.createFixedWaypoint("Approach");
        waypointMap.put("Approach", approachFixedWaypoint);
        MoveNode ppMoveNode = this.createMoveLNode(feature);
        WaypointNode ppFixedWaypoint = this.createFixedWaypoint("ToolActionPoint");
        waypointMap.put("ToolActionPoint", ppFixedWaypoint);
        FolderNode gripperActionNode = this.programAPI.getProgramModel().getProgramNodeFactory().createFolderNode();
        gripperActionNode.setName("Tool action");
        MoveNode exitMoveNode = this.createMoveLNode(feature);
        WaypointNode exitFixedWaypoint = this.createFixedWaypoint("Exit");
        waypointMap.put("Exit", exitFixedWaypoint);
        boolean isPalletizing = this.getPallet().isPalletizing();
        try {
            if (isPalletizing) {
                this.addFolder(rootTreeNode, this.textResource.beforeAction());
            }
            TreeNode approachTreeNode = rootTreeNode.addChild((ProgramNode)approachMoveNode);
            approachTreeNode.addChild((ProgramNode)approachFixedWaypoint);
            this.palletFeatureService.setFeatureOnMoveJHack(feature, approachMoveNode);
            TreeNode pptreeNode = rootTreeNode.addChild((ProgramNode)ppMoveNode);
            pptreeNode.addChild((ProgramNode)ppFixedWaypoint);
            rootTreeNode.addChild((ProgramNode)gripperActionNode);
            TreeNode exitTreeNode = rootTreeNode.addChild((ProgramNode)exitMoveNode);
            exitTreeNode.addChild((ProgramNode)exitFixedWaypoint);
            if (!isPalletizing) {
                this.addFolder(rootTreeNode, this.textResource.afterAction());
            }
        }
        catch (TreeStructureException treeStructureException) {
            Log.error((String)"Unable to create child nodes", (Throwable)treeStructureException);
        }
        return waypointMap;
    }

    void next() {
        this.undoRedoManager.recordChanges(() -> {
            WizardAction wizard = this.getWizardState();
            if ((wizard = this.setWizardState(wizard.nextState(), false)) == WizardAction.SHOW_DONE) {
                this.getSeparatorPosition().ifPresent(this::finalizeSubTree);
            }
            this.updateView(false);
        });
    }

    Optional<Position> getSeparatorPosition() {
        Position separator = this.getPallet().getSeparator();
        if (separator != null && separator.isDefined()) {
            return Optional.of(separator);
        }
        return Optional.empty();
    }

    void previous() {
        this.undoRedoManager.recordChanges(() -> {
            this.setWizardState(this.getWizardState().previousState(), false);
            this.updateView(false);
        });
    }

    void cancel() {
        this.undoRedoManager.recordChanges(() -> {
            WizardAction wizard = this.getWizardState();
            if (wizard == WizardAction.SHOW_INFO) {
                this.setWizardState(WizardAction.MANUAL, false);
            } else {
                this.setWizardState(WizardAction.LANDING, false);
            }
            this.resetNode();
            this.getSeparatorPosition().ifPresent(this::initializeChildren);
            this.updateView(false);
        });
    }

    void setInManualMode(boolean inManualMode) {
        this.inManualMode = inManualMode;
    }

    @Override
    protected WizardAction setWizardState(WizardAction newState, boolean undoable) {
        if (undoable) {
            this.undoRedoManager.recordChanges(() -> this.model.set("currentWizardState", newState.name()));
        } else {
            this.model.set("currentWizardState", newState.name());
        }
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        this.toggleTreeLock(root, newState != WizardAction.LANDING && newState != WizardAction.MANUAL && newState != WizardAction.SHOW_DONE);
        return newState;
    }

    @Override
    protected void resetNode() {
        DataModelPosition.removePosition(this.model, "Approach");
        DataModelPosition.removePosition(this.model, "Exit");
        TreeNode root = this.programAPI.getProgramModel().getRootTreeNode((ProgramNodeContribution)this);
        root.getChildren().forEach(child -> {
            try {
                root.removeChild(child);
            }
            catch (TreeStructureException treeStructureException) {
                Log.error((String)"Unable to remove child", (Throwable)treeStructureException);
            }
        });
    }

    private void toggleTreeLock(TreeNode root, boolean lock) {
        root.setChildSequenceLocked(lock);
        for (TreeNode child : root.getChildren()) {
            if (child.getProgramNode() instanceof FolderNode) continue;
            child.setChildSequenceLocked(lock);
            this.toggleTreeLock(child, lock);
        }
    }

    @Override
    public void updateSeparatorPointFeature() {
        PalletProgramFeature separatorFeature = this.getPallet().getSeparatorFeature();
        Position sepeartorPosition = this.getPallet().getSeparator();
        if (sepeartorPosition != null && sepeartorPosition.isDefined() && separatorFeature != null) {
            separatorFeature.setPosition(this.getPallet().getPalletFeatureName(), sepeartorPosition.getToolPosition(), sepeartorPosition.getToolAxisAngle(), sepeartorPosition.getBaseToFeature());
        }
    }
}

