/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.service;

import com.ur.polyscope.pallet.impl.service.InternalPalletUIService;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.geomfeature.ProgramVisualization;
import com.ur.swing.BindingRegistration;
import com.ur.swing.TooltipFactory;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.dialog.WarningDialogCreator;
import com.ur.swing.dialog.WarningMessage;
import javax.inject.Inject;
import javax.swing.JComponent;

public class InternalPalletUIServiceImpl
implements InternalPalletUIService {
    private final WarningDialogCreator warningDialogCreator;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private final WidgetFactory widgetFactory;
    private final TooltipFactory tooltipFactory;
    private final RobotCanvas3DFactory robotCanvas3DFactory;

    @Inject
    public InternalPalletUIServiceImpl(WarningDialogCreator warningDialogCreator, ConfirmationDialogCreator confirmationDialogCreator, WidgetFactory widgetFactory, TooltipFactory tooltipFactory, RobotCanvas3DFactory robotCanvas3DFactory) {
        this.warningDialogCreator = warningDialogCreator;
        this.confirmationDialogCreator = confirmationDialogCreator;
        this.widgetFactory = widgetFactory;
        this.tooltipFactory = tooltipFactory;
        this.robotCanvas3DFactory = robotCanvas3DFactory;
    }

    @Override
    public void warningMessageDialog(WarningMessage warningMessage, OkDialogListener dialogListener) {
        this.warningDialogCreator.showWarningMessageDialog(warningMessage, dialogListener);
    }

    @Override
    public void confirmMessageDialog(ConfirmationMessage message, ConfirmationDialogListener dialogListener) {
        this.confirmationDialogCreator.showConfirmationDialog(message, dialogListener);
    }

    @Override
    public WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    @Override
    public BindingRegistration showTooltip(JComponent component, String message) {
        return this.tooltipFactory.showInformationTooltipCloseAnyClick(component, message);
    }

    @Override
    public RobotCanvas3D createRobotCanvas3d() {
        return this.robotCanvas3DFactory.buildPositionRobot();
    }

    @Override
    public ProgramVisualization createProgramVisualization(RobotCanvas3D robotCanvas3D) {
        ProgramVisualization programVisualization = new ProgramVisualization(robotCanvas3D.isActualCanvas());
        if (robotCanvas3D.isActualCanvas()) {
            robotCanvas3D.addNodeToScene(programVisualization.getElementNode());
        }
        return programVisualization;
    }
}

