/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.util;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.polyscope.urcaps.jointposition.JointPositionUtil;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPosition;
import com.ur.urcap.api.domain.value.jointposition.JointPositionFactory;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.util.logging.Log;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class TypeConversion {
    private static final JointPositionFactory FACTORY;

    private TypeConversion() {
    }

    public static JointPositionVector getPolyScopeJPV(JointPositions jointPositions) {
        JointPosition[] allJointPositions = jointPositions.getAllJointPositions();
        return new JointPositionVector(allJointPositions[0].getPosition(Angle.Unit.RAD), allJointPositions[1].getPosition(Angle.Unit.RAD), allJointPositions[2].getPosition(Angle.Unit.RAD), allJointPositions[3].getPosition(Angle.Unit.RAD), allJointPositions[4].getPosition(Angle.Unit.RAD), allJointPositions[5].getPosition(Angle.Unit.RAD));
    }

    public static JointPositions getURCapJPV(JointPositionVector jointPositionVector) {
        return FACTORY.createJointPositions(jointPositionVector.getJoint(0), jointPositionVector.getJoint(1), jointPositionVector.getJoint(2), jointPositionVector.getJoint(3), jointPositionVector.getJoint(4), jointPositionVector.getJoint(5), Angle.Unit.RAD);
    }

    public static Pose getFromPolyScopePose(Pose6d pose6d, ProgramAPI programAPI) {
        return programAPI.getValueFactoryProvider().getPoseFactory().createPose(pose6d.getX(), pose6d.getY(), pose6d.getZ(), pose6d.getRX(), pose6d.getRY(), pose6d.getRZ(), Length.Unit.M, Angle.Unit.RAD);
    }

    public static Pose6d getPolyScopePose(Pose pose) {
        double[] doubles = pose.toArray(Length.Unit.M, Angle.Unit.RAD);
        return new Pose6d(doubles);
    }

    public static String toScriptCode(String name) {
        return ScriptConverter.toScriptCode((String)name, (boolean)false);
    }

    public static Point3d point3dFromTuple(Tuple3d tuple) {
        return new Point3d(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    static {
        JointPositionFactory instance = null;
        try {
            instance = JointPositionUtil.getFactory();
        }
        catch (NullPointerException npe) {
            Log.error((String)"Was never initialized!");
        }
        finally {
            FACTORY = instance;
        }
    }
}

