/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.pallet.impl.wizard;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.pallet.common.i18n.TextResource;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.impl.position.DataModelPosition;
import com.ur.polyscope.pallet.impl.position.Position;
import com.ur.polyscope.pallet.impl.util.AbstractCustomProgramNodeContribution;
import com.ur.polyscope.pallet.impl.util.TypeConversion;
import com.ur.polyscope.pallet.impl.wizard.WizardAction;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveJMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveLMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.builder.MoveLConfigBuilder;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.FixedPositionDefinedWaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.FixedPositionWaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointNodeConfig;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.validation.ErrorHandler;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.Map;

public abstract class AbstractPalletWizardContribution
extends AbstractCustomProgramNodeContribution {
    public static final String APPROACH_NAME = "Approach";
    public static final String EXIT_NAME = "Exit";
    protected static final String KEY_CURRENT_WIZARD_STATE = "currentWizardState";
    protected static final String ACTION_POINT_NAME = "ToolActionPoint";
    protected static final String TOOL_ACTION_NAME = "Tool action";
    private static final double AUTO_MOVE_EPSILON = 0.05;
    protected final PalletMotionService palletMotionService;
    protected final PalletFeatureService palletFeatureService;
    protected ProgramAPI programAPI;
    protected UndoRedoManager undoRedoManager;
    protected DataModel model;
    protected TextResource textResource;

    protected AbstractPalletWizardContribution(ProgramAPI programAPI, UndoRedoManager undoRedoManager, DataModel model, TextResource textResource, PalletMotionService palletMotionService, PalletFeatureService palletFeatureService) {
        this.programAPI = programAPI;
        this.undoRedoManager = undoRedoManager;
        this.model = model;
        this.textResource = textResource;
        this.palletMotionService = palletMotionService;
        this.palletFeatureService = palletFeatureService;
    }

    protected WizardAction getWizardState() {
        String wizardState = this.model.get(KEY_CURRENT_WIZARD_STATE, "");
        if (!wizardState.isEmpty()) {
            return WizardAction.valueOf(wizardState);
        }
        return WizardAction.LANDING;
    }

    protected abstract WizardAction setWizardState(WizardAction var1, boolean var2);

    protected MoveNode createMoveLNode(Feature feature) {
        ProgramNodeFactory factory = this.programAPI.getProgramModel().getProgramNodeFactory();
        MoveNode moveNode = factory.createMoveNodeNoTemplate();
        moveNode.setConfig((MoveNodeConfig)this.createMoveLConfig(feature, moveNode));
        return moveNode;
    }

    protected MoveLMoveNodeConfig createMoveLConfig(Feature feature, MoveNode moveNode) {
        SimpleValueFactory simpleValueFactory = this.programAPI.getValueFactoryProvider().getSimpleValueFactory();
        Speed toolSpeed = simpleValueFactory.createSpeed(250.0, Speed.Unit.MM_S);
        Acceleration toolAcceleration = simpleValueFactory.createAcceleration(1200.0, Acceleration.Unit.MM_S2);
        MoveLConfigBuilder builder = moveNode.getConfigBuilders().createMoveLConfigBuilder().setToolSpeed(toolSpeed, ErrorHandler.AUTO_CORRECT).setToolAcceleration(toolAcceleration, ErrorHandler.AUTO_CORRECT);
        if (feature != null) {
            builder.setFeature(feature);
        }
        return builder.build();
    }

    protected MoveNode createMoveJNode() {
        ProgramNodeFactory factory = this.programAPI.getProgramModel().getProgramNodeFactory();
        MoveNode moveNode = factory.createMoveNodeNoTemplate();
        MoveJMoveNodeConfig moveJConfig = moveNode.getConfigBuilders().createMoveJConfigBuilder().build();
        moveNode.setConfig((MoveNodeConfig)moveJConfig);
        return moveNode;
    }

    protected WaypointNode createFixedWaypoint(String name) {
        ProgramNodeFactory factory = this.programAPI.getProgramModel().getProgramNodeFactory();
        WaypointNode waypointNode = factory.createWaypointNode(name);
        waypointNode.getConfigFactory().createFixedPositionConfig();
        return waypointNode;
    }

    protected void initializeActionPoint(WaypointNode waypointNode, Position selectedPosition) {
        this.setWaypoint(waypointNode, selectedPosition.getPose(), selectedPosition.getJointPositions(), this.getPoseFromDoubleArray(selectedPosition.getTCPOffset()));
    }

    protected abstract void resetNode();

    public void finalizeSubTree(Position position) {
        this.undoRedoManager.recordChanges(() -> {
            Pose6d internalExitPose;
            Feature feature = this.createFeature();
            Map<String, WaypointNode> waypoints = this.createChildren(feature);
            Pose6d internalApproachPose = this.palletMotionService.getInternalPoseFromDataModel(this.model, APPROACH_NAME);
            if (internalApproachPose != null) {
                Pose approachPose = TypeConversion.getFromPolyScopePose(internalApproachPose, this.programAPI);
                this.setWaypoint(waypoints.get(APPROACH_NAME), approachPose, DataModelPosition.getJointPositions(this.model, APPROACH_NAME), this.getTcpForWaypoint(APPROACH_NAME));
            }
            if ((internalExitPose = this.palletMotionService.getInternalPoseFromDataModel(this.model, EXIT_NAME)) != null) {
                Pose exitPose = TypeConversion.getFromPolyScopePose(internalExitPose, this.programAPI);
                this.setWaypoint(waypoints.get(EXIT_NAME), exitPose, DataModelPosition.getJointPositions(this.model, EXIT_NAME), this.getTcpForWaypoint(EXIT_NAME));
            }
            this.initializeActionPoint(waypoints.get(ACTION_POINT_NAME), position);
        });
    }

    private Pose getTcpForWaypoint(String waypointName) {
        return this.getPoseFromDoubleArray(this.model.get(waypointName + "_" + "TCPOffset", new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
    }

    private Pose getPoseFromDoubleArray(double[] poseArray) {
        if (poseArray == null) {
            poseArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        }
        return TypeConversion.getFromPolyScopePose(new Pose6d(poseArray), this.programAPI);
    }

    protected boolean isWizardSelected() {
        WizardAction wizardState = this.getWizardState();
        return WizardAction.LANDING != wizardState && WizardAction.MANUAL != wizardState;
    }

    public void finish() {
        this.undoRedoManager.recordChanges(() -> {
            this.setWizardState(WizardAction.LANDING, false);
            this.updateView(false);
        });
    }

    public void manual() {
        this.undoRedoManager.recordChanges(() -> {
            this.setWizardState(WizardAction.MANUAL, false);
            this.updateView(false);
        });
    }

    public void wizard() {
        this.undoRedoManager.recordChanges(() -> {
            this.resetNode();
            this.setWizardState(WizardAction.SHOW_INFO, false);
        });
        this.updateView(false);
    }

    protected abstract Map<String, WaypointNode> createChildren(Feature var1);

    protected abstract Feature createFeature();

    protected abstract void updateView(boolean var1);

    protected int commonPrefixLength(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        for (int i = 0; i < minLength; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return i;
        }
        return minLength;
    }

    protected boolean isAtlocation(Position selectedPosition) {
        return this.isAtlocation(selectedPosition.getActualJointPositions());
    }

    protected boolean isAtlocation(JointPositionVector jpv) {
        return RobotState.getLatestRobotState().jointPosition.epsilonEquals(jpv, 0.05);
    }

    private void setWaypoint(WaypointNode waypointNode, Pose pose, JointPositions jointPositions, Pose tcpOffset) {
        FixedPositionWaypointNodeConfig config = (FixedPositionWaypointNodeConfig)waypointNode.getConfig();
        FixedPositionDefinedWaypointNodeConfig fixedPositionConfig = waypointNode.getConfigFactory().createFixedPositionConfig(pose, jointPositions, tcpOffset, config.getBlendParameters(), config.getMotionParameters());
        waypointNode.setConfig((WaypointNodeConfig)fixedPositionConfig);
    }
}

