/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program;

import com.ur.lang.EqualsUtil;
import com.ur.log.logentry.LanguagePack;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.log.logentry.robotmessage.RobotMessageProgramState;
import com.ur.monitor.RobotState;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.system.ShutdownService;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.polyscope.controllerinterface.robotmessage.EditRobotState;
import gui.polyscope.DashBoard;
import gui.program.ProgramRootNode;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;

public class ProgramMessageConsumer
implements RobotMessageConsumer,
EditRobotState {
    private static final String PROGRAM_PAUSED_MSG = "PROGRAM_XXX_PAUSED";
    private static final String PROGRAM_RESUMED_MSG = "PROGRAM_XXX_RESUMED";
    private static final String PROGRAM_STARTED_MSG = "PROGRAM_XXX_STARTED";
    private static final String PROGRAM_STOPPED_MSG = "PROGRAM_XXX_STOPPED";
    private ShutdownService shutdownService;
    private RobotState robotStateToEditHere;

    @Inject
    ProgramMessageConsumer(ShutdownService shutdownService) {
        this.shutdownService = shutdownService;
    }

    public void initialize(RobotState robotStateToEditHere) {
        this.robotStateToEditHere = robotStateToEditHere;
    }

    public boolean sendNotification() {
        return true;
    }

    public int consume(DataInput dataInputStream, int messageLength, RobotMessage robotMessage) throws IOException {
        String scriptName;
        int messageOffset = 0;
        int code = dataInputStream.readInt();
        messageOffset += 4;
        dataInputStream.readInt();
        messageOffset += 4;
        int keyLength = dataInputStream.readUnsignedByte();
        ++messageOffset;
        char[] keydata = new char[keyLength];
        messageOffset = this.readByteStream(dataInputStream, messageOffset, keydata);
        char[] extradata = new char[messageLength - messageOffset];
        messageOffset = this.readByteStream(dataInputStream, messageOffset, extradata);
        robotMessage.title = new String(keydata);
        robotMessage.message = new String(extradata);
        ProgramRootNode program = DashBoard.getProgram();
        this.cropProgramName(robotMessage, program);
        this.handlePowerdownRequest(robotMessage, code);
        ProgramState programState = this.getProgramState(robotMessage);
        robotMessage.setProgramState(this.convert(programState));
        this.updateCurrentProgramName(programState, robotMessage.message);
        String message = robotMessage.message;
        if (program != null && robotMessage.getProgramState() != RobotMessageProgramState.PROHIBITED && robotMessage.message.equals(scriptName = program.getScriptName())) {
            message = program.getName();
        }
        robotMessage.title = this.getTitle(robotMessage.title, message);
        return messageOffset;
    }

    private int readByteStream(DataInput dataInputStream, int messageOffset, char[] keydata) throws IOException {
        int i = 0;
        while (i < keydata.length) {
            keydata[i] = (char)dataInputStream.readUnsignedByte();
            ++messageOffset;
            ++i;
        }
        return messageOffset;
    }

    private void cropProgramName(RobotMessage robotMessage, ProgramRootNode program) {
        String scriptName;
        if (program != null && (scriptName = program.getScriptName()).startsWith(robotMessage.message) && !scriptName.equals(robotMessage.message)) {
            robotMessage.message = scriptName;
        }
    }

    private void handlePowerdownRequest(RobotMessage robotMessage, int code) {
        if ("POWERDOWN_REQUEST".equals(robotMessage.title)) {
            if (robotMessage.source == MessageSource.RTMACHINE && code != 100) {
                this.shutdownService.forceShutdown();
            } else {
                this.shutdownService.requestShutdown();
            }
        }
    }

    private String getTitle(String title, String message) {
        String s = LanguagePack.getControllerKeyText((String)title);
        if (s.contains("XXX")) {
            s = s.replaceAll("XXX", message);
        } else if (message.length() > 0) {
            s = String.valueOf(s) + ": " + message;
        }
        return s;
    }

    private ProgramState getProgramState(RobotMessage robotMessage) {
        ProgramState programState = ProgramState.PROHIBITED;
        if (robotMessage.title.equals(PROGRAM_STARTED_MSG) || robotMessage.title.equals(PROGRAM_RESUMED_MSG)) {
            programState = ProgramState.PLAYING;
        } else if (robotMessage.title.equals(PROGRAM_STOPPED_MSG)) {
            programState = ProgramState.STOPPED;
        } else if (robotMessage.title.equals(PROGRAM_PAUSED_MSG)) {
            programState = ProgramState.PAUSED;
        }
        return programState;
    }

    private RobotMessageProgramState convert(ProgramState programState) {
        return RobotMessageProgramState.valueOf((String)programState.toString());
    }

    private void updateCurrentProgramName(ProgramState programState, String programName) {
        if (EqualsUtil.equalsOneOf((Object)programState, (Object[])new ProgramState[]{ProgramState.PLAYING, ProgramState.PAUSED, ProgramState.STOPPED})) {
            this.robotStateToEditHere.setCurrentProgramName(programName);
            DashBoard.UserProgramStateHandler.handleRobotMessage((ProgramState)programState, (String)programName);
        }
    }
}

