/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program;

import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.RobotMode;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.system.ShutdownVeto;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.swing.dialog.YesNoCancelDialogListener;
import com.ur.util.Waiting;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.view.hmc.ControllerSocketSender;
import com.ur.view.polyscope.persistence.program.ProgramRootNodePersistence;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.SaveProgramService;
import gui.program.ProgramRootNode;
import gui.tools.DialogCreator;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;

public class SaveProgramShutdownVeto
implements ShutdownVeto {
    private final EventManager eventManager;
    private final ProgramModeHolder programModeHolder;
    private final DialogCreator dialogCreator;
    private final SaveProgramService saveProgramService;
    private final ProgramLookupService lookupService;
    private final Provider<RobotMode> robotModeProvider;
    private ProgramRootNodePersistence programRootNodePersistence;
    private Subscription subscription;
    private boolean actionTaken;
    private boolean doShutDown;

    @Inject
    public SaveProgramShutdownVeto(@Source(value=RobotMode.class) Recipe<RobotMode> robotModeRecipe, SaveProgramService saveProgramService, ProgramModeHolder programModeHolder, DialogCreator dialogCreator, EventManager eventManager, ProgramLookupService lookupService, ProgramRootNodePersistence programRootNodePersistence) {
        this.saveProgramService = saveProgramService;
        this.programModeHolder = programModeHolder;
        this.dialogCreator = dialogCreator;
        this.eventManager = eventManager;
        this.lookupService = lookupService;
        this.robotModeProvider = robotModeRecipe.lastProvider();
        this.programRootNodePersistence = programRootNodePersistence;
    }

    public boolean canShutdown() {
        if (!this.saveProgramService.hasChanges()) {
            return true;
        }
        if (((RobotMode)this.robotModeProvider.get()).isProgramRunning()) {
            ControllerSocketSender.sendPauseProgram();
        }
        this.programModeHolder.setMode(ProgramModeHolder.ProgramMode.Unknown);
        this.actionTaken = false;
        this.doShutDown = false;
        this.dialogCreator.showSaveProgramChangesDialog(this.getProgramName(), new YesNoCancelDialogListener(){

            public void onYesClicked() {
                if (SaveProgramShutdownVeto.this.isUnsavedProgram()) {
                    SaveProgramShutdownVeto.this.doShutDown = false;
                    SaveProgramShutdownVeto.this.actionTaken = true;
                    SaveProgramShutdownVeto.this.programRootNodePersistence.saveAs(ProgramRootNodePersistence.EMPTY_ACTION);
                    return;
                }
                SaveProgramShutdownVeto.this.subscription = SaveProgramShutdownVeto.this.eventManager.addStrongListener(ProgramEventListener.class, (Object)new SaveHandler());
                SaveProgramShutdownVeto.this.programRootNodePersistence.save(ProgramRootNodePersistence.EMPTY_ACTION);
            }

            public void onNoClicked() {
                SaveProgramShutdownVeto.this.doShutDown = true;
                SaveProgramShutdownVeto.this.actionTaken = true;
            }

            public void onCancelClicked() {
                SaveProgramShutdownVeto.this.doShutDown = false;
                SaveProgramShutdownVeto.this.actionTaken = true;
            }
        });
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return SaveProgramShutdownVeto.this.actionTaken;
            }
        }, (int)30, (TimeUnit)TimeUnit.DAYS);
        return this.doShutDown;
    }

    private String getProgramName() {
        ProgramRootNode rootNode = this.lookupService.getProgramRootNode();
        return rootNode == null ? "" : rootNode.getName();
    }

    private boolean isUnsavedProgram() {
        ProgramRootNode rootNode = this.lookupService.getProgramRootNode();
        return rootNode == null ? false : !rootNode.hasBeenSaved();
    }

    private class SaveHandler
    extends ProgramEventListener.Template {
        private SaveHandler() {
        }

        public void onPostProgramSave() {
            SaveProgramShutdownVeto.this.subscription.dispose();
            SaveProgramShutdownVeto.this.doShutDown = true;
            SaveProgramShutdownVeto.this.actionTaken = true;
        }
    }
}

