/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.control;

import com.ur.swing.MouseEventActionWrapper;
import com.ur.swing.URFontFactory;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PlayFromSelectionLinePanel
extends JPanel {
    private static final String TRUNCATE_SUFFIX = "...";
    private static final int TRUNCATE_LENGTH = 25;
    private final Icon icon;
    private final String topLabelText;
    private final WidgetFactory widgetFactory;
    private final URFontFactory fontFactory;
    private JLabel updateableLabel;
    private JLabel iconLabel;
    private JPanel textPanel;
    private JLabel topLabel;
    private boolean initialized;
    private MouseListener previousListener;

    public PlayFromSelectionLinePanel(WidgetFactory widgetFactory, URFontFactory fontFactory, Icon icon, String topLabelText) {
        this.widgetFactory = widgetFactory;
        this.fontFactory = fontFactory;
        this.icon = icon;
        this.topLabelText = topLabelText;
    }

    public PlayFromSelectionLinePanel initComponents() {
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.setBorder(new LineBorder(G5LookAndFeel.UNIVERSAL_ROBOTS_BLUE, 2));
        this.iconLabel = this.widgetFactory.createLabel(this.icon);
        this.iconLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.add((Component)this.iconLabel, "Before");
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new BoxLayout(this.textPanel, 3));
        this.add((Component)this.textPanel, "Center");
        this.topLabel = this.widgetFactory.createLabel(this.topLabelText);
        this.topLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Typeface.SANS_SERIF, URFontFactory.Size.DEFAULT));
        this.topLabel.setBorder(new EmptyBorder(5, 2, 0, 25));
        this.textPanel.add(this.topLabel);
        this.textPanel.add(Box.createRigidArea(new Dimension(1, 3)));
        this.updateableLabel = this.widgetFactory.createLabel("");
        this.updateableLabel.setFont(this.fontFactory.getRelativeFont(URFontFactory.Typeface.SANS_SERIF, URFontFactory.Style.BOLD, URFontFactory.Size.DEFAULT));
        this.updateableLabel.setBorder(new EmptyBorder(0, 4, 5, 5));
        this.textPanel.add(this.updateableLabel);
        return this;
    }

    public void setSecondaryLabelText(String text) {
        if (text.length() > 25) {
            text = String.valueOf(text.substring(0, 25 - TRUNCATE_SUFFIX.length() - 1)) + TRUNCATE_SUFFIX;
        }
        this.updateableLabel.setText(text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.iconLabel.setEnabled(enabled);
        this.textPanel.setEnabled(enabled);
        this.topLabel.setEnabled(enabled);
        this.updateableLabel.setEnabled(enabled);
    }

    private void removeListener() {
        if (this.previousListener == null) {
            return;
        }
        this.removeMouseListener(this.previousListener);
        this.iconLabel.removeMouseListener(this.previousListener);
        this.textPanel.removeMouseListener(this.previousListener);
        this.topLabel.removeMouseListener(this.previousListener);
        this.updateableLabel.removeMouseListener(this.previousListener);
    }

    public void setAction(Action action) {
        this.removeListener();
        if (action == null) {
            this.previousListener = null;
            return;
        }
        MouseEventActionWrapper listener = new MouseEventActionWrapper(action);
        this.addMouseListener((MouseListener)listener);
        this.iconLabel.addMouseListener((MouseListener)listener);
        this.textPanel.addMouseListener((MouseListener)listener);
        this.topLabel.addMouseListener((MouseListener)listener);
        this.updateableLabel.addMouseListener((MouseListener)listener);
        this.previousListener = listener;
    }

    void fireAction() {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener ml = mouseListenerArray[n2];
            if (ml instanceof MouseEventActionWrapper) {
                ((MouseEventActionWrapper)ml).actionPerformed(null);
            }
            ++n2;
        }
    }
}

