/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.control;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.program.control.PlayFromSelectionLinePanel;
import com.ur.program.control.ProgramControlsListener;
import com.ur.resources.ViewImageResource;
import com.ur.swing.BindingRegistration;
import com.ur.swing.URFontFactory;
import com.ur.swing.WidgetFactory;
import gui.installation.services.ProgramLookupService;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;

public class PlayFromSelectionPanel
extends JPanel {
    public static final String PLAY_FROM_BEGINNING_NAME = "Play_from_beginning";
    public static final String PLAY_FROM_SELECTION_NAME = "Play_from_selection";
    private final WidgetFactory widgetFactory;
    private final ProgramLookupService programLookupService;
    private final URFontFactory fontFactory;
    private final ProgramControlsListener programControlsListener;
    private final TextResource textResource;
    private boolean initialized;
    private PlayFromSelectionLinePanel playFromStartLine;
    private PlayFromSelectionLinePanel playSelectedLine;
    private BindingRegistration registration;

    @Inject
    public PlayFromSelectionPanel(WidgetFactory widgetFactory, ProgramLookupService programLookupService, URFontFactory fontFactory, ProgramControlsListener programControlsListener, TextResource textResource) {
        this.widgetFactory = widgetFactory;
        this.programLookupService = programLookupService;
        this.fontFactory = fontFactory;
        this.programControlsListener = programControlsListener;
        this.textResource = textResource;
    }

    public PlayFromSelectionPanel initComponents() {
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        this.setLayout(new BoxLayout(this, 3));
        this.playFromStartLine = this.createButtonLine(this.playIcon(), this.textResource.playFromBeginning()).initComponents();
        this.playFromStartLine.setAction(new PlayFromStartAction(this));
        this.playFromStartLine.setName(PLAY_FROM_BEGINNING_NAME);
        this.add(this.playFromStartLine);
        this.add(Box.createRigidArea(new Dimension(1, 10)));
        this.playSelectedLine = this.createButtonLine(this.playSelectedIcon(), this.textResource.playFromSelection()).initComponents();
        this.playSelectedLine.setName(PLAY_FROM_SELECTION_NAME);
        this.add(this.playSelectedLine);
        return this;
    }

    private PlayFromSelectionLinePanel createButtonLine(Icon icon, String topLabelText) {
        return new PlayFromSelectionLinePanel(this.widgetFactory, this.fontFactory, icon, topLabelText);
    }

    public void setBindingRegistration(BindingRegistration registration) {
        this.registration = registration;
    }

    public void updateSelectedNode() {
        AbstractProgramNode selectedNode = this.programLookupService.getSelectedNode();
        if (selectedNode.canStartFromSelection() && selectedNode != this.programLookupService.getProgramRootNode().getMainProgram()) {
            this.playSelectedLine.setSecondaryLabelText(this.buildNodeTitle(selectedNode));
            this.playSelectedLine.setEnabled(true);
            this.playSelectedLine.setAction(new PlaySelectedAction(this));
        } else {
            this.playSelectedLine.setSecondaryLabelText(this.textResource.playFromSelectionNotPossible());
            this.playSelectedLine.setEnabled(false);
            this.playSelectedLine.setAction(null);
        }
        this.playFromStartLine.setSecondaryLabelText(this.programLookupService.getProgramRootNode().getMainProgram().toString());
    }

    private String buildNodeTitle(AbstractProgramNode node) {
        return this.textResource.linePositionTitle(node.getId(), node.toString());
    }

    private Icon playIcon() {
        return ViewImageResource.playDark();
    }

    private Icon playSelectedIcon() {
        return ViewImageResource.playDark();
    }

    void firePlayFromStartLine() {
        this.playFromStartLine.fireAction();
    }

    void firePlaySelectedLine() {
        this.playSelectedLine.fireAction();
    }

    private static abstract class PlayAction
    extends AbstractAction {
        final PlayFromSelectionPanel playFromSelectionPanel;

        PlayAction(PlayFromSelectionPanel playFromSelectionPanel) {
            this.playFromSelectionPanel = playFromSelectionPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.playFromSelectionPanel.programLookupService.getProgramRootNode().setStartingNode(this.getStartingNode());
            this.playFromSelectionPanel.programControlsListener.playButtonPushed();
            if (this.playFromSelectionPanel.registration != null) {
                this.playFromSelectionPanel.registration.removeRegistration();
            }
        }

        protected abstract AbstractProgramNode getStartingNode();
    }

    private static class PlayFromStartAction
    extends PlayAction {
        PlayFromStartAction(PlayFromSelectionPanel playFromSelectionPanel) {
            super(playFromSelectionPanel);
        }

        @Override
        protected AbstractProgramNode getStartingNode() {
            return this.playFromSelectionPanel.programLookupService.getProgramRootNode().getMainProgram();
        }
    }

    private static class PlaySelectedAction
    extends PlayAction {
        PlaySelectedAction(PlayFromSelectionPanel playFromSelectionPanel) {
            super(playFromSelectionPanel);
        }

        @Override
        protected AbstractProgramNode getStartingNode() {
            return this.playFromSelectionPanel.programLookupService.getSelectedNode();
        }
    }
}

