/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.control;

import com.ur.polyscope.program.control.ShowingToolTipListener;
import com.ur.program.control.PlayFromSelectionPanel;
import com.ur.program.control.PlayFromSelectionToolTip;
import com.ur.program.control.ToolTipAnchor;
import com.ur.swing.BindingRegistration;
import com.ur.swing.BindingRegistrationWasClosed;
import com.ur.swing.DisplayMessageFactory;
import com.ur.util.event.EventNotificationService;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.styles.BalloonTipStyle;

public class PlayFromSelectionToolTipImpl
implements PlayFromSelectionToolTip {
    public static final String BALLOON_TIP_NAME = String.valueOf(PlayFromSelectionToolTipImpl.class.getName()) + ".Balloon_Tip";
    private final ToolTipAnchor toolTipAnchor;
    private final PlayFromSelectionPanel playFromSelectionPanel;

    @Inject
    public PlayFromSelectionToolTipImpl(ToolTipAnchor toolTipAnchor, PlayFromSelectionPanel playFromSelectionPanel) {
        this.toolTipAnchor = toolTipAnchor;
        this.playFromSelectionPanel = playFromSelectionPanel.initComponents();
    }

    @Override
    public BindingRegistrationWasClosed showToolTip() {
        this.playFromSelectionPanel.updateSelectedNode();
        BindingRegistrationWasClosed result = DisplayMessageFactory.informationWithoutTimeout((JComponent)this.toolTipAnchor.getToolTipAnchorPoint(), (String)"", (BalloonTip.AttachLocation)BalloonTip.AttachLocation.NORTH, (Dimension)new Dimension(), (JComponent)this.playFromSelectionPanel);
        PlayFromSelectionToolTipImpl.handleToolTipEvents(result);
        this.playFromSelectionPanel.setBindingRegistration((BindingRegistration)result);
        this.updatePanelBackground();
        return result;
    }

    private static void handleToolTipEvents(BindingRegistrationWasClosed result) {
        PlayFromSelectionToolTipImpl.fireToolTipShowing();
        PlayFromSelectionToolTipImpl.monitorWhenClosedAndThenFireToolTipClosed(result);
    }

    private static void monitorWhenClosedAndThenFireToolTipClosed(final BindingRegistrationWasClosed result) {
        SwingWorker<String, String> checkToolTipShowing = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                while (!result.wasClosed()) {
                    TimeUnit.MILLISECONDS.sleep(50L);
                }
                return "OK";
            }

            @Override
            protected void done() {
                PlayFromSelectionToolTipImpl.fireToolTipClosed();
            }
        };
        checkToolTipShowing.execute();
    }

    private static void fireToolTipClosed() {
        EventNotificationService.notify(ShowingToolTipListener.class, ShowingToolTipListener::toolTipClosed);
    }

    private static void fireToolTipShowing() {
        EventNotificationService.notify(ShowingToolTipListener.class, ShowingToolTipListener::toolTipShown);
    }

    private void updatePanelBackground() {
        Container parent = this.playFromSelectionPanel.getParent();
        while (parent != null && !(parent instanceof BalloonTip)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return;
        }
        BalloonTip balloonTip = (BalloonTip)parent;
        BalloonTipStyle balloonTipStyle = balloonTip.getStyle();
        Color newColor = this.playFromSelectionPanel.getBackground();
        if (balloonTipStyle instanceof DisplayMessageFactory.MessageBalloonStyle) {
            newColor = ((DisplayMessageFactory.MessageBalloonStyle)balloonTipStyle).getWarningLevel().getFillColor();
        }
        balloonTip.setCloseButton(null);
        balloonTip.setName(BALLOON_TIP_NAME);
        this.playFromSelectionPanel.setBackground(newColor);
    }
}

