/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.dashboardserver;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.swing.SwingUtil;
import com.ur.util.logging.Log;

public abstract class BaseAction
implements DashBoardAction {
    protected abstract boolean performAction();

    protected abstract String getSuccessReturnString();

    public String execute(String inputLine) {
        PerformProgramAction performProgramAction = new PerformProgramAction(inputLine);
        try {
            SwingUtil.invokeAndWait((Runnable)performProgramAction);
        }
        catch (Exception e) {
            Log.warning((String)("Failed to execute '" + inputLine + "' due exception:"), (Throwable)e);
            return "Failed to execute: " + inputLine;
        }
        if (performProgramAction.wasSuccessful()) {
            return this.getSuccessReturnString();
        }
        return "Failed to execute: " + inputLine;
    }

    private class PerformProgramAction
    implements Runnable {
        private boolean didPerformAction;
        final String requestString;

        PerformProgramAction(String inputLine) {
            this.requestString = inputLine;
        }

        @Override
        public void run() {
            try {
                this.didPerformAction = BaseAction.this.performAction();
                if (!this.didPerformAction) {
                    Log.warning((String)("Failed to execute '" + this.requestString + "'. Is the robot turned on and running, or a program not loaded/playing?"));
                }
            }
            catch (Exception e) {
                this.didPerformAction = false;
                Log.warning((String)("Failure during execution of: '" + this.requestString + "':"), (Throwable)e);
            }
        }

        boolean wasSuccessful() {
            return this.didPerformAction;
        }
    }
}

