/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.dashboardserver;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.filemanager.FileFromDirectory;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.viewfacade.lang.LoadFileCompleted;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.viewfacade.program.ProgramEventType;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.util.logging.LogTime;
import gui.installation.services.ProgramLookupService;
import gui.program.services.ProgramStateService;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.SwingUtilities;

public class LoadProgramAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser LOAD_PROGRAM = new ScriptActionDefinitionParser("load <arg>");
    private final RobotInstallationSite installationSite;
    private final ProgramStateService programStateService;
    private final ProgramLookupService lookupService;
    private final EventManager eventManager;
    private final Set<LoadFileCompleted> loadFileCompletedSet;
    private final FileFromDirectory fileFromDirectory;
    private ControllerInterface controllerInterface;

    @Inject
    public LoadProgramAction(RobotInstallationSite installationSite, ProgramStateService programStateService, ProgramLookupService lookupService, EventManager eventManager, Set<LoadFileCompleted> loadFileCompletedSet, FileFromDirectory fileFromDirectory, ControllerInterface controllerInterface) {
        this.installationSite = installationSite;
        this.programStateService = programStateService;
        this.lookupService = lookupService;
        this.eventManager = eventManager;
        this.loadFileCompletedSet = loadFileCompletedSet;
        this.fileFromDirectory = fileFromDirectory;
        this.controllerInterface = controllerInterface;
    }

    public boolean canHandleMessage(String input) {
        return LOAD_PROGRAM.isMatch(input);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(String inputLine) {
        fileName = LoadProgramAction.LOAD_PROGRAM.getArgument(0, inputLine);
        program = this.fileFromDirectory.programs(fileName);
        if (program.exists() == false) return "File not found: " + fileName;
        this.programStateService.stop();
        try {
            this.doLoadProgram(fileName, program);
            persistanceMetaData = (PersistanceMetaData)this.installationSite.getInstallation().getMetaData(PersistanceMetaData.class);
            var6_6 = "Loading program: " + program.getAbsolutePath() + ", " + persistanceMetaData.file().getAbsolutePath();
            return var6_6;
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Throwable)e);
            var6_7 = "Error while loading program: " + program.getAbsolutePath() + ":" + e.getLocalizedMessage();
            return var6_7;
        }
        finally {
            ** for (each : this.loadFileCompletedSet)
        }
lbl-1000:
        // 1 sources

        {
            each.dispose();
            continue;
        }
lbl18:
        // 1 sources

        return var6_7;
    }

    /*
     * Unable to fully structure code
     */
    protected void doLoadProgram(String fileName, File program) throws Exception {
        block5: {
            loadWithoutKinematicsCheck = new LoadWithoutKinematicsCheck(this.lookupService, this.eventManager, program);
            try {
                for (LoadFileCompleted each : this.loadFileCompletedSet) {
                    each.preparingToLoad(fileName);
                }
                SwingUtilities.invokeAndWait(loadWithoutKinematicsCheck);
                this.verifyInstallationWasLoaded(loadWithoutKinematicsCheck);
            }
            finally {
                if (!this.controllerInterface.isConnected() || !loadWithoutKinematicsCheck.wasInstallationChanged()) break block5;
                ** for (each : this.loadFileCompletedSet)
            }
lbl-1000:
            // 1 sources

            {
                each.completed();
                continue;
            }
        }
    }

    private void verifyInstallationWasLoaded(LoadWithoutKinematicsCheck loadWithoutKinematicsCheck) throws Exception {
        if (loadWithoutKinematicsCheck.didLoadSuccessfully()) {
            return;
        }
        if (loadWithoutKinematicsCheck.getCaughtException() == null) {
            throw new Exception("unknown failure");
        }
        throw loadWithoutKinematicsCheck.getCaughtException();
    }

    private static final class LoadWithoutKinematicsCheck
    implements Runnable,
    ProgramEventListener {
        private final ProgramLookupService lookupService;
        private final EventManager eventManager;
        private final File file;
        private boolean didLoadSuccessfully = false;
        private boolean installationWasChanged = false;
        private Exception caughtException;

        private LoadWithoutKinematicsCheck(ProgramLookupService lookupService, EventManager eventManager, File file) {
            this.lookupService = lookupService;
            this.eventManager = eventManager;
            this.file = file;
        }

        @Override
        public void run() {
            this.didLoadSuccessfully = false;
            this.installationWasChanged = false;
            Subscription programEventSubscription = this.eventManager.addStrongListener(ProgramEventListener.class, (Object)this);
            LogTime.startLog((String)"Process dashboard");
            try {
                try {
                    this.didLoadSuccessfully = this.lookupService.loadWithoutKinematicChecking(this.file);
                }
                catch (Exception e) {
                    this.caughtException = e;
                    Log.error((String)"Failed to load program", (Throwable)e);
                    LogTime.stopLog((String)"Process dashboard");
                    programEventSubscription.dispose();
                }
            }
            finally {
                LogTime.stopLog((String)"Process dashboard");
                programEventSubscription.dispose();
            }
        }

        boolean didLoadSuccessfully() {
            return this.didLoadSuccessfully;
        }

        boolean wasInstallationChanged() {
            return this.installationWasChanged;
        }

        public void handleProgramEvent(ProgramEventType evt) {
            if (evt == ProgramEventType.POST_NEW_INSTALLATION) {
                this.installationWasChanged = true;
            }
        }

        public void handleProgramEvent(ProgramEventType evt, ProgramRootNode programRootNode) {
            this.handleProgramEvent(evt);
        }

        public void handleProgramEvent(ProgramEventType evt, File programFile) {
            this.handleProgramEvent(evt);
        }

        public Exception getCaughtException() {
            return this.caughtException;
        }
    }
}

