/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.dashboardserver;

import com.ur.disk.Directories;
import com.ur.polyscope.viewfacade.lang.LoadFileCompleted;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.StopWatch;

public class TrackLoadTime
implements LoadFileCompleted {
    private StopWatch loadTimer;
    private String program;

    public void preparingToLoad(String fileName) {
        this.program = fileName;
        this.loadTimer = new StopWatch();
        this.loadTimer.start();
    }

    public void completed() {
    }

    public void dispose() {
        this.loadTimer.stop();
        this.saveLoadTime(this.loadTimer, true, this.program);
        this.loadTimer = null;
        this.program = null;
        if (this.didLoadTakeMoreThan10Seconds(this.loadTimer)) {
            throw new RuntimeException("Controller took too long to report loaded - " + this.program);
        }
    }

    private void saveLoadTime(StopWatch loadTimer, boolean loadingSuccessfull, String fileName) {
        block18: {
            FileOutputStream fileOutputStream = null;
            PrintStream printStream = null;
            try {
                try {
                    if (this.didLoadTakeMoreThan10Seconds(loadTimer)) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        String successString = loadingSuccessfull ? "Success: " : "Failure: ";
                        fileOutputStream = new FileOutputStream(new File(Directories.programs(), "hhyLoadTimes.txt"), true);
                        printStream = new PrintStream(fileOutputStream);
                        printStream.println();
                        printStream.append(String.valueOf(dateFormat.format(new Date())) + " :   " + successString + loadTimer.toString() + "    " + fileName);
                        printStream.println();
                    }
                }
                catch (Exception e1) {
                    Log.error((String)("Failed to save load time: " + e1.getMessage()));
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (printStream != null) {
                        printStream.close();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (printStream != null) {
                    printStream.close();
                }
                throw throwable;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    private boolean didLoadTakeMoreThan10Seconds(StopWatch loadTimer) {
        return !loadTimer.toString().split(":")[2].trim().startsWith("0");
    }
}

