/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.menu.ProgramMenuCategory;
import com.ur.program.internal.TextResource;
import com.ur.swing.ViewContext;
import com.ur.swing.baseview.BaseAccordionView;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.LeftOfExtension;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.Optional;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.view.Settings;
import com.ur.view.actions.AddNodeActionFactory;
import com.ur.view.polyscope.module.programs.ProgramContributionProvider;
import com.ur.view.polyscope.module.programs.ProgramModule;
import gui.polyscope.ProgramTab;
import gui.polyscope.contribution.Contribution;
import gui.polyscope.program.ProgramFactorySite;
import gui.program.ContributableProgramNode;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

@Extension(value="EditProgramTree")
@ExtensionPoint(value="AddNodeStructure")
@Singleton
public class AddNodeStructureView
extends BaseAccordionView
implements Menu,
LeftOfExtension {
    private final JPanel basicPanel;
    private final JPanel advancedPanel;
    private final JPanel templatesPanel;
    private final JPanel urcapPanel;
    private JPanel immiPanel;
    private AbstractButton basicSection;
    private AbstractButton immiSection;
    private final AddNodeActionFactory actionFactory;
    private JScrollPane thisScroll;
    private boolean immiPresentAndEnabled = false;

    @Inject
    public AddNodeStructureView(ViewContext viewContext, AddNodeActionFactory actionFactory, ProgramContributionProvider provider, EventManager eventManager, InstallationComponentLookup installationLookupService) {
        super(viewContext);
        this.setLanguage(Settings.getLanguage());
        this.actionFactory = actionFactory;
        TextResource text = (TextResource)viewContext.getTextResource(TextResource.class);
        Optional euromap67o = installationLookupService.get(Immi.class);
        if (euromap67o.isPresent() && ((Immi)euromap67o.get()).isEnabled()) {
            this.immiPresentAndEnabled = true;
        }
        this.basicPanel = this.factory.verticalPanel(new JComponent[0]);
        this.advancedPanel = this.factory.verticalPanel(new JComponent[0]);
        this.templatesPanel = this.factory.verticalPanel(new JComponent[0]);
        this.urcapPanel = this.factory.verticalPanel(new JComponent[0]);
        this.immiPanel = this.factory.verticalPanel(new JComponent[0]);
        this.basicSection = this.addSection(text.basicTab(), this.basicPanel);
        this.basicSection.setName(ProgramTab.BASIC_NODES_SECTION);
        this.addSection(text.advancedTab(), this.advancedPanel).setName(ProgramTab.ADVANCED_NODES_SECTION);
        this.addSection(text.templatesTab(), this.templatesPanel).setName(ProgramTab.WIZARD_NODES_SECTION);
        this.immiSection = this.addSection("IMMI", this.immiPanel);
        this.basicPanel.setBackground(G5LookAndFeel.ADD_NODE_STRUCTURE);
        this.initBasicButtons();
        this.advancedPanel.setBackground(G5LookAndFeel.ADD_NODE_STRUCTURE);
        this.initAdvancedButtons();
        this.templatesPanel.setBackground(G5LookAndFeel.ADD_NODE_STRUCTURE);
        this.initTemplatesButtons();
        this.immiPanel.setBackground(G5LookAndFeel.ADD_NODE_STRUCTURE);
        this.updateImmiSection();
        provider.contributeToProgramFactory((ProgramFactorySite)new NodeFactorySite());
        this.urcapPanel.setBackground(G5LookAndFeel.ADD_NODE_STRUCTURE);
        this.setBackground(G5LookAndFeel.ADD_NODE_STRUCTURE);
        eventManager.addStrongListener(ProgramModeHolder.ProgramModeListener.class, (Object)new ProgramModeHolder.ProgramModeListener(){

            public void changedMode(ProgramModeHolder.ProgramMode newMode) {
                if (newMode == ProgramModeHolder.ProgramMode.Calibration) {
                    this.setAccordianEnabled(false);
                } else {
                    this.setAccordianEnabled(true);
                }
            }

            private void setAccordianEnabled(boolean enabled) {
                this.setAllSubcomponentsEnabled(AddNodeStructureView.this.basicPanel, enabled);
                this.setAllSubcomponentsEnabled(AddNodeStructureView.this.advancedPanel, enabled);
                this.setAllSubcomponentsEnabled(AddNodeStructureView.this.templatesPanel, enabled);
                this.setAllSubcomponentsEnabled(AddNodeStructureView.this.urcapPanel, enabled);
            }

            private void setAllSubcomponentsEnabled(JPanel panel, boolean enabled) {
                panel.setEnabled(enabled);
                Component[] componentArray = panel.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component component = componentArray[n2];
                    component.setEnabled(enabled);
                    ++n2;
                }
            }
        });
        this.thisScroll = new JScrollPane((Component)((Object)this));
        this.thisScroll.setVerticalScrollBarPolicy(20);
        this.thisScroll.setHorizontalScrollBarPolicy(30);
        this.thisScroll.getVerticalScrollBar().setPreferredSize(new Dimension(28, 0));
        this.thisScroll.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 28));
        this.thisScroll.setWheelScrollingEnabled(true);
        EventNotificationService.register((Object)((Object)this), ActiveSafetyChecksumListener.class, (Object)new UpdateImmiChecksumListener(installationLookupService));
    }

    private void updateImmiSection() {
        if (this.immiPresentAndEnabled && this.immiSection == null) {
            this.immiSection = this.addSection("IMMI", this.immiPanel);
            this.immiSection.setName("immmiNodesSection");
        } else if (!this.immiPresentAndEnabled && this.immiSection != null) {
            this.removeSection(this.immiSection);
            this.immiSection = null;
            this.basicSection.doClick();
            this.repaint();
        }
    }

    private void initBasicButtons() {
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddMoveNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddWaypointNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddMoveDirectionNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddWaitNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddSetNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddPopupNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddHaltNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddCommentNodeAction()));
        this.basicPanel.add(this.setupButton(this.actionFactory.createAddFolderNodeAction()));
    }

    private void initAdvancedButtons() {
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddLoopNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddSubProgramNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddAssignmentNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddIfNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddScriptNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddEventNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddThreadNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddSwitchNodeAction()));
        this.advancedPanel.add(this.setupButton(this.actionFactory.createAddTimerNodeAction()));
    }

    private void initTemplatesButtons() {
        this.templatesPanel.add(this.setupButton(this.actionFactory.createAddSeekNodeAction()));
        this.templatesPanel.add(this.setupButton(this.actionFactory.createAddForceNodeAction()));
    }

    public JComponent create() {
        return this.thisScroll;
    }

    private AbstractButton setupButton(Action action) {
        JButton button = (JButton)this.decorateButton(this.factory.createButton(action));
        this.setEnabledListenerForHtmlButton(button);
        return button;
    }

    private void setEnabledListenerForHtmlButton(JButton btn) {
        btn.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof AbstractButton && "enabled".equals(evt.getPropertyName())) {
                    AbstractButton target;
                    target.setForeground((target = (AbstractButton)evt.getSource()).isEnabled() ? UIManager.getColor("Button.foreground") : UIManager.getColor("Button.disabledText"));
                }
            }
        });
    }

    public void addMenuItem(MenuExtension.MenuContribution contribution) {
        AbstractButton button = this.setupButton(contribution.contribution);
        String category = contribution.getCategory();
        if ("basic".equalsIgnoreCase(category)) {
            this.basicPanel.add(button);
        } else if ("advanced".equalsIgnoreCase(category)) {
            this.advancedPanel.add(button);
        } else if ("immi".equalsIgnoreCase(category)) {
            this.immiPanel.add(button);
        } else {
            this.templatesPanel.add(button);
        }
    }

    private class NodeFactorySite
    implements ProgramFactorySite {
        private NodeFactorySite() {
        }

        public void addProgramNodeFactory(ProgramModule.ContributableProgramNodeFactory factory) {
            if (!factory.isDeprecated() && !factory.isNonUserInsertable()) {
                Action contributedAction = AddNodeStructureView.this.actionFactory.createAddContributedProgramNodeFactoryAction(factory);
                AbstractButton button = AddNodeStructureView.this.setupButton(contributedAction);
                if (factory.isThirdParty()) {
                    this.addThirdPartyNode(factory, button);
                } else {
                    this.addInternalNode(factory, button);
                }
            }
        }

        private void addThirdPartyNode(ProgramModule.ContributableProgramNodeFactory factory, AbstractButton button) {
            button.setName(String.valueOf(ProgramTab.URCAPS_NODES_SECTION) + "." + factory.getTitle());
            if (AddNodeStructureView.this.urcapPanel.getParent() == null) {
                AddNodeStructureView.this.addSection("URCaps", AddNodeStructureView.this.urcapPanel).setName(ProgramTab.URCAPS_NODES_SECTION);
            }
            AddNodeStructureView.this.urcapPanel.add(button);
        }

        private void addInternalNode(ProgramModule.ContributableProgramNodeFactory factory, AbstractButton button) {
            ContributableProgramNode node = factory.createNode();
            Contribution contribution = node.getContribution();
            Optional programMenuCategory = contribution.getContributionAs(ProgramMenuCategory.class);
            if (programMenuCategory.isPresent()) {
                ProgramMenuCategory category = (ProgramMenuCategory)programMenuCategory.get();
                switch (category.getProgramMenu()) {
                    case BASIC: {
                        button.setName(String.valueOf(ProgramTab.BASIC_NODES_SECTION) + "." + factory.getTitle());
                        AddNodeStructureView.this.basicPanel.add(button);
                        break;
                    }
                    case ADVANCED: {
                        button.setName(String.valueOf(ProgramTab.ADVANCED_NODES_SECTION) + "." + factory.getTitle());
                        AddNodeStructureView.this.advancedPanel.add(button);
                        break;
                    }
                    case TEMPLATES: {
                        button.setName(String.valueOf(ProgramTab.WIZARD_NODES_SECTION) + "." + factory.getTitle());
                        AddNodeStructureView.this.templatesPanel.add(button);
                    }
                }
            } else {
                button.setName(String.valueOf(ProgramTab.WIZARD_NODES_SECTION) + "." + factory.getTitle());
                AddNodeStructureView.this.templatesPanel.add(button);
            }
        }
    }

    private class UpdateImmiChecksumListener
    implements ActiveSafetyChecksumListener {
        private final InstallationComponentLookup installationLookupService;

        public UpdateImmiChecksumListener(InstallationComponentLookup installationLookupService) {
            this.installationLookupService = installationLookupService;
        }

        public void activeSafetyChecksumChanged(ActiveSafetyChecksumEvent e) {
            Immi immi = (Immi)this.installationLookupService.getComponent(Immi.class);
            AddNodeStructureView.this.immiPresentAndEnabled = immi != null && immi.isEnabled();
            AddNodeStructureView.this.updateImmiSection();
        }
    }
}

