/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.polyscope.program.commandview.ResolveView;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.viewfacade.program.ProgramReadonlyService;
import com.ur.program.edit.infrastructure.CommandTab$AjcClosure1;
import com.ur.program.edit.infrastructure.ProgramNodeReadOnlyPanelWrapper;
import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleAction;
import com.ur.reversible.ReversibleSequence;
import com.ur.reversible.UndoRedoListener;
import com.ur.swing.CardPanel;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.logging.Log;
import com.ur.util.logging.LogTime;
import gui.polyscope.DashBoard;
import gui.polyscope.program.ProgramPanel;
import gui.program.ContributableProgramNode;
import gui.program.MainProgram;
import gui.program.ProgramUndoRedoService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Singleton
public class CommandTab
extends CardPanel
implements TreeSelectionListener {
    public static final String FLIP_COMMAND_CARD = "Flip command card:";
    private static CommandTab commandTabInstance;
    private final transient Set<ResolveView> commandPanelLookup = new HashSet<ResolveView>();
    private final FlippablePanel commandPanel;
    private final transient Provider<ProgramPanel> programPanelProvider;
    private boolean pendingUpdateRequestPresent = false;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        CommandTab.ajc$preClinit();
        commandTabInstance = null;
    }

    @Inject
    CommandTab(Set<ResolveView> viewLookup, Provider<ProgramPanel> programPanelProvider, ProgramReadonlyService readonlyService, ProgramUndoRedoService undoRedoService) {
        this.programPanelProvider = programPanelProvider;
        this.commandPanelLookup.addAll(viewLookup);
        this.commandPanel = new FlippablePanel();
        this.addCardPanels(viewLookup, readonlyService);
        this.setLayout(new BorderLayout());
        this.add((Component)this.commandPanel, "Center");
        this.commandPanel.setCardParent((CardPanel)this);
        undoRedoService.addListener(this.createUIUpdateListener());
        if (commandTabInstance != null) {
            Log.error((String)"Warning, commandTab was instantiated more than once!!!");
        }
        commandTabInstance = this;
    }

    private UndoRedoListener<AbstractProgramNode> createUIUpdateListener() {
        return new UndoRedoListener<AbstractProgramNode>(){

            public void perform(ReversibleAction action, Reversible<AbstractProgramNode> reversible) {
                AbstractProgramNode selected;
                AbstractProgramNode abstractProgramNode = selected = DashBoard.getProgram() == null ? null : ((ProgramSelectionModel)DashBoard.getProgram().getComponent(ProgramSelectionModel.class)).getCurrentNode();
                if (!CommandTab.this.isShowing() || !CommandTab.this.reversibleHasSelectedAsTarget((Reversible<AbstractProgramNode>)reversible, selected)) {
                    return;
                }
                boolean isContributableProgramNode = selected instanceof ContributableProgramNode;
                if (!isContributableProgramNode && (action == ReversibleAction.Consume || action == ReversibleAction.ConsumeNew) || isContributableProgramNode && (action == ReversibleAction.PostUndo || action == ReversibleAction.PostRedo)) {
                    CommandTab.this.showCardLater(selected);
                }
            }
        };
    }

    private boolean reversibleHasSelectedAsTarget(Reversible<AbstractProgramNode> reversible, AbstractProgramNode selected) {
        if (reversible instanceof ReversibleSequence) {
            ReversibleSequence reversibleSequence = (ReversibleSequence)reversible;
            for (Reversible revStep : reversibleSequence) {
                if (revStep.getTarget() != selected) continue;
                return true;
            }
        }
        return reversible.getTarget() == selected;
    }

    public static CommandTab getInstance() {
        return commandTabInstance;
    }

    public void enter(Object o) {
        super.enter(o);
        ((ProgramPanel)this.programPanelProvider.get()).getTree().addTreeSelectionListener(this);
        this.showCommandPanelOfCurrentProgramNode();
    }

    public Object exit() {
        this.commandPanel.exitActiveChild();
        ((ProgramPanel)this.programPanelProvider.get()).getTree().removeTreeSelectionListener(this);
        return super.exit();
    }

    public void showCommandPanelOfCurrentProgramNode() {
        if (!this.pendingUpdateRequestPresent) {
            this.pendingUpdateRequestPresent = true;
            Runnable runme = new Runnable(){

                @Override
                public void run() {
                    LogTime.startLog((String)CommandTab.FLIP_COMMAND_CARD);
                    if (DashBoard.getProgram() != null) {
                        AbstractProgramNode pn = ((ProgramSelectionModel)DashBoard.getProgram().getComponent(ProgramSelectionModel.class)).getCurrentNode();
                        if (pn == null) {
                            pn = CommandTab.this.getProgramNode();
                        }
                        CommandTab.this.showCardLater(pn);
                    }
                    CommandTab.this.pendingUpdateRequestPresent = false;
                    if (CommandTab.this.commandPanel.getCurrentCard() == null) {
                        LogTime.stopLog((String)CommandTab.FLIP_COMMAND_CARD, null);
                    } else {
                        LogTime.stopLog((String)CommandTab.FLIP_COMMAND_CARD, (String)CommandTab.this.commandPanel.getCurrentCard().getClass().getSimpleName());
                    }
                }
            };
            SwingUtilities.invokeLater(runme);
        }
    }

    private AbstractProgramNode getProgramNode() {
        TreeNode o;
        MainProgram pn = null;
        boolean castSuccess = false;
        if (DashBoard.getProgram().getChildCount() > 0 && (o = DashBoard.getProgram().getFirstChild()) instanceof AbstractProgramNode) {
            pn = (AbstractProgramNode)o;
            castSuccess = true;
        }
        if (!castSuccess) {
            pn = DashBoard.getProgram().getMainProgram();
        }
        ((ProgramSelectionModel)DashBoard.getProgram().getComponent(ProgramSelectionModel.class)).setSelected((AbstractProgramNode)pn);
        return pn;
    }

    @IgnoreProgramChanges
    public void showCardFor(AbstractProgramNode node) {
        AbstractProgramNode abstractProgramNode = node;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)abstractProgramNode);
        Object[] objectArray = new Object[]{this, abstractProgramNode, joinPoint};
        CommandTab$AjcClosure1 commandTab$AjcClosure1 = new CommandTab$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(commandTab$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Class<?> unwrapWrapperCardPanel(CardPanel currentCard, Class<?> cardClass) {
        if (cardClass == null) {
            return null;
        }
        if (cardClass.equals(ProgramNodeReadOnlyPanelWrapper.class)) {
            cardClass = ((ProgramNodeReadOnlyPanelWrapper)currentCard).unwrapCardClass();
        }
        return cardClass;
    }

    private Class<?> getCardClass(AbstractProgramNode node) {
        for (ResolveView each : this.commandPanelLookup) {
            if (!each.hasView(node)) continue;
            return each.getViewClass(node);
        }
        return null;
    }

    public void showCardLater(final AbstractProgramNode target) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommandTab.this.showCardFor(target);
            }
        });
    }

    private void addCardPanels(Set<ResolveView> viewLookup, ProgramReadonlyService readonlyService) {
        for (ResolveView each : viewLookup) {
            for (Map.Entry eachPair : each.getSupportedPanels().entrySet()) {
                CardPanel value = (CardPanel)eachPair.getValue();
                value = new ProgramNodeReadOnlyPanelWrapper(readonlyService, value);
                this.commandPanel.addCardPanel((Class)eachPair.getKey(), value);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.showCommandPanelOfCurrentProgramNode();
    }

    static final /* synthetic */ void showCardFor_aroundBody0(CommandTab ajc$this, AbstractProgramNode node, JoinPoint joinPoint) {
        CardPanel currentCard = ajc$this.commandPanel.getCurrentCard();
        Class<?> cardClass = currentCard == null ? null : currentCard.getClass();
        if ((cardClass = ajc$this.unwrapWrapperCardPanel(currentCard, cardClass)) == null) {
            ajc$this.commandPanel.switchTo(ajc$this.getCardClass(node), (Object)node);
        } else if (!ajc$this.getCardClass(node).isAssignableFrom(cardClass)) {
            ajc$this.commandPanel.switchTo(ajc$this.getCardClass(node), (Object)node);
        } else {
            currentCard.exit();
            if (node.getParent() != null) {
                currentCard.enter((Object)node);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CommandTab.java", CommandTab.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showCardFor", "com.ur.program.edit.infrastructure.CommandTab", "com.ur.polyscope.program.nodes.AbstractProgramNode", "node", "", "void"), 174);
    }
}

