/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.program.search.JSearchTextField;
import com.ur.program.search.SearchBackendService;
import com.ur.program.search.SearchListener;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.HeaderExtension;
import com.ur.swing.help.HelpIdAssigner;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.polyscope.program.ProgramPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

@Extension(value="EditProgramTree")
public class EditProgramTreeHeader
implements HeaderExtension {
    private final SearchBackendService searchBackendService;
    private final ProgramPanel panel;
    private HelpIdAssigner helpIdAssigner;

    @Inject
    public EditProgramTreeHeader(SearchBackendService backend, ProgramPanel panel, HelpIdAssigner helpIdAssigner) {
        this.searchBackendService = backend;
        this.panel = panel;
        this.helpIdAssigner = helpIdAssigner;
    }

    public JComponent createHeader() {
        JPanel result = new JPanel();
        JSearchTextField searchPanel = new JSearchTextField(new ControlProgramTreeStructure((Provider)new Provider<ProgramPanel>(){

            public ProgramPanel get() {
                return EditProgramTreeHeader.this.panel;
            }
        }), this.searchBackendService, this.helpIdAssigner);
        this.searchBackendService.setSearchView(searchPanel);
        searchPanel.setClearOnClose();
        searchPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 3, 10, 3), searchPanel.getBorder()));
        searchPanel.registerSearchListener(new SearchListener(){

            @Override
            public void searchWordEvent(String searchWord) {
                EditProgramTreeHeader.this.searchBackendService.beginSearch(searchWord);
                EditProgramTreeHeader.this.panel.getTree().repaint();
            }
        });
        searchPanel.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditProgramTreeHeader.this.searchBackendService.endSearch();
                EditProgramTreeHeader.this.panel.getTree().repaint();
            }
        });
        result.setLayout(new BorderLayout());
        result.add((Component)searchPanel, "Center");
        return result;
    }
}

