/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.program.edit.infrastructure.AddNodeStructureView;
import com.ur.swing.SwingUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class LeftReplacement
extends JPanel {
    private static final int SPACING_IN_PX = 55;
    private final AddNodeStructureView structureView;
    private final List<Tab> tabs = new ArrayList<Tab>();

    @Inject
    LeftReplacement(AddNodeStructureView structureView) {
        this.structureView = structureView;
        List sections = structureView.getTopSections();
        int i = sections.size() - 1;
        while (i >= 0) {
            this.tabs.add(new Tab((AbstractButton)sections.get(i)));
            --i;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LeftReplacement.this.mouseClicked(e);
            }
        });
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        for (final Tab tab : this.tabs) {
            if (!tab.isWithinBounds(e.getY())) continue;
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LeftReplacement.this.structureView.selectTopSection(tab.section);
                }
            });
            return;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(new Font("DejaVu", 1, 16));
        Dimension dim = this.getSize();
        AffineTransform at = AffineTransform.getTranslateInstance(dim.width / 2, dim.height / 2);
        g2d.transform(at);
        AffineTransform oldTransform = g2d.getTransform();
        g2d.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        FontMetrics fontMetrics = g.getFontMetrics();
        int fullHeight = this.getFullTextHeight(fontMetrics);
        int endY = this.getHeight() / 2;
        int y = endY - fullHeight;
        for (Tab tab : this.tabs) {
            g2d.drawString(tab.name, y, 5);
            int width = fontMetrics.stringWidth(tab.name);
            tab.setBounds(endY - y - width - 27, endY - y + 27);
            y += width + 55;
        }
        g2d.setTransform(oldTransform);
    }

    private int getFullTextHeight(FontMetrics fontMetrics) {
        int fullHeight = 30;
        for (Tab tab : this.tabs) {
            fullHeight += fontMetrics.stringWidth(tab.name) + 55;
        }
        return fullHeight -= 55;
    }

    private class Tab {
        private final String name;
        private final AbstractButton section;
        private int startY = -1;
        private int endY = -1;

        private Tab(AbstractButton section) {
            this.section = section;
            this.name = section.getText();
        }

        private void setBounds(int startY, int endY) {
            this.startY = startY;
            this.endY = endY;
        }

        private boolean isWithinBounds(int y) {
            return this.startY <= y && y <= this.endY;
        }
    }
}

