/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.polyscope.filemanager.FileTypePersistence;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.program.edit.infrastructure.ProgramFileAction;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ViewContext;
import com.ur.view.polyscope.persistence.program.ProgramRootNodePersistence;
import gui.polyscope.DashBoard;
import java.awt.event.ActionEvent;
import javax.inject.Inject;

class LoadProgramAction
extends ProgramFileAction {
    private final FileTypePersistence filePersistence;
    private final ProgramModeHolder programModeHolder;
    private ProgramRootNodePersistence programRootNodePersistence;
    private final ViewContext viewContext;

    @Inject
    public LoadProgramAction(FileTypePersistence filePersistence, ProgramModeHolder programModeHolder, ViewContext viewContext, ProgramRootNodePersistence programRootNodePersistence) {
        this.filePersistence = filePersistence;
        this.programModeHolder = programModeHolder;
        this.programRootNodePersistence = programRootNodePersistence;
        this.viewContext = viewContext;
        this.putValue("SmallIcon", ProgramImageResource.programSmall());
        this.putValue("SelectedSmallIcon", ProgramImageResource.programSmallHover());
        this.putValue("Name", ((TextResource)viewContext.getTextResource(TextResource.class)).fileProgram());
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        this.putValue("InternalName", "loadProgram.ProgramFilePersistence");
    }

    public void doActionPerformed(ActionEvent e) {
        Runnable okAction = new Runnable(){

            @Override
            public void run() {
                DashBoard.stopProgram();
                ProgramRootNodePersistence.performAdvancedLoadProgram((com.ur.i18n.TextResource)((com.ur.i18n.TextResource)LoadProgramAction.this.viewContext.getTextResource(com.ur.i18n.TextResource.class)), (FileTypePersistence)LoadProgramAction.this.filePersistence, (ProgramModeHolder)LoadProgramAction.this.programModeHolder);
            }
        };
        this.programRootNodePersistence.requestToSaveUnsavedProgramChanges(okAction);
    }
}

