/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.injection.Builder;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.program.edit.infrastructure.LoadProgramAction;
import com.ur.program.edit.infrastructure.NewProgramAction;
import com.ur.program.edit.infrastructure.ProgramFileAction;
import com.ur.program.edit.infrastructure.SaveAllAction;
import com.ur.program.edit.infrastructure.SaveAsProgramAction;
import com.ur.security.Privilege;
import com.ur.swing.InterceptableAction;
import javax.inject.Inject;
import javax.swing.Action;

public class ProgramFilePersistence {
    public static final String NEW_PROGRAM = "newProgram.ProgramFilePersistence";
    public static final String LOAD_PROGRAM = "loadProgram.ProgramFilePersistence";
    public static final String SAVE_PROGRAM = "saveProgram.ProgramFilePersistence";
    private final Builder builder;
    private final LockActionCreator privilegeDecorator;
    private final Privileges privileges;

    @Inject
    public ProgramFilePersistence(Builder builder, LockActionCreator privilegeDecorator, Privileges privileges) {
        this.builder = builder;
        this.privilegeDecorator = privilegeDecorator;
        this.privileges = privileges;
    }

    public Action createNewProgramAction() {
        return this.decorateProgramFileAction(NewProgramAction.class, LockableRestrictedPoint.EDIT_PROGRAM);
    }

    public Action createLoadProgramAction() {
        return this.decorateProgramFileAction(LoadProgramAction.class, LockableRestrictedPoint.RUN_PROGRAM);
    }

    public Action createSaveAllAction() {
        return this.decorateProgramFileAction(SaveAllAction.class, LockableRestrictedPoint.EDIT_PROGRAM);
    }

    public Action createSaveAsProgramAction() {
        return this.decorateProgramFileAction(SaveAsProgramAction.class, LockableRestrictedPoint.EDIT_PROGRAM);
    }

    private Action decorateProgramFileAction(Class<? extends ProgramFileAction> actionClass, LockableRestrictedPoint restrictedPoint) {
        InterceptableAction action = (InterceptableAction)this.builder.get(actionClass);
        Privilege privilege = this.privileges.getPrivilege((RestrictedPoint)restrictedPoint);
        return this.privilegeDecorator.lockWithPrivilege(action, privilege);
    }
}

