/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.lang.Defense;
import com.ur.polyscope.program.commandview.UpdateCard;
import com.ur.polyscope.viewfacade.program.ProgramReadonlyService;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ProgramNodeReadOnlyPanelWrapper
extends CardPanel {
    private static final String IGNORE_READ_ONLY = "ignore-read-only";
    private List<Component> componentsDisabled = new ArrayList<Component>();
    private final ProgramReadonlyService programReadonlyService;
    private final CardPanel cardPanel;

    protected ProgramNodeReadOnlyPanelWrapper(ProgramReadonlyService programReadonlyService, CardPanel cardPanel) {
        this.programReadonlyService = programReadonlyService;
        this.cardPanel = cardPanel;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)cardPanel, "Center");
    }

    public void setFlipManager(FlipManager flipManager) {
        this.cardPanel.setFlipManager(flipManager);
    }

    public void enter(Object o) {
        Defense.notNull((Object)o, (String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + " entered with: null"));
        super.enter(o);
        this.cardPanel.enter(o);
        if (!this.componentsDisabled.isEmpty() && !this.programReadonlyService.isReadonly()) {
            ProgramNodeReadOnlyPanelWrapper.setEnabledComponents(this.componentsDisabled, true);
            this.componentsDisabled.clear();
        }
        if (this.cardPanel instanceof UpdateCard) {
            ((UpdateCard)this.cardPanel).updateCard(o);
        }
        if (this.programReadonlyService.isReadonly()) {
            ProgramNodeReadOnlyPanelWrapper.setEnabledRecursive((Container)((Object)this), false, this.componentsDisabled);
        }
    }

    public Object exit() {
        Object o = this.cardPanel.exit();
        super.exit();
        return o;
    }

    public Class<?> unwrapCardClass() {
        return this.cardPanel.getClass();
    }

    private static void setEnabledComponents(List<Component> components, boolean enable) {
        for (Component each : components) {
            each.setEnabled(enable);
        }
    }

    private static void setEnabledRecursive(Container container, boolean enable, List<Component> componentsToggled) {
        ProgramNodeReadOnlyPanelWrapper.toggleComponent(container, enable, componentsToggled);
        ProgramNodeReadOnlyPanelWrapper.setEnabledChildren(container, enable, componentsToggled);
    }

    private static void toggleComponent(Component component, boolean enable, List<Component> componentsToggled) {
        if (component.isEnabled() != enable && ProgramNodeReadOnlyPanelWrapper.hasReadonlyProperty(component)) {
            component.setEnabled(enable);
            if (!componentsToggled.contains(component)) {
                componentsToggled.add(component);
            }
        }
    }

    private static boolean hasReadonlyProperty(Component component) {
        return component instanceof JComponent && !Boolean.FALSE.equals(((JComponent)component).getClientProperty(IGNORE_READ_ONLY));
    }

    private static void setEnabledChildren(Container container, boolean enable, List<Component> componentsToggled) {
        Component[] components = container.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            ProgramNodeReadOnlyPanelWrapper.toggleComponent(component, enable, componentsToggled);
            if (component instanceof Container) {
                ProgramNodeReadOnlyPanelWrapper.setEnabledChildren((Container)component, enable, componentsToggled);
            }
            ++i;
        }
    }
}

