/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.swing.CardPanel;
import com.ur.swing.SwingUtil;
import gui.polyscope.program.ProgramPanel;
import gui.polyscope.program.RightTabbedView;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JPanel;

public class RightReplacement
extends JPanel {
    private static final int SPACING_IN_PX = 55;
    private final RightTabbedView rightTabbedView;
    private final List<Tab> tabs = new ArrayList<Tab>();

    @Inject
    RightReplacement(ProgramPanel.ProgramPanelContribution programPanelContribution, RightTabbedView rightTabbedView) {
        this.rightTabbedView = rightTabbedView;
        Map tabsMap = programPanelContribution.getOrderedMap();
        for (CardPanel cardPanel : tabsMap.keySet()) {
            this.tabs.add(new Tab(cardPanel.getClass(), (String)tabsMap.get(cardPanel)));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RightReplacement.this.mouseClicked(e);
            }
        });
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        for (final Tab tab : this.tabs) {
            if (!tab.isWithinBounds(e.getY())) continue;
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    RightReplacement.this.rightTabbedView.selectTab(tab.cardPanelClass);
                }
            });
            return;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(new Font("DejaVu", 1, 16));
        Dimension dim = this.getSize();
        AffineTransform at = AffineTransform.getTranslateInstance(dim.width / 2, dim.height / 2);
        g2d.transform(at);
        AffineTransform originalAt = g2d.getTransform();
        g2d.transform(AffineTransform.getRotateInstance(1.5707963267948966));
        FontMetrics fontMetrics = g.getFontMetrics();
        int startY = -this.getHeight() / 2;
        int y = startY + 30;
        for (Tab tab : this.tabs) {
            g2d.drawString(tab.name, y, 5);
            int width = fontMetrics.stringWidth(tab.name);
            tab.setBounds(y - startY - 27, y - startY + width + 27);
            y += width + 55;
        }
        g2d.setTransform(originalAt);
    }

    private class Tab {
        private final String name;
        private final Class<? extends CardPanel> cardPanelClass;
        private int startY = -1;
        private int endY = -1;

        private Tab(Class<? extends CardPanel> cardPanelClass, String name) {
            this.cardPanelClass = cardPanelClass;
            this.name = name;
        }

        private void setBounds(int startY, int endY) {
            this.startY = startY;
            this.endY = endY;
        }

        private boolean isWithinBounds(int y) {
            return this.startY <= y && y < this.endY;
        }
    }
}

