/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.program.edit.infrastructure.RightReplacement;
import com.ur.program.edit.infrastructure.Toggle;
import com.ur.program.internal.ProgramImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RightToggle
extends Toggle {
    static final int PANEL_WIDTH = 710;
    static final int PANEL_WIDTH_EXTRA = 5;
    static final int REPLACEMENT_WIDTH = 64;
    static final int REPLACEMENT_WIDTH_EXTRA = 7;
    private static final int ICON_BORDER = 5;

    @Inject
    RightToggle(RightReplacement replacement) {
        super(new JPanel(new BorderLayout()), replacement, "East");
    }

    @Override
    public void setParentPanel(JComponent parent) {
        super.setParentPanel(parent);
        this.getPanel().setPreferredSize(new Dimension(710, parent.getHeight()));
        this.getReplacement().setPreferredSize(new Dimension(64, parent.getHeight()));
    }

    @Override
    public void paintToggleIcon(Component c, Graphics g) {
        Icon swipeLeft = ProgramImageResource.swipeLeft();
        Icon swipeRight = ProgramImageResource.swipeRight();
        if (this.isShown()) {
            int swipeRightX = c.getWidth() - 710 - swipeRight.getIconWidth() / 2 - 5;
            int swipeRightY = (c.getHeight() - swipeRight.getIconHeight()) / 2;
            this.paintIcon(c, g, swipeRight, swipeRightX, swipeRightY);
        } else {
            int swipeLeftX = c.getWidth() - 64 - swipeLeft.getIconWidth() / 2 - 7;
            int swipeLeftY = (c.getHeight() - swipeLeft.getIconHeight()) / 2;
            this.paintIcon(c, g, swipeLeft, swipeLeftX, swipeLeftY);
        }
    }

    @Override
    public boolean isIconHit(MouseEvent mouseEvent) {
        int panelX = this.getParentPanel().getWidth() - 710 - 5;
        if (!this.isShown()) {
            panelX = this.getParentPanel().getWidth() - 64 - 7;
        }
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        int width = ProgramImageResource.swipeLeft().getIconWidth();
        int height = ProgramImageResource.swipeLeft().getIconHeight();
        int swipeLeftX = panelX - width / 2;
        int swipeLeftY = (this.getPanel().getHeight() - height) / 2;
        return swipeLeftX - 5 <= x && x <= swipeLeftX + width + 5 && swipeLeftY - 5 <= y && y <= swipeLeftY + height + 5;
    }
}

