/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.program.edit.infrastructure.ProgramFileAction;
import com.ur.program.edit.infrastructure.SaveAllActionInstallationStateListener;
import com.ur.program.edit.infrastructure.SaveAllActionProgramEventListener;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.swing.ActionDefinition;
import com.ur.util.event.EventManager;
import com.ur.view.polyscope.persistence.program.ProgramRootNodePersistence;
import gui.polyscope.SaveProgramService;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SaveAllAction
extends ProgramFileAction {
    private final SaveProgramService saveProgramService;
    private ProgramRootNodePersistence programRootNodePersistence;

    @Inject
    public SaveAllAction(final SaveProgramService saveProgramService, final RobotInstallationSite installationSite, EventManager eventManager, TextResource textResource, ProgramRootNodePersistence programRootNodePersistence) {
        this.saveProgramService = saveProgramService;
        this.programRootNodePersistence = programRootNodePersistence;
        saveProgramService.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SaveAllAction.this.updateSaveIcon(saveProgramService.hasChanges(), installationSite.hasModifications());
            }
        });
        SaveAllActionProgramEventListener programEventListener = new SaveAllActionProgramEventListener(this, installationSite);
        eventManager.addWeakListener((Object)this, ProgramEventListener.class, (Object)programEventListener);
        SaveAllActionInstallationStateListener installationStateListener = new SaveAllActionInstallationStateListener(this, this.saveProgramService);
        eventManager.addWeakListener((Object)this, InstallationStateListener.class, (Object)installationStateListener);
        this.setEnabled(false);
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        this.putValue("SmallIcon", ProgramImageResource.saveSmall());
        this.putValue("SelectedSmallIcon", ProgramImageResource.saveSmallHover());
        this.putValue("Name", textResource.fileSaveAll());
    }

    private void updateSaveIcon(boolean programChanged, boolean installationChanged) {
        boolean enabled;
        boolean bl = enabled = programChanged || installationChanged;
        if (enabled != this.isEnabled()) {
            this.setEnabled(enabled);
        }
    }

    public void doActionPerformed(ActionEvent e) {
        this.programRootNodePersistence.save(ProgramRootNodePersistence.EMPTY_ACTION);
    }
}

