/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.program.edit.infrastructure.LeftToggle;
import com.ur.program.edit.infrastructure.RightToggle;
import com.ur.program.edit.infrastructure.Toggle;
import com.ur.swing.Skin;
import com.ur.swing.Toggleable;
import com.ur.swing.baseview.SidePlaceholders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class SidePanels
extends MouseInputAdapter
implements SidePlaceholders,
Toggleable.RefreshCallback {
    private final Dimension resolution;
    private final Toggle rightToggle;
    private final Toggle leftToggle;
    private JComponent parent;
    private JPanel centerPlaceholder = new JPanel(new BorderLayout());

    @Inject
    public SidePanels(Skin skin, LeftToggle leftToggle, RightToggle rightToggle) {
        this.resolution = skin.getResolution();
        this.leftToggle = leftToggle;
        this.rightToggle = rightToggle;
        leftToggle.setRefreshCallback(this);
        rightToggle.setRefreshCallback(this);
    }

    public void setCenter(JComponent center) {
        this.centerPlaceholder.add((Component)center, "Center");
    }

    public void setParent(JComponent parent) {
        this.parent = parent;
        parent.add((Component)this.centerPlaceholder, "Center");
        this.leftToggle.setParentPanel(parent);
        this.rightToggle.setParentPanel(parent);
    }

    public void setRight(JComponent component) {
        this.rightToggle.putOnPanel(component);
        this.rightToggle.toggle();
    }

    public void setLeft(JComponent component) {
        this.leftToggle.putOnPanel(component);
        this.leftToggle.toggle();
    }

    private void resizeCenter() {
        this.centerPlaceholder.setPreferredSize(new Dimension(this.calculateCenterWidth(), this.centerPlaceholder.getHeight()));
    }

    private int calculateCenterWidth() {
        return this.resolution.width - this.leftToggle.getWidth() - this.rightToggle.getWidth();
    }

    public void refresh() {
        this.resizeCenter();
        this.parent.repaint();
        this.parent.validate();
    }

    public Toggle getRightToggle() {
        return this.rightToggle;
    }

    public Toggle getLeftToggle() {
        return this.leftToggle;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        MouseEvent parentEvent = this.convertMouseEventToParent(e);
        if (parentEvent.getX() < this.leftToggle.getWidth() + 15) {
            this.leftToggle.mouseClicked(parentEvent);
        }
        if (parentEvent.getX() > this.parent.getWidth() - this.rightToggle.getWidth() - 15) {
            this.rightToggle.mouseClicked(parentEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MouseEvent parentEvent = this.convertMouseEventToParent(e);
        if (parentEvent.getX() < this.leftToggle.getWidth() + 15) {
            this.leftToggle.mousePressed(parentEvent);
        }
        if (parentEvent.getX() > this.parent.getWidth() - this.rightToggle.getWidth() - 15) {
            this.rightToggle.mousePressed(parentEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MouseEvent parentEvent = this.convertMouseEventToParent(e);
        this.leftToggle.mouseReleased(parentEvent);
        this.rightToggle.mouseReleased(parentEvent);
    }

    private MouseEvent convertMouseEventToParent(MouseEvent e) {
        Point point = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent);
        return new SidePanelMouseEventWrapper(e, point);
    }

    class SidePanelMouseEventWrapper
    extends MouseEvent {
        private final MouseEvent originalEvent;

        SidePanelMouseEventWrapper(MouseEvent e, Point point) {
            super(SidePanels.this.parent, 0, 0L, 0, point.x, point.y, 1, false);
            this.originalEvent = e;
        }

        @Override
        public void consume() {
            this.originalEvent.consume();
        }
    }
}

