/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.program.internal.TextResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.util.swing.HTML;
import gui.commandpanels.SuppressedCard;
import gui.program.SuppressedNode;
import java.awt.BorderLayout;
import java.net.URL;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SuppressedCardImpl
extends SuppressedCard {
    private static final int MAX_TEXT_WIDTH_IN_PIXELS = 500;
    private final ViewContext viewContext;
    private final TextResource textResource;
    private JTextField commentField;
    private JLabel suppressedLineLabel;

    @Inject
    SuppressedCardImpl(ViewContext viewContext) {
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.initComponents();
        this.assignHelpIds();
        TextFieldUtils.bindTextPicker((JComponent)this.commentField, (TextHolder)new TextHolder(){

            public String getText() {
                return ((SuppressedNode)SuppressedCardImpl.this.getNode()).getCommentString();
            }

            public void setText(String text) {
                ((SuppressedNode)SuppressedCardImpl.this.getNode()).setCommentString(text);
                SuppressedCardImpl.this.updateCard();
            }
        });
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_suppress");
    }

    protected void updateCard() {
        this.commentField.setText(((SuppressedNode)this.getNode()).getCommentString());
        String line = ((SuppressedNode)this.getNode()).toString();
        line = line.substring(1, line.lastIndexOf("'"));
        String nodeText = HTML.truncateLongWordsWithDots((double)500.0, (String)line);
        String labelText = HTML.truncateTextWithDots((double)1000.0, (String)nodeText);
        this.suppressedLineLabel.setText(HTML.html((String)HTML.maxWidth((int)500, (String)("'" + labelText + "'"))));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        this.suppressedLineLabel = new JLabel();
        String image = HTML.image((HTML.Align)HTML.Align.middle, (URL)ViewImageResource.asResource((Icon)ViewImageResource.suppress()));
        String description = HTML.html((String)this.textResource.suppressExplanation(image));
        String comment = HTML.html((String)this.textResource.commentOnThisSuppressedNode());
        this.commentField = new JTextField();
        this.add(this.viewContext.createFormBuilder().headerLabel(this.textResource.Suppress(), new FormBuilder.PanelConstraints[0]).end().label(this.suppressedLineLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().spacer().end().spacer().end().description(description, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS}).end().spacer().end().label(comment, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.commentField, new FormBuilder.PanelConstraints[0]).end().getPanel());
    }
}

